/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AggregateType;
import org.axonframework.messaging.annotation.AggregateTypeParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AggregateTypeParameterResolverFactoryTest {
    private AggregateTypeParameterResolverFactory testSubject;
    private Method aggregateTypeMethod;
    private Method nonAnnotatedMethod;
    private Method integerMethod;

    AggregateTypeParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new AggregateTypeParameterResolverFactory();
        this.aggregateTypeMethod = this.getClass().getMethod("someAggregateTypeMethod", String.class);
        this.nonAnnotatedMethod = this.getClass().getMethod("someNonAnnotatedMethod", String.class);
        this.integerMethod = this.getClass().getMethod("someIntegerMethod", Integer.class);
    }

    public void someAggregateTypeMethod(@AggregateType String aggregateType) {
    }

    public void someNonAnnotatedMethod(String aggregateType) {
    }

    public void someIntegerMethod(@AggregateType Integer messageIdentifier) {
    }

    @Test
    void resolvesToAggregateTypeWhenAnnotatedForDomainEventMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.aggregateTypeMethod, this.aggregateTypeMethod.getParameters(), 0);
        GenericDomainEventMessage eventMessage = new GenericDomainEventMessage("aggregateType", "id", 0L, (Object)"payload");
        Assertions.assertTrue((boolean)resolver.matches((Message)eventMessage));
        Assertions.assertEquals((Object)eventMessage.getType(), (Object)resolver.resolveParameterValue((Message)eventMessage));
    }

    @Test
    void ignoredForNonDomainEventMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.aggregateTypeMethod, this.aggregateTypeMethod.getParameters(), 0);
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertFalse((boolean)resolver.matches((Message)eventMessage));
    }

    @Test
    void ignoredWhenNotAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.nonAnnotatedMethod, this.nonAnnotatedMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void ignoredWhenWrongType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.integerMethod, this.integerMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }
}

