/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerComparator;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class HandlerComparatorTest {
    private MessageHandlingMember<?> stringHandler;
    private MessageHandlingMember<?> objectHandler;
    private MessageHandlingMember<?> longHandler;
    private MessageHandlingMember<?> numberHandler;
    private MessageHandlingMember<?> priorityHandler;
    private MessageHandlingMember<?> stringHandlerReversedOrder;
    private MessageHandlingMember<?> objectHandlerReversedOrder;
    private Comparator<MessageHandlingMember<?>> testSubject;

    HandlerComparatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.stringHandler = new StubMessageHandlingMember(String.class, 0);
        this.objectHandler = new StubMessageHandlingMember(Object.class, 0);
        this.longHandler = new StubMessageHandlingMember(Long.class, 0);
        this.numberHandler = new StubMessageHandlingMember(Number.class, 0);
        this.priorityHandler = new StubMessageHandlingMember(Object.class, 1);
        this.stringHandlerReversedOrder = new ReversedOrderMessageHandlingMember(String.class, 0);
        this.objectHandlerReversedOrder = new ReversedOrderMessageHandlingMember(Object.class, 0);
        this.testSubject = HandlerComparator.instance();
    }

    @RepeatedTest(value=10)
    void handlerOrderIsDeterministic() {
        ArrayList<MessageHandlingMember> handlers = new ArrayList<MessageHandlingMember>(Arrays.asList(this.stringHandler, this.objectHandler, this.longHandler, this.numberHandler, this.priorityHandler, this.stringHandlerReversedOrder, this.objectHandlerReversedOrder));
        ArrayList<MessageHandlingMember> handlers1 = new ArrayList<MessageHandlingMember>(handlers);
        ArrayList<MessageHandlingMember> handlers2 = new ArrayList<MessageHandlingMember>(handlers);
        Collections.shuffle(handlers1, ThreadLocalRandom.current());
        Collections.shuffle(handlers2, ThreadLocalRandom.current());
        handlers1.sort(this.testSubject);
        handlers2.sort(this.testSubject);
        Assertions.assertEquals(handlers1, handlers2);
    }

    @Test
    void subclassesBeforeSuperclasses() {
        Assertions.assertTrue((this.testSubject.compare(this.stringHandler, this.objectHandler) < 0 ? 1 : 0) != 0, (String)"String should appear before Object");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandler, this.stringHandler) > 0 ? 1 : 0) != 0, (String)"String should appear before Object");
        Assertions.assertTrue((this.testSubject.compare(this.numberHandler, this.objectHandler) < 0 ? 1 : 0) != 0, (String)"Number should appear before Object");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandler, this.numberHandler) > 0 ? 1 : 0) != 0, (String)"Number should appear before Object");
        Assertions.assertTrue((this.testSubject.compare(this.longHandler, this.numberHandler) < 0 ? 1 : 0) != 0, (String)"Long should appear before Number");
        Assertions.assertTrue((this.testSubject.compare(this.numberHandler, this.longHandler) > 0 ? 1 : 0) != 0, (String)"Long should appear before Number");
        Assertions.assertTrue((this.testSubject.compare(this.longHandler, this.objectHandler) < 0 ? 1 : 0) != 0, (String)"Long should appear before Object");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandler, this.longHandler) > 0 ? 1 : 0) != 0, (String)"Long should appear before Object");
    }

    @Test
    void handlersIsEqualWithItself() {
        Assertions.assertEquals((int)0, (int)this.testSubject.compare(this.stringHandler, this.stringHandler));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare(this.objectHandler, this.objectHandler));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare(this.longHandler, this.longHandler));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare(this.numberHandler, this.numberHandler));
        Assertions.assertEquals((int)0, (int)this.testSubject.compare(this.priorityHandler, this.priorityHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.stringHandler, this.objectHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.longHandler, this.stringHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.numberHandler, this.stringHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.objectHandler, this.longHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.objectHandler, this.numberHandler));
        Assertions.assertNotEquals((int)0, (int)this.testSubject.compare(this.priorityHandler, this.numberHandler));
    }

    @Test
    void handlersSortedCorrectly() {
        ArrayList<MessageHandlingMember> members = new ArrayList<MessageHandlingMember>(Arrays.asList(this.objectHandler, this.numberHandler, this.stringHandler, this.longHandler));
        members.sort(this.testSubject);
        Assertions.assertTrue((members.indexOf(this.longHandler) < members.indexOf(this.numberHandler) ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)members.indexOf(this.objectHandler));
    }

    @Test
    void notInSameHierarchyUsesPriorityBasedEvaluation() {
        Assertions.assertTrue((this.testSubject.compare(this.priorityHandler, this.stringHandler) < 0 ? 1 : 0) != 0, (String)"priorityHandler should appear before String based on priority");
        Assertions.assertTrue((this.testSubject.compare(this.stringHandler, this.priorityHandler) > 0 ? 1 : 0) != 0, (String)"priorityHandler should appear before String based on priority");
    }

    @Test
    void handlingMembersImplementingReversedOrderHaveThereOrderReversedAmongOneAnother() {
        Assertions.assertTrue((this.testSubject.compare(this.stringHandlerReversedOrder, this.objectHandler) < 0 ? 1 : 0) != 0, (String)"Reversed-order-String handler should appear before Object handler");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandler, this.stringHandlerReversedOrder) > 0 ? 1 : 0) != 0, (String)"Reversed-order-String handler should appear before Object handler");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandlerReversedOrder, this.stringHandler) < 0 ? 1 : 0) != 0, (String)"Reversed-order-Object handler should appear before String handler ");
        Assertions.assertTrue((this.testSubject.compare(this.stringHandler, this.objectHandlerReversedOrder) > 0 ? 1 : 0) != 0, (String)"Reversed-order-Object handler should appear before String handler ");
        Assertions.assertTrue((this.testSubject.compare(this.stringHandlerReversedOrder, this.objectHandlerReversedOrder) > 0 ? 1 : 0) != 0, (String)"Reversed-order-Object handler should appear before reversed-order-String handler");
        Assertions.assertTrue((this.testSubject.compare(this.objectHandlerReversedOrder, this.stringHandlerReversedOrder) < 0 ? 1 : 0) != 0, (String)"Reversed-order-Object handler should appear before reversed-order-String handler");
    }

    private static class ReversedOrderMessageHandlingMember
    implements MessageHandlingMember<Object> {
        private final Class<?> payloadType;
        private final int priority;

        ReversedOrderMessageHandlingMember(Class<?> payloadType, int priority) {
            this.payloadType = payloadType;
            this.priority = priority;
        }

        public Class<?> payloadType() {
            return this.payloadType;
        }

        public int priority() {
            return this.priority;
        }

        public boolean canHandle(@Nonnull Message<?> message) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public boolean canHandleMessageType(@Nonnull Class<? extends Message> messageType) {
            throw new UnsupportedOperationException("Not implemented (yet)");
        }

        public Object handle(@Nonnull Message<?> message, Object target) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public <HT> Optional<HT> unwrap(Class<HT> handlerType) {
            return Optional.empty();
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return false;
        }

        public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
            return Optional.empty();
        }

        public <R> Optional<R> attribute(String attributeKey) {
            return "ResultHandler.resultType".equals(attributeKey) ? Optional.of(Object.class) : Optional.empty();
        }

        public String toString() {
            return "ResultHandler {" + this.payloadType + ", p=" + this.priority + '}';
        }
    }

    private static class StubMessageHandlingMember
    implements MessageHandlingMember<Object> {
        private final Class<?> payloadType;
        private final int priority;

        StubMessageHandlingMember(Class<?> payloadType, int priority) {
            this.payloadType = payloadType;
            this.priority = priority;
        }

        public Class<?> payloadType() {
            return this.payloadType;
        }

        public int priority() {
            return this.priority;
        }

        public boolean canHandle(@Nonnull Message<?> message) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public boolean canHandleMessageType(@Nonnull Class<? extends Message> messageType) {
            throw new UnsupportedOperationException("Not implemented (yet)");
        }

        public Object handle(@Nonnull Message<?> message, Object target) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public <HT> Optional<HT> unwrap(Class<HT> handlerType) {
            return Optional.empty();
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return false;
        }

        public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
            return Optional.empty();
        }

        public <R> Optional<R> attribute(String attributeKey) {
            return Optional.empty();
        }

        public String toString() {
            return "Handler {" + this.payloadType + ", p=" + this.priority + '}';
        }
    }
}

