/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SimpleResourceParameterResolverFactoryTest {
    private static final String TEST_RESOURCE = "testResource";
    private static final Long TEST_RESOURCE2 = 42L;
    private SimpleResourceParameterResolverFactory testSubject;
    private Method messageHandlingMethodWithResourceParameter;
    private Method messageHandlingMethodWithResource2Parameter;
    private Method messageHandlingMethodWithoutResourceParameter;
    private Method messageHandlingMethodWithResourceParameterOfDifferentType;

    SimpleResourceParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new SimpleResourceParameterResolverFactory(Arrays.asList(TEST_RESOURCE, TEST_RESOURCE2));
        this.messageHandlingMethodWithResourceParameter = this.getClass().getMethod("someMessageHandlingMethodWithResource", Message.class, String.class);
        this.messageHandlingMethodWithResource2Parameter = this.getClass().getMethod("someMessageHandlingMethodWithResource2", Message.class, Long.class);
        this.messageHandlingMethodWithoutResourceParameter = this.getClass().getMethod("someMessageHandlingMethodWithoutResource", Message.class);
        this.messageHandlingMethodWithResourceParameterOfDifferentType = this.getClass().getMethod("someMessageHandlingMethodWithResourceOfDifferentType", Message.class, Integer.class);
    }

    public void someMessageHandlingMethodWithResource(Message message, String resource) {
    }

    public void someMessageHandlingMethodWithResource2(Message message, Long resource) {
    }

    public void someMessageHandlingMethodWithoutResource(Message message) {
    }

    public void someMessageHandlingMethodWithResourceOfDifferentType(Message message, Integer resourceOfDifferentType) {
    }

    @Test
    void resolvesToResourceWhenMessageHandlingMethodHasResourceParameter() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageHandlingMethodWithResourceParameter, this.messageHandlingMethodWithResourceParameter.getParameters(), 1);
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)eventMessage));
        Assertions.assertEquals((Object)TEST_RESOURCE, (Object)resolver.resolveParameterValue((Message)eventMessage));
    }

    @Test
    void resolvesToResourceWhenMessageHandlingMethodHasAnotherResourceParameter() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageHandlingMethodWithResource2Parameter, this.messageHandlingMethodWithResource2Parameter.getParameters(), 1);
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)eventMessage));
        Assertions.assertEquals((Object)TEST_RESOURCE2, (Object)resolver.resolveParameterValue((Message)eventMessage));
    }

    @Test
    void ignoredWhenMessageHandlingMethodHasNoResourceParameter() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageHandlingMethodWithoutResourceParameter, this.messageHandlingMethodWithoutResourceParameter.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void ignoredWhenMessageHandlingMethodHasResourceParameterOfDifferentType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageHandlingMethodWithResourceParameterOfDifferentType, this.messageHandlingMethodWithResourceParameterOfDifferentType.getParameters(), 1);
        Assertions.assertNull((Object)resolver);
    }
}

