/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class SequencedDeadLetterQueueTest<M extends Message<?>> {
    private SequencedDeadLetterQueue<M> testSubject;

    @BeforeEach
    void setUp() {
        this.testSubject = this.buildTestSubject();
    }

    protected abstract SequencedDeadLetterQueue<M> buildTestSubject();

    protected abstract long maxSequences();

    protected abstract long maxSequenceSize();

    @Test
    void enqueueAddsDeadLetter() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void enqueueThrowsDeadLetterQueueOverflowExceptionWhenMaxSequencesIsReached() {
        long maxSequences = this.maxSequences();
        Assertions.assertTrue((maxSequences > 0L ? 1 : 0) != 0);
        int i = 0;
        while ((long)i < maxSequences) {
            this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
            ++i;
        }
        Object oneSequenceToMany = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        Assertions.assertThrows(DeadLetterQueueOverflowException.class, () -> this.testSubject.enqueue(oneSequenceToMany, testLetter));
    }

    @Test
    void enqueueThrowsDeadLetterQueueOverflowExceptionWhenMaxSequenceSizeIsReached() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        long maxSequenceSize = this.maxSequenceSize();
        Assertions.assertTrue((maxSequenceSize > 0L ? 1 : 0) != 0);
        int i = 0;
        while ((long)i < maxSequenceSize) {
            this.testSubject.enqueue(testId, this.generateInitialLetter());
            ++i;
        }
        DeadLetter<M> oneLetterToMany = this.generateInitialLetter();
        Assertions.assertThrows(DeadLetterQueueOverflowException.class, () -> this.testSubject.enqueue(testId, oneLetterToMany));
    }

    @Test
    void enqueueIfPresentThrowsDeadLetterQueueOverflowExceptionForFullQueue() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        long maxSequenceSize = this.maxSequenceSize();
        Assertions.assertTrue((maxSequenceSize > 0L ? 1 : 0) != 0);
        int i = 0;
        while ((long)i < maxSequenceSize) {
            this.testSubject.enqueue(testId, this.generateInitialLetter());
            ++i;
        }
        Assertions.assertThrows(DeadLetterQueueOverflowException.class, () -> this.testSubject.enqueueIfPresent(testId, this::generateFollowUpLetter));
    }

    @Test
    void enqueueIfPresentDoesNotEnqueueForEmptyQueue() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        boolean result = this.testSubject.enqueueIfPresent(testId, this::generateFollowUpLetter);
        Assertions.assertFalse((boolean)result);
        Assertions.assertFalse((boolean)this.testSubject.contains(testId));
    }

    @Test
    void enqueueIfPresentDoesNotEnqueueForNonExistentSequenceIdentifier() {
        Object testFirstId = SequencedDeadLetterQueueTest.generateId();
        this.testSubject.enqueue(testFirstId, this.generateInitialLetter());
        Object testSecondId = SequencedDeadLetterQueueTest.generateId();
        boolean result = this.testSubject.enqueueIfPresent(testSecondId, this::generateFollowUpLetter);
        Assertions.assertFalse((boolean)result);
        Assertions.assertTrue((boolean)this.testSubject.contains(testFirstId));
        Assertions.assertFalse((boolean)this.testSubject.contains(testSecondId));
    }

    @Test
    void enqueueIfPresentEnqueuesForExistingSequenceIdentifier() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testFirstLetter = this.generateInitialLetter();
        DeadLetter testSecondLetter = this.generateFollowUpLetter();
        this.testSubject.enqueue(testId, testFirstLetter);
        this.testSubject.enqueueIfPresent(testId, () -> testSecondLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testFirstLetter, (DeadLetter)resultLetters.next());
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testSecondLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void evictDoesNotChangeTheQueueForNonExistentSequenceIdentifier() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        this.testSubject.evict(this.mapToQueueImplementation(this.generateInitialLetter()));
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void evictDoesNotChangeTheQueueForNonExistentLetterIdentifier() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        this.testSubject.evict(this.mapToQueueImplementation(this.generateInitialLetter()));
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(testLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void evictRemovesLetterFromQueue() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        DeadLetter resultLetter = (DeadLetter)resultLetters.next();
        this.assertLetter(testLetter, resultLetter);
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        this.testSubject.evict(resultLetter);
        Assertions.assertFalse((boolean)this.testSubject.contains(testId));
        Assertions.assertFalse((boolean)this.testSubject.deadLetters().iterator().hasNext());
    }

    @Test
    void requeueThrowsNoSuchDeadLetterExceptionForNonExistentSequenceIdentifier() {
        DeadLetter<M> testLetter = this.generateInitialLetter();
        Assertions.assertThrows(NoSuchDeadLetterException.class, () -> this.testSubject.requeue(this.mapToQueueImplementation(testLetter), l -> l));
    }

    @Test
    void requeueThrowsNoSuchDeadLetterExceptionForNonExistentLetterIdentifier() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        DeadLetter<M> otherTestLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertThrows(NoSuchDeadLetterException.class, () -> this.testSubject.requeue(this.mapToQueueImplementation(otherTestLetter), l -> l));
    }

    @Test
    void requeueReentersLetterToQueueWithUpdatedLastTouchedAndCause() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        Throwable testCause = SequencedDeadLetterQueueTest.generateThrowable();
        this.testSubject.enqueue(testId, testLetter);
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        DeadLetter resultLetter = (DeadLetter)resultLetters.next();
        this.assertLetter(testLetter, resultLetter);
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        DeadLetter<M> expectedLetter = this.generateRequeuedLetter(testLetter, testCause);
        this.testSubject.requeue(resultLetter, l -> l.withCause(testCause));
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(expectedLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void containsReturnsTrueForContainedLetter() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        Object otherTestId = SequencedDeadLetterQueueTest.generateId();
        Assertions.assertFalse((boolean)this.testSubject.contains(testId));
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertTrue((boolean)this.testSubject.contains(testId));
        Assertions.assertFalse((boolean)this.testSubject.contains(otherTestId));
    }

    @Test
    void deadLettersInvocationPerSequenceIdentifierReturnsEnqueuedLettersMatchingGivenSequenceIdentifier() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> expected = this.generateInitialLetter();
        Iterator resultIterator = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertFalse((boolean)resultIterator.hasNext());
        this.testSubject.enqueue(testId, expected);
        resultIterator = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultIterator.hasNext());
        this.assertLetter(expected, (DeadLetter)resultIterator.next());
        Assertions.assertFalse((boolean)resultIterator.hasNext());
    }

    @Test
    void deadLettersInvocationReturnsAllEnqueuedDeadLetters() {
        Object thisTestId = SequencedDeadLetterQueueTest.generateId();
        Object thatTestId = SequencedDeadLetterQueueTest.generateId();
        Iterator result = this.testSubject.deadLetters().iterator();
        Assertions.assertFalse((boolean)result.hasNext());
        DeadLetter<M> thisFirstExpected = this.generateInitialLetter();
        DeadLetter<M> thisSecondExpected = this.generateInitialLetter();
        DeadLetter<M> thatFirstExpected = this.generateInitialLetter();
        DeadLetter<M> thatSecondExpected = this.generateInitialLetter();
        this.testSubject.enqueue(thisTestId, thisFirstExpected);
        this.testSubject.enqueue(thatTestId, thatFirstExpected);
        this.testSubject.enqueue(thisTestId, thisSecondExpected);
        this.testSubject.enqueue(thatTestId, thatSecondExpected);
        result = this.testSubject.deadLetters().iterator();
        int count = 0;
        while (result.hasNext()) {
            Iterable sequenceIterator = (Iterable)result.next();
            Iterator resultLetters = sequenceIterator.iterator();
            while (resultLetters.hasNext()) {
                ++count;
                DeadLetter resultLetter = (DeadLetter)resultLetters.next();
                if (this.equals(thisFirstExpected).test(resultLetter)) {
                    this.assertLetter(thisFirstExpected, resultLetter);
                    Assertions.assertTrue((boolean)resultLetters.hasNext());
                    this.assertLetter(thisSecondExpected, (DeadLetter)resultLetters.next());
                    Assertions.assertFalse((boolean)resultLetters.hasNext());
                    continue;
                }
                this.assertLetter(thatFirstExpected, resultLetter);
                Assertions.assertTrue((boolean)resultLetters.hasNext());
                this.assertLetter(thatSecondExpected, (DeadLetter)resultLetters.next());
                Assertions.assertFalse((boolean)resultLetters.hasNext());
            }
        }
        Assertions.assertEquals((int)2, (int)count);
    }

    @Test
    void isFullReturnsTrueAfterMaximumAmountOfSequencesIsReached() {
        Assertions.assertFalse((boolean)this.testSubject.isFull(SequencedDeadLetterQueueTest.generateId()));
        long maxSequences = this.maxSequences();
        Assertions.assertTrue((maxSequences > 0L ? 1 : 0) != 0);
        int i = 0;
        while ((long)i < maxSequences) {
            this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
            ++i;
        }
        Assertions.assertTrue((boolean)this.testSubject.isFull(SequencedDeadLetterQueueTest.generateId()));
    }

    @Test
    void isFullReturnsTrueAfterMaximumSequenceSizeIsReached() {
        Object testId = SequencedDeadLetterQueueTest.generateId();
        Assertions.assertFalse((boolean)this.testSubject.isFull(testId));
        long maxSequenceSize = this.maxSequenceSize();
        Assertions.assertTrue((maxSequenceSize > 0L ? 1 : 0) != 0);
        int i = 0;
        while ((long)i < maxSequenceSize) {
            this.testSubject.enqueue(testId, this.generateInitialLetter());
            ++i;
        }
        Assertions.assertTrue((boolean)this.testSubject.isFull(testId));
    }

    @Test
    void sizeReturnsOverallNumberOfContainedDeadLetters() {
        Assertions.assertEquals((long)0L, (long)this.testSubject.size());
        Object testId = SequencedDeadLetterQueueTest.generateId();
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertEquals((long)1L, (long)this.testSubject.size());
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertEquals((long)2L, (long)this.testSubject.size());
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        Assertions.assertEquals((long)3L, (long)this.testSubject.size());
    }

    @Test
    void sequenceSizeForSequenceIdentifierReturnsTheNumberOfContainedLettersForGivenSequenceIdentifier() {
        Assertions.assertEquals((long)0L, (long)this.testSubject.sequenceSize((Object)"some-id"));
        Object testId = SequencedDeadLetterQueueTest.generateId();
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertEquals((long)0L, (long)this.testSubject.sequenceSize((Object)"some-id"));
        Assertions.assertEquals((long)1L, (long)this.testSubject.sequenceSize(testId));
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertEquals((long)2L, (long)this.testSubject.sequenceSize(testId));
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        Assertions.assertEquals((long)0L, (long)this.testSubject.sequenceSize((Object)"some-id"));
        Assertions.assertEquals((long)2L, (long)this.testSubject.sequenceSize(testId));
    }

    @Test
    void amountOfSequencesReturnsTheNumberOfUniqueSequences() {
        Assertions.assertEquals((long)0L, (long)this.testSubject.amountOfSequences());
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        Assertions.assertEquals((long)1L, (long)this.testSubject.amountOfSequences());
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        Assertions.assertEquals((long)2L, (long)this.testSubject.amountOfSequences());
        Object testId = SequencedDeadLetterQueueTest.generateId();
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        this.testSubject.enqueue(testId, this.generateInitialLetter());
        Assertions.assertEquals((long)3L, (long)this.testSubject.amountOfSequences());
    }

    @Test
    void processInvocationReturnsFalseIfThereAreNoLetters() {
        AtomicBoolean taskInvoked = new AtomicBoolean(false);
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            taskInvoked.set(true);
            return Decisions.evict();
        };
        boolean result = this.testSubject.process(testTask);
        Assertions.assertFalse((boolean)result);
        Assertions.assertFalse((boolean)taskInvoked.get());
    }

    @Test
    void processInvocationReturnsTrueAndEvictsTheLetter() {
        AtomicReference resultLetter = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        boolean result = this.testSubject.process(testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void processInvocationReturnsFalseAndRequeuesTheLetter() {
        AtomicReference resultLetter = new AtomicReference();
        Throwable testThrowable = SequencedDeadLetterQueueTest.generateThrowable();
        MetaData testDiagnostics = MetaData.with((String)"custom-key", (Object)"custom-value");
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.requeue((Throwable)testThrowable, l -> testDiagnostics);
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Instant expectedLastTouched = this.setAndGetTime();
        DeadLetter<M> expectedRequeuedLetter = this.generateRequeuedLetter(testLetter, expectedLastTouched, testThrowable, testDiagnostics);
        boolean result = this.testSubject.process(testTask);
        Assertions.assertFalse((boolean)result);
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(expectedRequeuedLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
    }

    @Test
    void processInvocationInvokesProcessingTaskInLastTouchedOrderOfLetters() {
        AtomicReference resultLetter = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Object testThisId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testThisLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testThisId, testThisLetter);
        this.setAndGetTime(Instant.now().plus(5L, ChronoUnit.SECONDS));
        Object testThatId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testThatLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testThatId, testThatLetter);
        boolean result = this.testSubject.process(testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testThisLetter, (DeadLetter)resultLetter.get());
        result = this.testSubject.process(testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testThatLetter, (DeadLetter)resultLetter.get());
    }

    @Test
    void processInvocationHandlesAllLettersInSequence() {
        AtomicReference resultLetters = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            LinkedList<DeadLetter> sequence = (LinkedList<DeadLetter>)resultLetters.get();
            if (sequence == null) {
                sequence = new LinkedList<DeadLetter>();
            }
            sequence.addLast((DeadLetter)letter);
            resultLetters.set(sequence);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> firstTestLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, firstTestLetter);
        this.setAndGetTime(Instant.now());
        DeadLetter secondTestLetter = this.generateFollowUpLetter();
        this.testSubject.enqueueIfPresent(testId, () -> secondTestLetter);
        this.setAndGetTime(Instant.now());
        DeadLetter thirdTestLetter = this.generateFollowUpLetter();
        this.testSubject.enqueueIfPresent(testId, () -> thirdTestLetter);
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        boolean result = this.testSubject.process(testTask);
        Assertions.assertTrue((boolean)result);
        Deque resultSequence = (Deque)resultLetters.get();
        this.assertLetter(firstTestLetter, (DeadLetter)resultSequence.pollFirst());
        this.assertLetter(secondTestLetter, (DeadLetter)resultSequence.pollFirst());
        this.assertLetter(thirdTestLetter, (DeadLetter)resultSequence.pollFirst());
    }

    @Test
    void processHandlesMassiveAmountOfLettersInSequence() {
        AtomicReference resultLetters = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            LinkedList<DeadLetter> sequence = (LinkedList<DeadLetter>)resultLetters.get();
            if (sequence == null) {
                sequence = new LinkedList<DeadLetter>();
            }
            sequence.addLast((DeadLetter)letter);
            resultLetters.set(sequence);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> firstTestLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, firstTestLetter);
        LinkedList<DeadLetter<M>> expectedOrderList = new LinkedList<DeadLetter<M>>();
        long loopSize = this.maxSequences() - 5L;
        int i = 0;
        while ((long)i < loopSize) {
            DeadLetter deadLetter = this.generateFollowUpLetter();
            expectedOrderList.add(deadLetter);
            this.testSubject.enqueueIfPresent(testId, () -> deadLetter);
            ++i;
        }
        boolean result = this.testSubject.process(testTask);
        Assertions.assertTrue((boolean)result);
        Deque resultSequence = (Deque)resultLetters.get();
        this.assertLetter(firstTestLetter, (DeadLetter)resultSequence.pollFirst());
        int i2 = 0;
        while ((long)i2 < loopSize) {
            this.assertLetter((DeadLetter)expectedOrderList.get(i2), (DeadLetter)resultSequence.pollFirst());
            ++i2;
        }
    }

    @Test
    void processInvocationReturnsFalseIfAllLetterSequencesAreClaimed() throws InterruptedException {
        CountDownLatch isBlocking = new CountDownLatch(1);
        CountDownLatch hasProcessed = new CountDownLatch(1);
        AtomicReference resultLetter = new AtomicReference();
        AtomicBoolean invoked = new AtomicBoolean(false);
        Function<DeadLetter, EnqueueDecision> blockingTask = letter -> {
            try {
                isBlocking.countDown();
                hasProcessed.await(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Function<DeadLetter, EnqueueDecision> nonBlockingTask = letter -> {
            invoked.set(true);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        Thread blockingProcess = new Thread(() -> this.testSubject.process(blockingTask));
        blockingProcess.start();
        Assertions.assertTrue((boolean)isBlocking.await(100L, TimeUnit.MILLISECONDS));
        boolean result = this.testSubject.process(nonBlockingTask);
        Assertions.assertFalse((boolean)result);
        Assertions.assertFalse((boolean)invoked.get());
        hasProcessed.countDown();
        blockingProcess.join();
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
    }

    @Test
    void processWithLetterPredicateReturnsFalseIfThereAreNoMatchingLetters() {
        AtomicBoolean releasedLetter = new AtomicBoolean(false);
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            releasedLetter.set(true);
            return Decisions.evict();
        };
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        boolean result = this.testSubject.process(letter -> false, testTask);
        Assertions.assertFalse((boolean)result);
        Assertions.assertFalse((boolean)releasedLetter.get());
    }

    @Test
    void processWithLetterPredicateInvokesProcessingTaskWithMatchingLetter() {
        AtomicReference resultLetter = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Object testThisId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testThisLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testThisId, testThisLetter);
        Object testThatId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testThatLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testThatId, testThatLetter);
        boolean result = this.testSubject.process(this.equals(testThisLetter), testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testThisLetter, (DeadLetter)resultLetter.get());
        result = this.testSubject.process(this.equals(testThatLetter), testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testThatLetter, (DeadLetter)resultLetter.get());
    }

    private Predicate<DeadLetter<? extends M>> equals(DeadLetter<? extends M> expected) {
        return actual -> expected.message().getIdentifier().equals(actual.message().getIdentifier());
    }

    @Test
    void processWithLetterPredicateReturnsTrueAndEvictsTheLetter() {
        AtomicReference resultLetter = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        Object nonMatchingId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        this.testSubject.enqueue(nonMatchingId, this.generateInitialLetter());
        boolean result = this.testSubject.process(letter -> letter.message().getPayload().equals(testLetter.message().getPayload()), testTask);
        Assertions.assertTrue((boolean)result);
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        Assertions.assertTrue((boolean)this.testSubject.deadLetters().iterator().hasNext());
    }

    @Test
    void processWithLetterPredicateReturnsFalseAndRequeuesTheLetter() {
        this.setAndGetTime();
        AtomicReference resultLetter = new AtomicReference();
        Throwable testThrowable = SequencedDeadLetterQueueTest.generateThrowable();
        MetaData testDiagnostics = MetaData.with((String)"custom-key", (Object)"custom-value");
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            resultLetter.set(letter);
            return Decisions.requeue((Throwable)testThrowable, l -> testDiagnostics);
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        Object nonMatchingId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        this.testSubject.enqueue(nonMatchingId, this.generateInitialLetter());
        Instant expectedLastTouched = this.setAndGetTime();
        DeadLetter<M> expectedRequeuedLetter = this.generateRequeuedLetter(testLetter, expectedLastTouched, testThrowable, testDiagnostics);
        boolean result = this.testSubject.process(this.equals(testLetter), testTask);
        Assertions.assertFalse((boolean)result);
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
        Iterator resultLetters = this.testSubject.deadLetterSequence(testId).iterator();
        Assertions.assertTrue((boolean)resultLetters.hasNext());
        this.assertLetter(expectedRequeuedLetter, (DeadLetter)resultLetters.next());
        Assertions.assertFalse((boolean)resultLetters.hasNext());
        Assertions.assertTrue((boolean)this.testSubject.deadLetters().iterator().hasNext());
    }

    @Test
    void processWithLetterPredicateHandlesAllLettersInSequence() {
        this.setAndGetTime();
        AtomicReference resultLetters = new AtomicReference();
        Function<DeadLetter, EnqueueDecision> testTask = letter -> {
            LinkedList<DeadLetter> sequence = (LinkedList<DeadLetter>)resultLetters.get();
            if (sequence == null) {
                sequence = new LinkedList<DeadLetter>();
            }
            sequence.addLast((DeadLetter)letter);
            resultLetters.set(sequence);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> firstTestLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, firstTestLetter);
        this.setAndGetTime(Instant.now());
        DeadLetter secondTestLetter = this.generateFollowUpLetter();
        this.testSubject.enqueueIfPresent(testId, () -> secondTestLetter);
        this.setAndGetTime(Instant.now());
        DeadLetter thirdTestLetter = this.generateFollowUpLetter();
        this.testSubject.enqueueIfPresent(testId, () -> thirdTestLetter);
        this.testSubject.enqueue(SequencedDeadLetterQueueTest.generateId(), this.generateInitialLetter());
        boolean result = this.testSubject.process(this.equals(firstTestLetter), testTask);
        Assertions.assertTrue((boolean)result);
        Deque resultSequence = (Deque)resultLetters.get();
        this.assertLetter(firstTestLetter, (DeadLetter)resultSequence.pollFirst());
        this.assertLetter(secondTestLetter, (DeadLetter)resultSequence.pollFirst());
        this.assertLetter(thirdTestLetter, (DeadLetter)resultSequence.pollFirst());
    }

    @Test
    void processWithLetterPredicateReturnsFalseIfAllLetterSequencesAreClaimed() throws InterruptedException {
        CountDownLatch isBlocking = new CountDownLatch(1);
        CountDownLatch hasProcessed = new CountDownLatch(1);
        AtomicReference resultLetter = new AtomicReference();
        AtomicBoolean invoked = new AtomicBoolean(false);
        Function<DeadLetter, EnqueueDecision> blockingTask = letter -> {
            try {
                isBlocking.countDown();
                hasProcessed.await(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            resultLetter.set(letter);
            return Decisions.evict();
        };
        Function<DeadLetter, EnqueueDecision> nonBlockingTask = letter -> {
            invoked.set(true);
            return Decisions.evict();
        };
        Object testId = SequencedDeadLetterQueueTest.generateId();
        Object nonMatchingId = SequencedDeadLetterQueueTest.generateId();
        DeadLetter<M> testLetter = this.generateInitialLetter();
        this.testSubject.enqueue(testId, testLetter);
        this.testSubject.enqueue(nonMatchingId, this.generateInitialLetter());
        Thread blockingProcess = new Thread(() -> this.testSubject.process(this.equals(testLetter), blockingTask));
        blockingProcess.start();
        Assertions.assertTrue((boolean)isBlocking.await(100L, TimeUnit.MILLISECONDS));
        boolean result = this.testSubject.process(this.equals(testLetter), nonBlockingTask);
        Assertions.assertFalse((boolean)result);
        Assertions.assertFalse((boolean)invoked.get());
        hasProcessed.countDown();
        blockingProcess.join();
        this.assertLetter(testLetter, (DeadLetter)resultLetter.get());
    }

    @Test
    void clearInvocationRemovesAllEntries() {
        Object idOne = SequencedDeadLetterQueueTest.generateId();
        Object idTwo = SequencedDeadLetterQueueTest.generateId();
        Object idThree = SequencedDeadLetterQueueTest.generateId();
        Assertions.assertFalse((boolean)this.testSubject.contains(idOne));
        Assertions.assertFalse((boolean)this.testSubject.contains(idTwo));
        Assertions.assertFalse((boolean)this.testSubject.contains(idThree));
        this.testSubject.enqueue(idOne, this.generateInitialLetter());
        this.testSubject.enqueue(idTwo, this.generateInitialLetter());
        this.testSubject.enqueue(idThree, this.generateInitialLetter());
        Assertions.assertTrue((boolean)this.testSubject.contains(idOne));
        Assertions.assertTrue((boolean)this.testSubject.contains(idTwo));
        Assertions.assertTrue((boolean)this.testSubject.contains(idThree));
        this.testSubject.clear();
        Assertions.assertFalse((boolean)this.testSubject.contains(idOne));
        Assertions.assertFalse((boolean)this.testSubject.contains(idTwo));
        Assertions.assertFalse((boolean)this.testSubject.contains(idThree));
    }

    protected static Object generateId() {
        return UUID.randomUUID().toString();
    }

    protected static EventMessage<String> generateEvent() {
        return GenericEventMessage.asEventMessage((Object)("Then this happened..." + UUID.randomUUID()));
    }

    protected static Throwable generateThrowable() {
        return new RuntimeException("Because..." + SequencedDeadLetterQueueTest.generateId());
    }

    protected abstract DeadLetter<M> generateInitialLetter();

    protected abstract DeadLetter<M> generateFollowUpLetter();

    protected DeadLetter<M> mapToQueueImplementation(DeadLetter<M> deadLetter) {
        return deadLetter;
    }

    protected DeadLetter<M> generateRequeuedLetter(DeadLetter<M> original, Throwable requeueCause) {
        Instant lastTouched = this.setAndGetTime();
        return this.generateRequeuedLetter(original, lastTouched, requeueCause, MetaData.emptyInstance());
    }

    protected abstract DeadLetter<M> generateRequeuedLetter(DeadLetter<M> var1, Instant var2, Throwable var3, MetaData var4);

    protected Instant setAndGetTime() {
        return this.setAndGetTime(Instant.now());
    }

    protected Instant setAndGetTime(Instant time) {
        this.setClock(Clock.fixed(time, ZoneId.systemDefault()));
        return time;
    }

    protected abstract void setClock(Clock var1);

    protected void assertLetter(DeadLetter<? extends M> expected, DeadLetter<? extends M> actual) {
        Assertions.assertEquals((Object)expected.message(), (Object)actual.message());
        Assertions.assertEquals((Object)expected.cause(), (Object)actual.cause());
        Assertions.assertEquals((Object)expected.enqueuedAt(), (Object)actual.enqueuedAt());
        Assertions.assertEquals((Object)expected.lastTouched(), (Object)actual.lastTouched());
        Assertions.assertEquals((Object)expected.diagnostics(), (Object)actual.diagnostics());
    }
}

