/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.axonframework.messaging.responsetypes.AbstractResponseTypeTest;
import org.axonframework.messaging.responsetypes.MultipleInstancesResponseType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultipleInstancesResponseTypeTest
extends AbstractResponseTypeTest<List<AbstractResponseTypeTest.QueryResponse>> {
    protected static final Integer MATCHES_LIST = 1024;

    public MultipleInstancesResponseTypeTest() {
        super(new MultipleInstancesResponseType(AbstractResponseTypeTest.QueryResponse.class));
    }

    @Test
    void matchesReturnsMatchSingleIfResponseTypeIsOfTheSame() throws NoSuchMethodException {
        this.testMatchRanked("someQuery", MATCHES);
    }

    @Test
    void matchesReturnsMatchSingleIfResponseTypeIsSubTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubTypedQuery", MATCHES);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSuperTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperTypedQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGeneric() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsSingleMatchIfResponseTypeIsBoundedGenericOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericQuery", MATCHES);
    }

    @Test
    void matchesReturnsSingleMatchIfResponseTypeIsMultiBoundedGenericOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericQuery", MATCHES);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someArrayQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsArrayWithSubTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubTypedArrayQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsArrayWithSuperTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperTypedArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericArray() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsBoundedGenericArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericArrayQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsMultiBoundedGenericArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericArrayQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericArrayOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsSubListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSuperListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsBoundedGenericListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsMultiBoundedGenericListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericListOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsLowerBoundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someLowerBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someUpperBoundedWildcardListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsWildcardListOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingUpperBoundedWildcardQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericUpperBoundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericUpperBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsGenericUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someGenericUpperBoundedWildcardListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsMultiGenericUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiGenericUpperBoundedWildcardListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someListImplementationQuery", MATCHES_LIST);
    }

    public static QueryResponseList someListImplementationQuery() {
        return new QueryResponseList();
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsBoundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedListImplementationQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiUnboundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiUnboundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsMultiBoundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedListImplementationQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsSetOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSetQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsStreamOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someStreamQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMapOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMapQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsSingleMatchIfResponseTypeIsFutureOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someFutureQuery", MATCHES);
    }

    @Test
    void matchesReturnsListMatchIfResponseTypeIsListOfFutureOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someFutureListQuery", MATCHES_LIST);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsOptionalOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someOptionalQueryResponse", MATCHES);
    }

    @Test
    void convertReturnsListForSingleInstanceResponse() {
        AbstractResponseTypeTest.QueryResponse testResponse = new AbstractResponseTypeTest.QueryResponse();
        List result = (List)this.testSubject.convert((Object)testResponse);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)testResponse, result.get(0));
    }

    @Test
    void convertReturnsListOnResponseOfArrayType() {
        AbstractResponseTypeTest.QueryResponse[] testResponse = new AbstractResponseTypeTest.QueryResponse[]{new AbstractResponseTypeTest.QueryResponse()};
        List result = (List)this.testSubject.convert((Object)testResponse);
        Assertions.assertEquals((int)testResponse.length, (int)result.size());
        Assertions.assertEquals((Object)testResponse[0], result.get(0));
    }

    @Test
    void convertReturnsListOnResponseOfSubTypedArrayType() {
        AbstractResponseTypeTest.SubTypedQueryResponse[] testResponse = new AbstractResponseTypeTest.SubTypedQueryResponse[]{new AbstractResponseTypeTest.SubTypedQueryResponse()};
        List result = (List)this.testSubject.convert((Object)testResponse);
        Assertions.assertEquals((int)testResponse.length, (int)result.size());
        Assertions.assertEquals((Object)testResponse[0], result.get(0));
    }

    @Test
    void convertThrowsExceptionForResponseOfDifferentArrayType() {
        AbstractResponseTypeTest.QueryResponseInterface[] testResponse = new AbstractResponseTypeTest.QueryResponseInterface[]{new AbstractResponseTypeTest.QueryResponseInterface(){}};
        Assertions.assertThrows(Exception.class, () -> {
            List cfr_ignored_0 = (List)this.testSubject.convert((Object)testResponse);
        });
    }

    @Test
    void convertReturnsListOnResponseOfListType() {
        ArrayList<AbstractResponseTypeTest.QueryResponse> testResponse = new ArrayList<AbstractResponseTypeTest.QueryResponse>();
        testResponse.add(new AbstractResponseTypeTest.QueryResponse());
        List result = (List)this.testSubject.convert(testResponse);
        Assertions.assertEquals((int)testResponse.size(), (int)result.size());
        Assertions.assertEquals(testResponse.get(0), result.get(0));
    }

    @Test
    void convertReturnsListOnResponseOfSubTypedListType() {
        ArrayList<AbstractResponseTypeTest.SubTypedQueryResponse> testResponse = new ArrayList<AbstractResponseTypeTest.SubTypedQueryResponse>();
        testResponse.add(new AbstractResponseTypeTest.SubTypedQueryResponse());
        List result = (List)this.testSubject.convert(testResponse);
        Assertions.assertEquals((int)testResponse.size(), (int)result.size());
        Assertions.assertEquals(testResponse.get(0), result.get(0));
    }

    @Test
    void convertReturnsListOnResponseOfSetType() {
        HashSet<AbstractResponseTypeTest.QueryResponse> testResponse = new HashSet<AbstractResponseTypeTest.QueryResponse>();
        testResponse.add(new AbstractResponseTypeTest.QueryResponse());
        List result = (List)this.testSubject.convert(testResponse);
        Assertions.assertEquals((int)testResponse.size(), (int)result.size());
        Assertions.assertEquals(testResponse.iterator().next(), result.get(0));
    }

    @Test
    void convertThrowsExceptionForResponseOfDifferentListType() {
        ArrayList<2> testResponse = new ArrayList<2>();
        testResponse.add(new AbstractResponseTypeTest.QueryResponseInterface(){});
        Assertions.assertThrows(Exception.class, () -> {
            List cfr_ignored_0 = (List)this.testSubject.convert((Object)testResponse);
        });
    }

    @Test
    void convertReturnsEmptyListForResponseOfDifferentListTypeIfTheListIsEmpty() {
        ArrayList testResponse = new ArrayList();
        List result = (List)this.testSubject.convert(testResponse);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    static class QueryResponseList
    extends ArrayList<AbstractResponseTypeTest.QueryResponse> {
        QueryResponseList() {
        }
    }
}

