/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.InstanceResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

class DefaultQueryGatewayTest {
    private QueryBus mockBus;
    private DefaultQueryGateway testSubject;
    private QueryResponseMessage<String> answer;

    DefaultQueryGatewayTest() {
    }

    @BeforeEach
    void setUp() {
        this.answer = new GenericQueryResponseMessage((Object)"answer");
        MessageDispatchInterceptor mockDispatchInterceptor = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        this.mockBus = (QueryBus)Mockito.mock(QueryBus.class);
        this.testSubject = DefaultQueryGateway.builder().queryBus(this.mockBus).dispatchInterceptors(new MessageDispatchInterceptor[]{mockDispatchInterceptor}).build();
        Mockito.when((Object)mockDispatchInterceptor.handle((Message)Mockito.isA(QueryMessage.class))).thenAnswer(i -> i.getArguments()[0]);
    }

    @Test
    void pointToPointQuery() throws Exception {
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(this.answer));
        CompletableFuture queryResponse = this.testSubject.query((Object)"query", String.class);
        Assertions.assertEquals((Object)"answer", queryResponse.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).query((QueryMessage)queryMessageCaptor.capture());
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"query", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void pointToPointQuerySpecifyingQueryName() throws Exception {
        String expectedQueryName = "myQueryName";
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(this.answer));
        CompletableFuture queryResponse = this.testSubject.query(expectedQueryName, (Object)"query", String.class);
        Assertions.assertEquals((Object)"answer", queryResponse.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).query((QueryMessage)queryMessageCaptor.capture());
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"query", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)expectedQueryName, (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void pointToPointQueryWithMetaData() throws Exception {
        String expectedMetaDataKey = "key";
        String expectedMetaDataValue = "value";
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(this.answer));
        GenericMessage testQuery = new GenericMessage((Object)"query", (Map)MetaData.with((String)expectedMetaDataKey, (Object)expectedMetaDataValue));
        CompletableFuture queryResponse = this.testSubject.query((Object)testQuery, ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals((Object)"answer", queryResponse.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).query((QueryMessage)queryMessageCaptor.capture());
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"query", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        MetaData resultMetaData = result.getMetaData();
        Assertions.assertTrue((boolean)resultMetaData.containsKey((Object)expectedMetaDataKey));
        Assertions.assertTrue((boolean)resultMetaData.containsValue((Object)expectedMetaDataValue));
    }

    @Test
    void pointToPointQueryWhenQueryBusReportsAnError() throws Exception {
        Throwable expected = new Throwable("oops");
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(new GenericQueryResponseMessage(String.class, expected)));
        CompletableFuture result = this.testSubject.query((Object)"query", String.class);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)expected.getMessage(), ((CompletableFuture)result.exceptionally(Throwable::getMessage)).get());
    }

    @Test
    void pointToPointQueryWhenClientCancelQuery() {
        CompletableFuture queryBusFutureResult = new CompletableFuture();
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(queryBusFutureResult);
        CompletableFuture result = this.testSubject.query((Object)"query", String.class);
        Assertions.assertFalse((boolean)queryBusFutureResult.isDone());
        result.cancel(true);
        Assertions.assertTrue((boolean)queryBusFutureResult.isDone());
        Assertions.assertTrue((boolean)queryBusFutureResult.isCancelled());
    }

    @Test
    void pointToPointQueryWhenQueryBusThrowsException() throws Exception {
        Throwable expected = new Throwable("oops");
        CompletableFuture queryResponseCompletableFuture = new CompletableFuture();
        queryResponseCompletableFuture.completeExceptionally(expected);
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(queryResponseCompletableFuture);
        CompletableFuture result = this.testSubject.query((Object)"query", String.class);
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        Assertions.assertEquals((Object)expected.getMessage(), ((CompletableFuture)result.exceptionally(Throwable::getMessage)).get());
    }

    @Test
    void scatterGatherQuery() {
        long expectedTimeout = 1L;
        TimeUnit expectedTimeUnit = TimeUnit.SECONDS;
        Mockito.when((Object)this.mockBus.scatterGather(this.anyMessage(String.class, String.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).thenReturn(Stream.of(this.answer));
        Stream queryResponse = this.testSubject.scatterGather((Object)"scatterGather", ResponseTypes.instanceOf(String.class), expectedTimeout, expectedTimeUnit);
        Optional firstResult = queryResponse.findFirst();
        Assertions.assertTrue((boolean)firstResult.isPresent());
        Assertions.assertEquals((Object)"answer", firstResult.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).scatterGather((QueryMessage)queryMessageCaptor.capture(), Mockito.eq((long)expectedTimeout), (TimeUnit)((Object)Mockito.eq((Object)((Object)expectedTimeUnit))));
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"scatterGather", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void scatterGatherQuerySpecifyingQueryName() {
        String expectedQueryName = "myQueryName";
        long expectedTimeout = 1L;
        TimeUnit expectedTimeUnit = TimeUnit.SECONDS;
        Mockito.when((Object)this.mockBus.scatterGather(this.anyMessage(String.class, String.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).thenReturn(Stream.of(this.answer));
        Stream queryResponse = this.testSubject.scatterGather(expectedQueryName, (Object)"scatterGather", ResponseTypes.instanceOf(String.class), expectedTimeout, expectedTimeUnit);
        Optional firstResult = queryResponse.findFirst();
        Assertions.assertTrue((boolean)firstResult.isPresent());
        Assertions.assertEquals((Object)"answer", firstResult.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).scatterGather((QueryMessage)queryMessageCaptor.capture(), Mockito.eq((long)expectedTimeout), (TimeUnit)((Object)Mockito.eq((Object)((Object)expectedTimeUnit))));
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"scatterGather", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)expectedQueryName, (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void scatterGatherQueryWithMetaData() {
        String expectedMetaDataKey = "key";
        String expectedMetaDataValue = "value";
        long expectedTimeout = 1L;
        TimeUnit expectedTimeUnit = TimeUnit.SECONDS;
        Mockito.when((Object)this.mockBus.scatterGather(this.anyMessage(String.class, String.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).thenReturn(Stream.of(this.answer));
        GenericMessage testQuery = new GenericMessage((Object)"scatterGather", (Map)MetaData.with((String)expectedMetaDataKey, (Object)expectedMetaDataValue));
        Stream queryResponse = this.testSubject.scatterGather((Object)testQuery, ResponseTypes.instanceOf(String.class), expectedTimeout, expectedTimeUnit);
        Optional firstResult = queryResponse.findFirst();
        Assertions.assertTrue((boolean)firstResult.isPresent());
        Assertions.assertEquals((Object)"answer", firstResult.get());
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(QueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).scatterGather((QueryMessage)queryMessageCaptor.capture(), Mockito.eq((long)expectedTimeout), (TimeUnit)((Object)Mockito.eq((Object)((Object)expectedTimeUnit))));
        QueryMessage result = (QueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"scatterGather", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        MetaData resultMetaData = result.getMetaData();
        Assertions.assertTrue((boolean)resultMetaData.containsKey((Object)expectedMetaDataKey));
        Assertions.assertTrue((boolean)resultMetaData.containsValue((Object)expectedMetaDataValue));
    }

    @Test
    void subscriptionQuery() {
        Mockito.when((Object)this.mockBus.subscriptionQuery((SubscriptionQueryMessage)Mockito.any(), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.empty(), Flux.empty(), () -> true));
        this.testSubject.subscriptionQuery((Object)"subscription", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(SubscriptionQueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).subscriptionQuery((SubscriptionQueryMessage)queryMessageCaptor.capture(), Mockito.anyInt());
        SubscriptionQueryMessage result = (SubscriptionQueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"subscription", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getUpdateResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getUpdateResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void subscriptionQuerySpecifyingQueryName() {
        String expectedQueryName = "myQueryName";
        Mockito.when((Object)this.mockBus.subscriptionQuery((SubscriptionQueryMessage)Mockito.any(), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.empty(), Flux.empty(), () -> true));
        this.testSubject.subscriptionQuery(expectedQueryName, (Object)"subscription", String.class, String.class);
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(SubscriptionQueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).subscriptionQuery((SubscriptionQueryMessage)queryMessageCaptor.capture(), Mockito.anyInt());
        SubscriptionQueryMessage result = (SubscriptionQueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"subscription", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)expectedQueryName, (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getUpdateResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getUpdateResponseType().getExpectedResponseType());
        Assertions.assertEquals((Object)MetaData.emptyInstance(), (Object)result.getMetaData());
    }

    @Test
    void subscriptionQueryWithMetaData() {
        String expectedMetaDataKey = "key";
        String expectedMetaDataValue = "value";
        Mockito.when((Object)this.mockBus.subscriptionQuery((SubscriptionQueryMessage)Mockito.any(), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.empty(), Flux.empty(), () -> true));
        GenericMessage testQuery = new GenericMessage((Object)"subscription", (Map)MetaData.with((String)expectedMetaDataKey, (Object)expectedMetaDataValue));
        this.testSubject.subscriptionQuery((Object)testQuery, ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        ArgumentCaptor queryMessageCaptor = ArgumentCaptor.forClass(SubscriptionQueryMessage.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus)).subscriptionQuery((SubscriptionQueryMessage)queryMessageCaptor.capture(), Mockito.anyInt());
        SubscriptionQueryMessage result = (SubscriptionQueryMessage)queryMessageCaptor.getValue();
        Assertions.assertEquals((Object)"subscription", (Object)result.getPayload());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getQueryName());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getResponseType().getExpectedResponseType());
        Assertions.assertTrue((boolean)InstanceResponseType.class.isAssignableFrom(result.getUpdateResponseType().getClass()));
        Assertions.assertEquals(String.class, (Object)result.getUpdateResponseType().getExpectedResponseType());
        MetaData resultMetaData = result.getMetaData();
        Assertions.assertTrue((boolean)resultMetaData.containsKey((Object)expectedMetaDataKey));
        Assertions.assertTrue((boolean)resultMetaData.containsValue((Object)expectedMetaDataValue));
    }

    @Test
    void dispatchInterceptor() {
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(this.answer));
        this.testSubject.registerDispatchInterceptor(messages -> (integer, queryMessage) -> new GenericQueryMessage((Object)("dispatch-" + queryMessage.getPayload()), queryMessage.getQueryName(), queryMessage.getResponseType()));
        this.testSubject.query((Object)"query", String.class).join();
        ((QueryBus)Mockito.verify((Object)this.mockBus)).query((QueryMessage)Mockito.argThat(x -> "dispatch-query".equals(x.getPayload())));
    }

    @Test
    void exceptionInInitialResultOfSubscriptionQueryReportedInMono() {
        Mockito.when((Object)this.mockBus.subscriptionQuery(this.anySubscriptionMessage(String.class, String.class), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.just((Object)new GenericQueryResponseMessage(String.class, (Throwable)new MockException())), Flux.empty(), () -> true));
        SubscriptionQueryResult actual = this.testSubject.subscriptionQuery((Object)"Test", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals(MockException.class, (Object)actual.initialResult().map(i -> null).onErrorResume(e -> Mono.just(e.getClass())).block());
    }

    @Test
    void nullInitialResultOfSubscriptionQueryReportedAsEmptyMono() {
        Mockito.when((Object)this.mockBus.subscriptionQuery(this.anySubscriptionMessage(String.class, String.class), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.just((Object)new GenericQueryResponseMessage(String.class, (Object)null)), Flux.empty(), () -> true));
        SubscriptionQueryResult actual = this.testSubject.subscriptionQuery((Object)"Test", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        Assertions.assertNull((Object)actual.initialResult().block());
    }

    @Test
    void nullUpdatesOfSubscriptionQuerySkipped() {
        Mockito.when((Object)this.mockBus.subscriptionQuery(this.anySubscriptionMessage(String.class, String.class), Mockito.anyInt())).thenReturn((Object)new DefaultSubscriptionQueryResult(Mono.empty(), Flux.just((Object)new GenericSubscriptionQueryUpdateMessage(String.class, null)), () -> true));
        SubscriptionQueryResult actual = this.testSubject.subscriptionQuery((Object)"Test", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        Assertions.assertNull((Object)actual.initialResult().block());
        Assertions.assertEquals((Long)0L, (Long)((Long)actual.updates().count().block()));
    }

    @Test
    void payloadExtractionProblemsReportedInException() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.mockBus.query(this.anyMessage(String.class, String.class))).thenReturn(CompletableFuture.completedFuture(new GenericQueryResponseMessage<String>("test"){

            public String getPayload() {
                throw new MockException("Faking serialization problem");
            }
        }));
        CompletableFuture actual = this.testSubject.query((Object)"query", String.class);
        Assertions.assertTrue((boolean)actual.isDone());
        Assertions.assertTrue((boolean)actual.isCompletedExceptionally());
        Assertions.assertEquals((Object)"Faking serialization problem", ((CompletableFuture)actual.exceptionally(Throwable::getMessage)).get());
    }

    @Test
    void streamingQueryIsLazy() {
        Flux response = Flux.just((Object[])new QueryResponseMessage[]{new GenericQueryResponseMessage((Object)"a"), new GenericQueryResponseMessage((Object)"b"), new GenericQueryResponseMessage((Object)"c")});
        Mockito.when((Object)this.mockBus.streamingQuery((StreamingQueryMessage)Mockito.any())).thenReturn((Object)response);
        this.testSubject.streamingQuery((Object)"query", String.class);
        ((QueryBus)Mockito.verify((Object)this.mockBus, (VerificationMode)Mockito.never())).streamingQuery((StreamingQueryMessage)Mockito.any());
        StepVerifier.create((Publisher)this.testSubject.streamingQuery((Object)"query", String.class)).expectNext((Object)"a", (Object)"b", (Object)"c").verifyComplete();
        ((QueryBus)Mockito.verify((Object)this.mockBus, (VerificationMode)Mockito.times((int)1))).streamingQuery((StreamingQueryMessage)Mockito.any(StreamingQueryMessage.class));
    }

    @Test
    void streamingQueryPropagateErrors() {
        Mockito.when((Object)this.mockBus.streamingQuery((StreamingQueryMessage)Mockito.any())).thenReturn((Object)Flux.error((Throwable)new IllegalStateException("test")));
        StepVerifier.create((Publisher)this.testSubject.streamingQuery((Object)"query", String.class)).expectErrorMatches(t -> t instanceof IllegalStateException && t.getMessage().equals("test")).verify();
    }

    private <Q, R> QueryMessage<Q, R> anyMessage(Class<Q> queryType, Class<R> responseType) {
        return (QueryMessage)Mockito.any();
    }

    private <Q, R> SubscriptionQueryMessage<Q, R, R> anySubscriptionMessage(Class<Q> queryType, Class<R> responseType) {
        return (SubscriptionQueryMessage)Mockito.any();
    }
}

