/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.io.Serializable;
import org.axonframework.serialization.FixedValueRevisionResolver;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JavaSerializerTest {
    private JavaSerializer testSubject;

    JavaSerializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = JavaSerializer.builder().build();
    }

    @Test
    void serializeAndDeserialize() {
        SerializedObject serializedObject = this.testSubject.serialize((Object)new MySerializableObject("hello"), byte[].class);
        Assertions.assertEquals((Object)MySerializableObject.class.getName(), (Object)serializedObject.getType().getName());
        Assertions.assertEquals((Object)"2166108932776672373", (Object)serializedObject.getType().getRevision());
        Object actualResult = this.testSubject.deserialize(serializedObject);
        Assertions.assertTrue((boolean)(actualResult instanceof MySerializableObject));
        Assertions.assertEquals((Object)"hello", (Object)((MySerializableObject)actualResult).getSomeProperty());
    }

    @Test
    void classForType() {
        Class actual = this.testSubject.classForType((SerializedType)new SimpleSerializedType(MySerializableObject.class.getName(), "2166108932776672373"));
        Assertions.assertEquals(MySerializableObject.class, (Object)actual);
    }

    @Test
    void classForType_CustomRevisionResolver() {
        this.testSubject = JavaSerializer.builder().revisionResolver((RevisionResolver)new FixedValueRevisionResolver("fixed")).build();
        Class actual = this.testSubject.classForType((SerializedType)new SimpleSerializedType(MySerializableObject.class.getName(), "fixed"));
        Assertions.assertEquals(MySerializableObject.class, (Object)actual);
    }

    @Test
    void classForType_UnknownClass() {
        Assertions.assertEquals(UnknownSerializedType.class, (Object)this.testSubject.classForType((SerializedType)new SimpleSerializedType("unknown", "0")));
    }

    @Test
    void deserializeNullValue() {
        SerializedObject serializedNull = this.testSubject.serialize(null, byte[].class);
        SimpleSerializedObject serializedNullString = new SimpleSerializedObject(serializedNull.getData(), byte[].class, this.testSubject.typeForClass(String.class));
        Assertions.assertNull((Object)this.testSubject.deserialize(serializedNull));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)serializedNullString));
    }

    @Test
    void deserializeEmptyBytes() {
        Assertions.assertEquals(Void.class, (Object)this.testSubject.classForType(SerializedType.emptyType()));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)new byte[0], byte[].class, SerializedType.emptyType())));
    }

    private static class MySerializableObject
    implements Serializable {
        private static final long serialVersionUID = 2166108932776672373L;
        private String someProperty;

        public MySerializableObject(String someProperty) {
            this.someProperty = someProperty;
        }

        public String getSomeProperty() {
            return this.someProperty;
        }
    }
}

