/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.upcasting.Upcaster;
import org.axonframework.serialization.upcasting.event.ContextAwareEventMultiUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.utils.SecondStubEvent;
import org.axonframework.utils.StubDomainEvent;
import org.axonframework.utils.TestDomainEventEntry;
import org.axonframework.utils.ThirdStubEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ContextAwareEventMultiUpcasterTest {
    private Upcaster<IntermediateEventRepresentation> upcaster;
    private Serializer serializer;
    private String expectedNewString;
    private Integer expectedNewInteger;
    private List<Boolean> expectedNewBooleans;

    ContextAwareEventMultiUpcasterTest() {
    }

    @BeforeEach
    void setUp() {
        this.expectedNewString = "newNameValue";
        this.expectedNewInteger = 42;
        this.expectedNewBooleans = new ArrayList<Boolean>();
        this.expectedNewBooleans.add(true);
        this.expectedNewBooleans.add(false);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES));
        this.serializer = JacksonSerializer.builder().objectMapper(objectMapper).build();
        this.upcaster = new StubContextAwareEventMultiUpcaster(this.expectedNewString, this.expectedNewInteger, this.expectedNewBooleans);
    }

    @Test
    void upcastsAddsContextValueFromFirstEvent() {
        int expectedNumberOfEvents = 4;
        String expectedContextEventString = "oldName";
        Integer expectedContextEventNumber = 1;
        String expectedRevisionNumber = "1";
        String expectedNewString = this.expectedNewString + "ContextAdded";
        MetaData testMetaData = MetaData.with((String)"key", (Object)"value");
        GenericDomainEventMessage firstTestEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new SecondStubEvent(expectedContextEventString, expectedContextEventNumber), (Map)testMetaData);
        TestDomainEventEntry firstTestEventData = new TestDomainEventEntry((DomainEventMessage<?>)firstTestEventMessage, this.serializer);
        InitialEventRepresentation firstTestRepresentation = new InitialEventRepresentation((EventData)firstTestEventData, this.serializer);
        GenericDomainEventMessage secondTestEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName"), (Map)testMetaData);
        TestDomainEventEntry secondTestEventData = new TestDomainEventEntry((DomainEventMessage<?>)secondTestEventMessage, this.serializer);
        InitialEventRepresentation secondTestRepresentation = new InitialEventRepresentation((EventData)secondTestEventData, this.serializer);
        Stream<IntermediateEventRepresentation> testEventRepresentationStream = Stream.of(firstTestRepresentation, secondTestRepresentation);
        List result = this.upcaster.upcast(testEventRepresentationStream).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedNumberOfEvents, (int)result.size());
        IntermediateEventRepresentation firstEventResult = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertNull((Object)firstEventResult.getType().getRevision());
        Assertions.assertEquals((Object)firstTestEventData.getEventIdentifier(), (Object)firstEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)firstTestEventData.getTimestamp(), (Object)firstEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)firstEventResult.getMetaData().getObject());
        SecondStubEvent contextEvent = (SecondStubEvent)this.serializer.deserialize(firstEventResult.getData());
        Assertions.assertEquals((Object)expectedContextEventString, (Object)contextEvent.getName());
        Assertions.assertEquals((Integer)expectedContextEventNumber, (Integer)contextEvent.getNumber());
        IntermediateEventRepresentation secondEventResult = (IntermediateEventRepresentation)result.get(1);
        Assertions.assertEquals((Object)expectedRevisionNumber, (Object)secondEventResult.getType().getRevision());
        Assertions.assertEquals((Object)secondTestEventData.getEventIdentifier(), (Object)secondEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)secondTestEventData.getTimestamp(), (Object)secondEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)secondEventResult.getMetaData().getObject());
        StubDomainEvent firstUpcastedEvent = (StubDomainEvent)this.serializer.deserialize(secondEventResult.getData());
        Assertions.assertEquals((Object)expectedNewString, (Object)firstUpcastedEvent.getName());
        IntermediateEventRepresentation thirdEventResult = (IntermediateEventRepresentation)result.get(2);
        Assertions.assertNull((Object)thirdEventResult.getType().getRevision());
        Assertions.assertEquals((Object)secondTestEventData.getEventIdentifier(), (Object)thirdEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)secondTestEventData.getTimestamp(), (Object)thirdEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)thirdEventResult.getMetaData().getObject());
        SecondStubEvent secondUpcastedEvent = (SecondStubEvent)this.serializer.deserialize(thirdEventResult.getData());
        Assertions.assertEquals((Object)expectedNewString, (Object)secondUpcastedEvent.getName());
        Assertions.assertEquals((Integer)this.expectedNewInteger, (Integer)secondUpcastedEvent.getNumber());
        IntermediateEventRepresentation fourthEventResult = (IntermediateEventRepresentation)result.get(3);
        Assertions.assertNull((Object)fourthEventResult.getType().getRevision());
        Assertions.assertEquals((Object)secondTestEventData.getEventIdentifier(), (Object)fourthEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)secondTestEventData.getTimestamp(), (Object)fourthEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)fourthEventResult.getMetaData().getObject());
        ThirdStubEvent thirdUpcastedEvent = (ThirdStubEvent)this.serializer.deserialize(fourthEventResult.getData());
        Assertions.assertEquals((Object)expectedNewString, (Object)thirdUpcastedEvent.getName());
        Assertions.assertEquals((Integer)this.expectedNewInteger, (Integer)thirdUpcastedEvent.getNumber());
        Assertions.assertEquals(this.expectedNewBooleans, thirdUpcastedEvent.getTruths());
    }

    private static class StubContextAwareEventMultiUpcaster
    extends ContextAwareEventMultiUpcaster<Map<Object, Object>> {
        private static final String CONTEXT_FIELD_KEY = "ContextField";
        static final String CONTEXT_FIELD_VALUE = "ContextAdded";
        private final SerializedType contextType = new SimpleSerializedType(SecondStubEvent.class.getName(), null);
        private final SerializedType targetType = new SimpleSerializedType(StubDomainEvent.class.getName(), null);
        private final String newStringValue;
        private final Integer newIntegerValue;
        private final List<Boolean> newBooleanValues;

        private StubContextAwareEventMultiUpcaster(String newStringValue, Integer newIntegerValue, List<Boolean> newBooleanValues) {
            this.newStringValue = newStringValue;
            this.newIntegerValue = newIntegerValue;
            this.newBooleanValues = newBooleanValues;
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation, Map<Object, Object> context) {
            return this.isType(intermediateRepresentation.getType(), this.targetType) || this.isType(intermediateRepresentation.getType(), this.contextType);
        }

        private boolean isType(SerializedType foundType, SerializedType expectedType) {
            return foundType.equals(expectedType);
        }

        protected Stream<IntermediateEventRepresentation> doUpcast(IntermediateEventRepresentation ir, Map<Object, Object> context) {
            if (this.isContextEvent(ir)) {
                context.put(CONTEXT_FIELD_KEY, CONTEXT_FIELD_VALUE);
                return Stream.of(ir);
            }
            return Stream.of(ir.upcastPayload((SerializedType)new SimpleSerializedType(this.targetType.getName(), "1"), JsonNode.class, jsonNode -> this.doUpcast((JsonNode)jsonNode, context)), ir.upcastPayload((SerializedType)new SimpleSerializedType(SecondStubEvent.class.getName(), null), JsonNode.class, jsonNode -> this.doUpcastTwo((JsonNode)jsonNode, context)), ir.upcastPayload((SerializedType)new SimpleSerializedType(ThirdStubEvent.class.getName(), null), JsonNode.class, jsonNode -> this.doUpcastThree((JsonNode)jsonNode, context)));
        }

        private boolean isContextEvent(IntermediateEventRepresentation intermediateRepresentation) {
            return this.isType(intermediateRepresentation.getType(), this.contextType);
        }

        protected Map<Object, Object> buildContext() {
            return new HashMap<Object, Object>();
        }

        private JsonNode doUpcast(JsonNode eventJsonNode, Map<Object, Object> context) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue + context.get(CONTEXT_FIELD_KEY)));
            return eventObjectNode;
        }

        private JsonNode doUpcastTwo(JsonNode eventJsonNode, Map<Object, Object> context) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue + context.get(CONTEXT_FIELD_KEY)));
            eventObjectNode.set("number", (JsonNode)new IntNode(this.newIntegerValue.intValue()));
            return eventJsonNode;
        }

        private JsonNode doUpcastThree(JsonNode eventJsonNode, Map<Object, Object> context) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue + context.get(CONTEXT_FIELD_KEY)));
            eventObjectNode.set("number", (JsonNode)new IntNode(this.newIntegerValue.intValue()));
            ArrayNode truthsArrayNode = eventObjectNode.withArray("truths");
            this.newBooleanValues.forEach(arg_0 -> ((ArrayNode)truthsArrayNode).add(arg_0));
            return eventJsonNode;
        }
    }
}

