/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.axonframework.tracing.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SpanTest {
    private TestSpan span = new TestSpan();

    SpanTest() {
    }

    @Test
    void runRunnableWorks() {
        this.span.run(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
        });
        Assertions.assertTrue((boolean)this.span.ended);
    }

    @Test
    void runRunnableRegistersException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Assertions.assertThrows(RuntimeException.class, () -> this.span.run(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        }));
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void wrapRunnableWorks() {
        this.span.wrapRunnable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
        }).run();
        Assertions.assertTrue((boolean)this.span.ended);
    }

    @Test
    void wrapRunnableRegistersException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Runnable wrappedRunnable = this.span.wrapRunnable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        });
        Assertions.assertThrows(RuntimeException.class, wrappedRunnable::run);
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void runSupplierWorks() {
        String result = (String)this.span.runSupplier(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            return "SupplyString";
        });
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)"SupplyString", (Object)result);
    }

    @Test
    void runSupplierRegistersException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Assertions.assertThrows(RuntimeException.class, () -> this.span.runSupplier(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        }));
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void wrapSupplierWorks() {
        String result = (String)this.span.wrapSupplier(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            return "SupplyString";
        }).get();
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)"SupplyString", (Object)result);
    }

    @Test
    void wrapSupplierRegistersException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Supplier wrappedSupplier = this.span.wrapSupplier(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        });
        Assertions.assertThrows(RuntimeException.class, ((Supplier)wrappedSupplier)::get);
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void runCallableWorks() throws Exception {
        String result = (String)this.span.runCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            return "CallString";
        });
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)"CallString", (Object)result);
    }

    @Test
    void runCallableRegistersRuntimeException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Assertions.assertThrows(RuntimeException.class, () -> this.span.runCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        }));
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void runCallableRegistersCheckedException() {
        IOException exception = new IOException("My custom exception");
        Assertions.assertThrows(IOException.class, () -> this.span.runCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        }));
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void wrapCallableWorks() throws Exception {
        String result = (String)this.span.wrapCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            return "CallString";
        }).call();
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)"CallString", (Object)result);
    }

    @Test
    void wrapCallableRegistersRuntimeException() {
        RuntimeException exception = new RuntimeException("My custom exception");
        Callable wrappedCallable = this.span.wrapCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        });
        Assertions.assertThrows(RuntimeException.class, wrappedCallable::call);
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    @Test
    void wrapCallableRegistersCheckedException() {
        IOException exception = new IOException("My custom exception");
        Callable wrappedCallable = this.span.wrapCallable(() -> {
            Assertions.assertTrue((boolean)this.span.started);
            Assertions.assertFalse((boolean)this.span.ended);
            throw exception;
        });
        Assertions.assertThrows(IOException.class, wrappedCallable::call);
        Assertions.assertTrue((boolean)this.span.ended);
        Assertions.assertEquals((Object)exception, (Object)this.span.exception);
    }

    static class TestSpan
    implements Span {
        boolean started;
        boolean ended;
        Throwable exception;

        TestSpan() {
        }

        public Span start() {
            this.started = true;
            return this;
        }

        public void end() {
            this.ended = true;
        }

        public Span recordException(Throwable t) {
            this.exception = t;
            return this;
        }
    }
}

