/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpanFactory
implements SpanFactory {
    private final Logger logger = LoggerFactory.getLogger(TestSpanFactory.class);
    private final Deque<TestSpan> activeSpan = new ArrayDeque<TestSpan>();
    private final List<TestSpan> createdSpans = new CopyOnWriteArrayList<TestSpan>();
    private final Map<Message<?>, TestSpan> propagatedContexts = new HashMap();
    private final Map<Message<?>, TestSpan> spanParents = new HashMap();

    public void reset() {
        this.activeSpan.clear();
        this.createdSpans.clear();
        this.propagatedContexts.clear();
        this.spanParents.clear();
        this.logger.debug("SpanFactory cleared");
    }

    public void verifyNotStarted(String name) {
        Assertions.assertFalse((boolean)this.findSpan(name).started);
        Assertions.assertFalse((boolean)this.findSpan(name).ended);
    }

    public void verifySpanActive(String name) {
        Assertions.assertTrue((boolean)this.findSpan(name).started);
        Assertions.assertFalse((boolean)this.findSpan(name).ended);
    }

    public void verifySpanActive(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.findSpan(name, message).started);
        Assertions.assertFalse((boolean)this.findSpan(name, message).ended);
    }

    public void verifySpanCompleted(String name) {
        Assertions.assertTrue((boolean)this.findSpan(name).started);
        Assertions.assertTrue((boolean)this.findSpan(name).ended);
    }

    public boolean spanCompleted(String name) {
        return this.findSpan(name).started && this.findSpan(name).ended;
    }

    public void verifySpanCompleted(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.findSpan(name, message).started);
        Assertions.assertTrue((boolean)this.findSpan(name, message).ended);
    }

    public void verifySpanHasException(String name, Class<?> exceptionClass) {
        Assertions.assertInstanceOf(exceptionClass, (Object)this.findSpan(name).exception);
    }

    public void verifyNoSpan(String name) {
        Optional<TestSpan> span = this.createdSpans.stream().filter(s -> ((TestSpan)s).name.equals(name)).findFirst();
        Assertions.assertFalse((boolean)span.isPresent());
    }

    public void verifySpanPropagated(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.createdSpans.stream().anyMatch(s -> ((TestSpan)s).name.equals(name) && this.propagatedContexts.containsKey(message) && this.propagatedContexts.get(message) == s), (String)this.createErrorMessageForSpan(name));
    }

    public void verifySpanHasType(String name, TestSpanType type) {
        Assertions.assertEquals((Object)((Object)type), (Object)((Object)this.findSpan(name).type));
    }

    private TestSpan findSpan(String name) {
        Optional<TestSpan> span = this.createdSpans.stream().filter(s -> ((TestSpan)s).name.equals(name)).findFirst();
        Assertions.assertTrue((boolean)span.isPresent(), () -> this.createErrorMessageForSpan(name));
        return span.get();
    }

    private String createErrorMessageForSpan(String name) {
        return String.format("No span matching name %s, but got the following recorded spans: %s", name, this.createdSpans.stream().map(TestSpan::toString).collect(Collectors.joining("\n")));
    }

    private TestSpan findSpan(String name, Message<?> message) {
        Optional<TestSpan> span = this.createdSpans.stream().filter(s -> ((TestSpan)s).name.equals(name) && ((TestSpan)s).message != null && ((TestSpan)s).message.equals(message)).findFirst();
        Assertions.assertTrue((boolean)span.isPresent(), () -> String.format("No span matching name %s and message %s, but got the following recorded spans: \n%s", name, message, this.createdSpans.stream().map(TestSpan::toString).collect(Collectors.joining("\n"))));
        return span.get();
    }

    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        TestSpan span = new TestSpan(TestSpanType.ROOT, operationNameSupplier.get(), null);
        this.createdSpans.add(span);
        return span;
    }

    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        TestSpan span = new TestSpan(isChildTrace ? TestSpanType.HANDLER_CHILD : TestSpanType.HANDLER_LINK, operationNameSupplier.get(), parentMessage);
        this.createdSpans.add(span);
        this.spanParents.put(parentMessage, span);
        return span;
    }

    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        TestSpan span = new TestSpan(TestSpanType.DISPATCH, operationNameSupplier.get(), parentMessage);
        this.createdSpans.add(span);
        return span;
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        TestSpan span = new TestSpan(TestSpanType.INTERNAL, operationNameSupplier.get(), null);
        this.createdSpans.add(span);
        return span;
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        TestSpan span = new TestSpan(TestSpanType.INTERNAL, operationNameSupplier.get(), message);
        this.createdSpans.add(span);
        return span;
    }

    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Message<?>> M propagateContext(M message) {
        Deque<TestSpan> deque = this.activeSpan;
        synchronized (deque) {
            if (this.activeSpan.isEmpty()) {
                return message;
            }
            this.propagatedContexts.put(message, this.activeSpan.getFirst());
        }
        return message;
    }

    public class TestSpan
    implements Span {
        private final TestSpanType type;
        private final String name;
        private final Message<?> message;
        private boolean started;
        private boolean ended;
        private Throwable exception;

        public TestSpan(TestSpanType type, String name, Message<?> message) {
            this.type = type;
            this.name = name;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Span start() {
            this.started = true;
            Deque deque = TestSpanFactory.this.activeSpan;
            synchronized (deque) {
                TestSpanFactory.this.activeSpan.addFirst(this);
            }
            TestSpanFactory.this.logger.debug("+ {}", (Object)this.name);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            this.ended = true;
            Deque deque = TestSpanFactory.this.activeSpan;
            synchronized (deque) {
                TestSpanFactory.this.activeSpan.remove(this);
            }
            TestSpanFactory.this.logger.debug("- {}", (Object)this.name);
        }

        public Span recordException(Throwable t) {
            TestSpanFactory.this.logger.debug("Recorded exception for span with name {}", (Object)this.name, (Object)t);
            this.exception = t;
            return this;
        }

        public String toString() {
            return "TestSpan{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", message=" + this.message + ", started=" + this.started + ", ended=" + this.ended + ", exception=" + this.exception + '}';
        }
    }

    public static enum TestSpanType {
        ROOT,
        HANDLER_CHILD,
        HANDLER_LINK,
        DISPATCH,
        INTERNAL;

    }
}

