/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.utils;

import java.util.concurrent.TimeUnit;

public abstract class AssertUtils {
    private AssertUtils() {
    }

    public static void assertWithin(int time, TimeUnit unit, Runnable assertion) {
        long now = System.currentTimeMillis();
        long deadline = now + unit.toMillis(time);
        while (true) {
            try {
                assertion.run();
            }
            catch (AssertionError e) {
                if (now >= deadline) {
                    throw e;
                }
                now = System.currentTimeMillis();
                continue;
            }
            break;
        }
    }
}

