/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.Collections;
import java.util.Map;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericCommandMessageTest {
    GenericCommandMessageTest() {
    }

    @Test
    void constructor() {
        Object payload = new Object();
        CommandMessage message1 = GenericCommandMessage.asCommandMessage((Object)payload);
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericCommandMessage message2 = new GenericCommandMessage(payload, (Map)metaData);
        GenericCommandMessage message3 = new GenericCommandMessage(payload, metaDataMap);
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)message1.getMetaData());
        Assertions.assertEquals(Object.class, message1.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message1.getPayloadType());
        Assertions.assertSame((Object)metaData, (Object)message2.getMetaData());
        Assertions.assertEquals(Object.class, message2.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message2.getPayloadType());
        Assertions.assertNotSame(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(metaDataMap, (Object)message3.getMetaData());
        Assertions.assertEquals(Object.class, message3.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)message3.getPayloadType());
        Assertions.assertNotEquals((Object)message1.getIdentifier(), (Object)message2.getIdentifier());
        Assertions.assertNotEquals((Object)message1.getIdentifier(), (Object)message3.getIdentifier());
        Assertions.assertNotEquals((Object)message2.getIdentifier(), (Object)message3.getIdentifier());
    }

    @Test
    void withMetaData() {
        Object payload = new Object();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericCommandMessage message = new GenericCommandMessage(payload, (Map)metaData);
        GenericCommandMessage message1 = message.withMetaData((Map)MetaData.emptyInstance());
        GenericCommandMessage message2 = message.withMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)0, (int)message1.getMetaData().size());
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
    }

    @Test
    void andMetaData() {
        Object payload = new Object();
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        MetaData metaData = MetaData.from(metaDataMap);
        GenericCommandMessage message = new GenericCommandMessage(payload, (Map)metaData);
        GenericCommandMessage message1 = message.andMetaData((Map)MetaData.emptyInstance());
        GenericCommandMessage message2 = message.andMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)1, (int)message1.getMetaData().size());
        Assertions.assertEquals((Object)"value", (Object)message1.getMetaData().get((Object)"key"));
        Assertions.assertEquals((int)1, (int)message2.getMetaData().size());
        Assertions.assertEquals((Object)"otherValue", (Object)message2.getMetaData().get((Object)"key"));
    }

    @Test
    void testToString() {
        String actual = GenericCommandMessage.asCommandMessage((Object)"MyPayload").andMetaData((Map)MetaData.with((String)"key", (Object)"value").and("key2", (Object)13)).toString();
        Assertions.assertTrue((boolean)actual.startsWith("GenericCommandMessage{payload={MyPayload}, metadata={"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key'->'value'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.contains("'key2'->'13'"), (String)("Wrong output: " + actual));
        Assertions.assertTrue((boolean)actual.endsWith("', commandName='java.lang.String'}"), (String)("Wrong output: " + actual));
        Assertions.assertEquals((int)173, (int)actual.length(), (String)("Wrong output: " + actual));
    }

    @Test
    void asCommandMessageWrapsPayload() {
        String expectedPayload = "some-payload";
        CommandMessage result = GenericCommandMessage.asCommandMessage((Object)expectedPayload);
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertTrue((boolean)result.getMetaData().isEmpty());
        Assertions.assertNotNull((Object)result.getIdentifier());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getCommandName());
    }

    @Test
    void asCommandMessageReturnsCommandMessageAsIs() {
        GenericCommandMessage expected = new GenericCommandMessage((Object)"some-payload", (Map)MetaData.with((String)"key", (Object)"value"));
        CommandMessage result = GenericCommandMessage.asCommandMessage((Object)expected);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void asCommandMessageRetrievesPayloadAndMetaDataFromMessageImplementations() {
        String expectedPayload = "some-payload";
        MetaData expectedMetaData = MetaData.with((String)"key", (Object)"value");
        String testIdentifier = "some-identifier";
        GenericMessage testMessage = new GenericMessage(testIdentifier, (Object)expectedPayload, (Map)expectedMetaData);
        CommandMessage result = GenericCommandMessage.asCommandMessage((Object)testMessage);
        Assertions.assertEquals((Object)expectedPayload, (Object)result.getPayload());
        Assertions.assertEquals((Object)expectedMetaData, (Object)result.getMetaData());
        Assertions.assertNotEquals((Object)testIdentifier, (Object)result.getIdentifier());
        Assertions.assertEquals(String.class, (Object)result.getPayloadType());
        Assertions.assertEquals((Object)String.class.getName(), (Object)result.getCommandName());
    }
}

