/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.awaitility.Awaitility;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.DistributedCommandBus;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.commandfilter.DenyAll;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.Registration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class DistributedCommandBusTest {
    private DistributedCommandBus testSubject;
    @Mock
    private CommandRouter mockCommandRouter;
    @Spy
    private final CommandBusConnector mockConnector = new StubCommandBusConnector();
    @Mock
    private MessageMonitor<? super CommandMessage<?>> mockMessageMonitor;
    @Mock
    private MessageMonitor.MonitorCallback mockMonitorCallback;
    @Mock
    private Member mockMember;
    private TestSpanFactory spanFactory;

    DistributedCommandBusTest() {
    }

    @BeforeEach
    void setUp() {
        this.spanFactory = new TestSpanFactory();
        this.testSubject = DistributedCommandBus.builder().commandRouter(this.mockCommandRouter).connector(this.mockConnector).messageMonitor(this.mockMessageMonitor).spanFactory((SpanFactory)this.spanFactory).build();
    }

    @Test
    void dispatchWithoutCallbackWithMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        CountDownLatch waiter = new CountDownLatch(1);
        this.testSubject.dispatch(testCommandMessage, (cm, result) -> {
            this.spanFactory.verifySpanActive("DistributedCommandBus.dispatch", (Message<?>)testCommandMessage);
            waiter.countDown();
        });
        waiter.await();
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector)).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback)).reportSuccess();
        Awaitility.await().atMost(Duration.ofSeconds(3L)).untilAsserted(() -> this.spanFactory.verifySpanCompleted("DistributedCommandBus.dispatch"));
        Awaitility.await().atMost(Duration.ofSeconds(3L)).untilAsserted(() -> this.spanFactory.verifySpanPropagated("DistributedCommandBus.dispatch", (Message<?>)testCommandMessage));
    }

    @Test
    void defaultCallbackIsUsedWhenFireAndForget() {
        CommandMessage message = GenericCommandMessage.asCommandMessage((Object)"test");
        CommandCallback mockCallback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        this.testSubject = DistributedCommandBus.builder().commandRouter(this.mockCommandRouter).connector(this.mockConnector).messageMonitor(this.mockMessageMonitor).defaultCommandCallback(mockCallback).build();
        this.testSubject.dispatch(message);
        ((CommandCallback)Mockito.verify((Object)mockCallback)).onResult((CommandMessage)Mockito.eq((Object)message), (CommandResultMessage)Mockito.any());
    }

    @Test
    void dispatchFailingCommandWithoutCallbackWithMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"fail");
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        this.testSubject.dispatch(testCommandMessage, (CommandCallback)NoOpCallback.INSTANCE);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector)).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback)).reportFailure((Throwable)Mockito.isA(Exception.class));
    }

    @Test
    void dispatchWithoutCallbackAndWithoutMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        this.testSubject = DistributedCommandBus.builder().commandRouter(this.mockCommandRouter).connector(this.mockConnector).build();
        this.testSubject.dispatch(testCommandMessage);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.times((int)1))).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.never())).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor, (VerificationMode)Mockito.never())).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback, (VerificationMode)Mockito.never())).reportSuccess();
    }

    @Test
    void unknownCommandWithoutCallbackAndWithoutMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"unknown");
        CommandCallback callback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)this.mockCommandRouter.findDestination(testCommandMessage)).thenReturn(Optional.empty());
        this.testSubject = DistributedCommandBus.builder().commandRouter(this.mockCommandRouter).connector(this.mockConnector).spanFactory((SpanFactory)this.spanFactory).build();
        this.testSubject.dispatch(testCommandMessage, callback);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.never())).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.never())).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor, (VerificationMode)Mockito.never())).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback, (VerificationMode)Mockito.never())).reportSuccess();
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)callback)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(NoHandlerForCommandException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
        this.spanFactory.verifySpanHasException("DistributedCommandBus.dispatch", NoHandlerForCommandException.class);
    }

    @Test
    void dispatchWithCallbackAndMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        CommandCallback mockCallback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        this.testSubject.dispatch(testCommandMessage, mockCallback);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector)).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback)).reportSuccess();
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)mockCallback)).onResult((CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertFalse((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertNull((Object)((CommandResultMessage)commandResultMessageCaptor.getValue()).getPayload());
    }

    @Test
    void unknownCommandWithCallbackAndMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        CommandCallback mockCallback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)this.mockCommandRouter.findDestination(testCommandMessage)).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        this.testSubject.dispatch(testCommandMessage, mockCallback);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.never())).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.never())).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback)).reportFailure((Throwable)Mockito.any());
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)mockCallback)).onResult((CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(NoHandlerForCommandException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
        this.spanFactory.verifySpanHasException("DistributedCommandBus.dispatch", RuntimeException.class);
    }

    @Test
    void dispatchFailingCommandWithCallbackAndMessageMonitor() throws Exception {
        CommandMessage testCommandMessage = GenericCommandMessage.asCommandMessage((Object)"fail");
        CommandCallback mockCallback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)this.mockCommandRouter.findDestination((CommandMessage)Mockito.any())).thenReturn(Optional.of(this.mockMember));
        Mockito.when((Object)this.mockMessageMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)this.mockMonitorCallback);
        this.testSubject.dispatch(testCommandMessage, mockCallback);
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).findDestination(testCommandMessage);
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector)).send((Member)Mockito.eq((Object)this.mockMember), (CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandCallback)Mockito.any(CommandCallback.class));
        ((MessageMonitor)Mockito.verify(this.mockMessageMonitor)).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)this.mockMonitorCallback)).reportFailure((Throwable)Mockito.isA(Exception.class));
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)mockCallback)).onResult((CommandMessage)Mockito.eq((Object)testCommandMessage), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertEquals(Exception.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    @Test
    void localSegmentReturnsTheCommandBusConnectorsLocalSegmentResult() {
        CommandBus expectedLocalSegment = (CommandBus)Mockito.mock(CommandBus.class);
        Mockito.when((Object)this.mockConnector.localSegment()).thenReturn(Optional.of(expectedLocalSegment));
        CommandBus resultLocalSegment = this.testSubject.localSegment();
        Assertions.assertEquals((Object)expectedLocalSegment, (Object)resultLocalSegment);
    }

    @Test
    void disconnectRemovesAllSubscribedCommandHandlers() {
        this.testSubject.disconnect();
        ((CommandRouter)Mockito.verify((Object)this.mockCommandRouter)).updateMembership(100, (CommandMessageFilter)DenyAll.INSTANCE);
    }

    @Test
    void shutdownDispatchingInitiatesShutdownOfCommandBusConnector() {
        this.testSubject.shutdownDispatching();
        ((CommandBusConnector)Mockito.verify((Object)this.mockConnector)).initiateShutdown();
    }

    @Test
    void loadFactorDefault() {
        Assertions.assertEquals((int)100, (int)this.testSubject.getLoadFactor());
    }

    @Test
    void updateLoadFactor() {
        int expectedLoadFactor = 42;
        this.testSubject.updateLoadFactor(expectedLoadFactor);
        Assertions.assertEquals((int)expectedLoadFactor, (int)this.testSubject.getLoadFactor());
    }

    @Test
    void shouldThrowWithNullDefaultCommandCallback() {
        DistributedCommandBus.Builder builder = DistributedCommandBus.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.defaultCommandCallback(null));
    }

    private static class StubCommandBusConnector
    implements CommandBusConnector {
        private StubCommandBusConnector() {
        }

        public <C> void send(@Nonnull Member destination, @Nonnull CommandMessage<? extends C> command) {
        }

        public <C, R> void send(@Nonnull Member destination, @Nonnull CommandMessage<C> command, @Nonnull CommandCallback<? super C, R> callback) {
            if ("fail".equals(command.getPayload())) {
                callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage((Throwable)new Exception("Failing")));
            } else {
                callback.onResult(command, (CommandResultMessage)new GenericCommandResultMessage(null));
            }
        }

        public Registration subscribe(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> handler) {
            return null;
        }

        public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
            return null;
        }
    }
}

