/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.axonframework.commandhandling.gateway.ExponentialBackOffIntervalRetryScheduler;
import org.axonframework.commandhandling.gateway.IntervalRetrySchedulerTest;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.AxonConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExponentialBackOffIntervalRetrySchedulerTest {
    private static final int BACKOFF_FACTOR = 100;
    private static final int MAX_RETRIES = 6;
    private ExponentialBackOffIntervalRetryScheduler retryScheduler;

    ExponentialBackOffIntervalRetrySchedulerTest() {
    }

    @BeforeEach
    void setup() {
        this.retryScheduler = ((ExponentialBackOffIntervalRetryScheduler.Builder)((ExponentialBackOffIntervalRetryScheduler.Builder)ExponentialBackOffIntervalRetryScheduler.builder().retryExecutor((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1))).backoffFactor(100L).maxRetryCount(6)).build();
    }

    @Test
    void scheduleRetry() {
        for (int nrOfFailures = 1; nrOfFailures <= 6; ++nrOfFailures) {
            long delay = 100L * (1L << nrOfFailures - 1);
            Assertions.assertTrue((IntervalRetrySchedulerTest.doScheduleRetry((RetryScheduler)this.retryScheduler, nrOfFailures) >= delay ? 1 : 0) != 0, (String)"Scheduling a retry should wait the required delay.");
        }
        Assertions.assertEquals((long)0L, (long)IntervalRetrySchedulerTest.doScheduleRetry((RetryScheduler)this.retryScheduler, 7), (String)"Scheduling a retry when past maxRetryCount should have failed.");
    }

    @Test
    void buildingWhilstMissingScheduledExecutorServiceThrowsConfigurationException() {
        ExponentialBackOffIntervalRetryScheduler.Builder builder = ExponentialBackOffIntervalRetryScheduler.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((ExponentialBackOffIntervalRetryScheduler.Builder)builder).build());
    }
}

