/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.serialization.SerializationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionUtilsTest {
    ExceptionUtilsTest() {
    }

    @Test
    void isExplicitlyNonTransientForTransientExceptions() {
        NoHandlerForCommandException transientException = new NoHandlerForCommandException("No handler message");
        Assertions.assertFalse((boolean)ExceptionUtils.isExplicitlyNonTransient((Throwable)transientException));
    }

    @Test
    void isExplicitlyNonTransientForRegularExceptions() {
        RuntimeException runtimeException = new RuntimeException("Something went wrong");
        Assertions.assertFalse((boolean)ExceptionUtils.isExplicitlyNonTransient((Throwable)runtimeException));
    }

    @Test
    void isExplicitlyNonTransientForNonTransientExceptions() {
        SerializationException nonTransientException = new SerializationException("Serialization error");
        Assertions.assertTrue((boolean)ExceptionUtils.isExplicitlyNonTransient((Throwable)nonTransientException));
    }

    @Test
    void isExplicitlyNonTransientForNestedNonTransientException() {
        SerializationException nonTransientException = new SerializationException("Serialization error");
        RuntimeException nestedRuntimeException = new RuntimeException("Something went wrong nested", (Throwable)nonTransientException);
        RuntimeException baseRuntimeException = new RuntimeException("Something went wrong", nestedRuntimeException);
        Assertions.assertTrue((boolean)ExceptionUtils.isExplicitlyNonTransient((Throwable)baseRuntimeException));
    }
}

