/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.legacyjpa;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.axonframework.common.legacyjpa.PagingJpaQueryIterable;
import org.axonframework.common.legacyjpa.TestJpaEntry;
import org.axonframework.common.transaction.NoOpTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class PagingJpaQueryIterableTest {
    private final TransactionManager transactionManager = (TransactionManager)Mockito.spy((Object)new NoOpTransactionManager());
    private final EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpatest");
    private final EntityManager entityManager = this.emf.createEntityManager();
    private EntityTransaction transaction;

    PagingJpaQueryIterableTest() {
    }

    @BeforeEach
    public void setUpJpa() {
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
    }

    @AfterEach
    public void rollback() {
        this.transaction.rollback();
    }

    @Test
    void queriesJustOneItemAsOnePage() {
        this.entityManager.persist((Object)new TestJpaEntry("1"));
        PagingJpaQueryIterable iterable = new PagingJpaQueryIterable(10, this.transactionManager, () -> this.entityManager.createQuery("select t from TestJpaEntry t", TestJpaEntry.class), TestJpaEntry::getId);
        List result = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"1", result.get(0));
    }

    @Test
    void queriesMultiplePages() {
        List<String> wantedIds = IntStream.range(0, 102).mapToObj(i -> "" + i).collect(Collectors.toList());
        wantedIds.forEach(item -> this.entityManager.persist((Object)new TestJpaEntry((String)item)));
        PagingJpaQueryIterable iterable = new PagingJpaQueryIterable(10, this.transactionManager, () -> this.entityManager.createQuery("select t from TestJpaEntry t", TestJpaEntry.class), TestJpaEntry::getId);
        List result = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        Assertions.assertEquals((int)wantedIds.size(), (int)result.size());
        wantedIds.forEach(id -> Assertions.assertTrue((boolean)result.contains(id)));
    }

    @Test
    void throwsExceptionWhenNoItemPresent() {
        PagingJpaQueryIterable iterable = new PagingJpaQueryIterable(10, this.transactionManager, () -> this.entityManager.createQuery("select t from TestJpaEntry t", TestJpaEntry.class), TestJpaEntry::getId);
        Iterator iterator = iterable.iterator();
        Assertions.assertThrows(NoSuchElementException.class, iterator::next);
    }
}

