/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PropertyAccessStrategyTest {
    private PropertyAccessStrategy mock1 = new StubPropertyAccessStrategy(1000, "mock1");
    private PropertyAccessStrategy mock2 = new StubPropertyAccessStrategy(1200, "mock2");
    private PropertyAccessStrategy mock3 = new StubPropertyAccessStrategy(1000, "mock3");
    private PropertyAccessStrategy mock4 = new StubPropertyAccessStrategy(1000, "mock4");
    private TestPropertyAccessStrategy testPropertyAccessStrategy = new TestPropertyAccessStrategy();

    PropertyAccessStrategyTest() {
    }

    @AfterEach
    void setUp() {
        PropertyAccessStrategy.unregister((PropertyAccessStrategy)this.mock1);
        PropertyAccessStrategy.unregister((PropertyAccessStrategy)this.mock2);
        PropertyAccessStrategy.unregister((PropertyAccessStrategy)this.mock3);
        PropertyAccessStrategy.unregister((PropertyAccessStrategy)this.mock4);
        PropertyAccessStrategy.unregister((PropertyAccessStrategy)this.testPropertyAccessStrategy);
    }

    @Test
    void beanPropertyAccess() {
        Assertions.assertEquals((Object)"beanProperty", (Object)PropertyAccessStrategy.getProperty(Bean.class, (String)"beanProperty").getValue((Object)new Bean()));
    }

    @Test
    void uniformPropertyAccess() {
        Assertions.assertEquals((Object)"uniformProperty", (Object)PropertyAccessStrategy.getProperty(Bean.class, (String)"uniformProperty").getValue((Object)new Bean()));
    }

    @Test
    void register() {
        PropertyAccessStrategy.register((PropertyAccessStrategy)this.testPropertyAccessStrategy);
        Assertions.assertEquals((Object)"testGetterInvoked", (Object)PropertyAccessStrategy.getProperty(Bean.class, (String)"testProperty").getValue((Object)new Bean()));
    }

    @Test
    void invocationOrdering() {
        PropertyAccessStrategy.register((PropertyAccessStrategy)this.mock1);
        PropertyAccessStrategy.register((PropertyAccessStrategy)this.mock2);
        Assertions.assertEquals((Object)"mock2", (Object)PropertyAccessStrategy.getProperty(Bean.class, (String)"testProperty").getValue((Object)new Bean()));
    }

    @Test
    void invocationOrdering_EqualPriorityUsesClassName() {
        PropertyAccessStrategy.register((PropertyAccessStrategy)this.mock3);
        PropertyAccessStrategy.register((PropertyAccessStrategy)this.mock4);
        Assertions.assertEquals((Object)"mock3", (Object)PropertyAccessStrategy.getProperty(Bean.class, (String)"testProperty").getValue((Object)new Bean()));
    }

    private static class StubPropertyAccessStrategy
    extends PropertyAccessStrategy {
        private final int priority;
        private final String value;

        public StubPropertyAccessStrategy(int priority, String value) {
            this.priority = priority;
            this.value = value;
        }

        protected int getPriority() {
            return this.priority;
        }

        protected <T> Property<T> propertyFor(Class<? extends T> targetClass, String property) {
            return new TestPropertyAccessStrategy.StubProperty(this.value);
        }
    }

    static class Bean {
        private String beanProperty = "beanProperty";
        private String uniformProperty = "uniformProperty";

        Bean() {
        }

        public String getBeanProperty() {
            return this.beanProperty;
        }

        public String uniformProperty() {
            return this.uniformProperty;
        }
    }

    static class TestPropertyAccessStrategy
    extends PropertyAccessStrategy {
        TestPropertyAccessStrategy() {
        }

        protected int getPriority() {
            return Integer.MAX_VALUE;
        }

        protected <T> Property<T> propertyFor(Class<? extends T> targetClass, String property) {
            return new StubProperty("testGetterInvoked");
        }

        private static class StubProperty<T>
        implements Property<T> {
            private final String value;

            private StubProperty(String value) {
                this.value = value;
            }

            public <V> V getValue(T target) {
                return (V)this.value;
            }
        }
    }
}

