/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.axonframework.deadline.dbscheduler.DbSchedulerBinaryDeadlineDetails;
import org.axonframework.deadline.dbscheduler.DbSchedulerDeadlineManager;
import org.axonframework.deadline.dbscheduler.DbSchedulerHumanReadableDeadlineDetails;
import org.axonframework.utils.DbSchedulerTestUtil;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration
@ExtendWith(value={SpringExtension.class})
class DbSchedulerDeadlineManagerTest {
    @Autowired
    protected DataSource dataSource;

    DbSchedulerDeadlineManagerTest() {
    }

    @BeforeEach
    void prepare() {
        DbSchedulerTestUtil.reCreateTable(this.dataSource);
    }

    @Test
    void binaryShouldFailWhenNotinitialized() {
        Scheduler scheduler = DbSchedulerTestUtil.getScheduler(this.dataSource, DbSchedulerDeadlineManager.binaryTask());
        scheduler.start();
        try {
            TaskInstance instance = DbSchedulerDeadlineManager.binaryTask().instance("id", (Object)new DbSchedulerBinaryDeadlineDetails());
            scheduler.schedule(instance, Instant.now());
            Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> {
                List failures = scheduler.getFailingExecutions(Duration.ofHours(1L));
                Assertions.assertEquals((int)1, (int)failures.size());
                Assertions.assertNotNull((Object)((Execution)failures.get((int)0)).lastFailure);
            });
        }
        finally {
            scheduler.stop();
        }
    }

    @Test
    void humanReadableShouldFailWhenNotinitialized() {
        Scheduler scheduler = DbSchedulerTestUtil.getScheduler(this.dataSource, DbSchedulerDeadlineManager.humanReadableTask());
        scheduler.start();
        try {
            TaskInstance instance = DbSchedulerDeadlineManager.humanReadableTask().instance("id", (Object)new DbSchedulerHumanReadableDeadlineDetails());
            scheduler.schedule(instance, Instant.now());
            Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> {
                List failures = scheduler.getFailingExecutions(Duration.ofHours(1L));
                Assertions.assertEquals((int)1, (int)failures.size());
                Assertions.assertNotNull((Object)((Execution)failures.get((int)0)).lastFailure);
            });
        }
        finally {
            scheduler.stop();
        }
    }

    @Configuration
    public static class Context {
        @Bean
        public DataSource dataSource() {
            JDBCDataSource dataSource = new JDBCDataSource();
            dataSource.setUrl("jdbc:hsqldb:mem:testdb");
            dataSource.setUser("sa");
            dataSource.setPassword("");
            return dataSource;
        }
    }
}

