/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import com.github.kagkarlsson.scheduler.serializer.GsonSerializer;
import com.github.kagkarlsson.scheduler.serializer.JacksonSerializer;
import com.github.kagkarlsson.scheduler.serializer.JavaSerializer;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.TestScopeDescriptor;
import org.axonframework.deadline.dbscheduler.DbSchedulerHumanReadableDeadlineDetails;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DbSchedulerHumanReadableDeadlineDetailsTest {
    private static final String TEST_DEADLINE_NAME = "deadline-name";
    private static final String TEST_DEADLINE_PAYLOAD = "deadline-payload";
    private static final MetaData META_DATA = DbSchedulerHumanReadableDeadlineDetailsTest.getMetaData();
    private static final DeadlineMessage<?> MESSAGE = DbSchedulerHumanReadableDeadlineDetailsTest.getMessage();

    DbSchedulerHumanReadableDeadlineDetailsTest() {
    }

    @MethodSource(value={"dbSchedulerSerializers"})
    @ParameterizedTest
    void shouldBeSerializableWithDbSchedulerSerializers(Serializer serializer) {
        DbSchedulerHumanReadableDeadlineDetails expected = new DbSchedulerHumanReadableDeadlineDetails("deadlinename", "someScope", "org.axonframework.modelling.command.AggregateScopeDescriptor", "{\"foo\":\"bar\"}", "com.someCompany.api.ImportantEvent", "1", "{\"traceId\":\"1acc25e2-58a1-4dec-8b43-55388188500a\"}");
        byte[] serialized = serializer.serialize((Object)expected);
        DbSchedulerHumanReadableDeadlineDetails result = (DbSchedulerHumanReadableDeadlineDetails)serializer.deserialize(DbSchedulerHumanReadableDeadlineDetails.class, serialized);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @MethodSource(value={"axonSerializers"})
    @ParameterizedTest
    void whenDataInPojoIsSerializedAndDeserializedItShouldBeTheSame(TestSerializer testSerializer) {
        org.axonframework.serialization.Serializer serializer = testSerializer.getSerializer();
        String expectedType = "aggregateType";
        String expectedIdentifier = "identifier";
        TestScopeDescriptor descriptor = new TestScopeDescriptor(expectedType, expectedIdentifier);
        DbSchedulerHumanReadableDeadlineDetails result = DbSchedulerHumanReadableDeadlineDetails.serialized((String)TEST_DEADLINE_NAME, (ScopeDescriptor)descriptor, MESSAGE, (org.axonframework.serialization.Serializer)serializer);
        Assertions.assertEquals((Object)TEST_DEADLINE_NAME, (Object)result.getDeadlineName());
        Assertions.assertEquals((Object)descriptor, (Object)result.getDeserializedScopeDescriptor(serializer));
        GenericDeadlineMessage resultMessage = result.asDeadLineMessage(serializer);
        Assertions.assertNotNull((Object)resultMessage);
        Assertions.assertEquals((Object)TEST_DEADLINE_PAYLOAD, (Object)resultMessage.getPayload());
        Assertions.assertEquals((Object)META_DATA, (Object)resultMessage.getMetaData());
    }

    public static Collection<Serializer> dbSchedulerSerializers() {
        ArrayList<Serializer> serializers = new ArrayList<Serializer>();
        serializers.add((Serializer)new JavaSerializer());
        serializers.add((Serializer)new JacksonSerializer());
        serializers.add((Serializer)new GsonSerializer());
        return serializers;
    }

    public static Collection<TestSerializer> axonSerializers() {
        ArrayList<TestSerializer> testSerializerList = new ArrayList<TestSerializer>();
        testSerializerList.add(TestSerializer.JACKSON);
        testSerializerList.add(TestSerializer.XSTREAM);
        return testSerializerList;
    }

    private static MetaData getMetaData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("someStringValue", "foo");
        map.put("someIntValue", 2);
        return new MetaData(map);
    }

    private static DeadlineMessage<?> getMessage() {
        return GenericDeadlineMessage.asDeadlineMessage((String)TEST_DEADLINE_NAME, (Object)TEST_DEADLINE_PAYLOAD, (Instant)Instant.now()).withMetaData((Map)DbSchedulerHumanReadableDeadlineDetailsTest.getMetaData());
    }
}

