/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.TestScopeDescriptor;
import org.axonframework.deadline.jobrunr.DeadlineDetails;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class DeadlineDetailsSerializationTest {
    private static final String TEST_DEADLINE_NAME = "deadline-name";
    private static final String TEST_DEADLINE_PAYLOAD = "deadline-payload";
    private static MetaData metaData;
    private static DeadlineMessage message;

    DeadlineDetailsSerializationTest() {
    }

    @BeforeAll
    static void setUp() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("someStringValue", "foo");
        map.put("someIntValue", 2);
        metaData = new MetaData(map);
        message = GenericDeadlineMessage.asDeadlineMessage((String)TEST_DEADLINE_NAME, (Object)TEST_DEADLINE_PAYLOAD, (Instant)Instant.now()).withMetaData((Map)metaData);
    }

    @Test
    void whenSerializedAndDeserializedAllPropertiesShouldBeTheSameUsingXStream() {
        Serializer serializer = TestSerializer.XSTREAM.getSerializer();
        this.testSerialisationWithSpecificSerializer(serializer);
    }

    @Test
    void whenSerializedAndDeserializedAllPropertiesShouldBeTheSameUsingJackson() {
        Serializer serializer = TestSerializer.JACKSON.getSerializer();
        this.testSerialisationWithSpecificSerializer(serializer);
    }

    private void testSerialisationWithSpecificSerializer(Serializer serializer) {
        String expectedType = "aggregateType";
        String expectedIdentifier = "identifier";
        TestScopeDescriptor descriptor = new TestScopeDescriptor(expectedType, expectedIdentifier);
        String serializedDeadlineDetails = DeadlineDetails.serialized((String)TEST_DEADLINE_NAME, (ScopeDescriptor)descriptor, (DeadlineMessage)message, (Serializer)serializer);
        SimpleSerializedObject serializedDeadlineMetaData = new SimpleSerializedObject((Object)serializedDeadlineDetails, String.class, DeadlineDetails.class.getName(), null);
        DeadlineDetails result = (DeadlineDetails)serializer.deserialize((SerializedObject)serializedDeadlineMetaData);
        Assertions.assertEquals((Object)TEST_DEADLINE_NAME, (Object)result.getDeadlineName());
        Assertions.assertEquals((Object)descriptor, (Object)result.getDeserializedScopeDescriptor(serializer));
        GenericDeadlineMessage resultMessage = result.asDeadLineMessage(serializer);
        Assertions.assertNotNull((Object)resultMessage);
        Assertions.assertEquals((Object)TEST_DEADLINE_PAYLOAD, (Object)resultMessage.getPayload());
        Assertions.assertEquals((Object)metaData, (Object)resultMessage.getMetaData());
    }
}

