/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.List;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.MultiEventHandlerInvoker;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MultiEventHandlerInvokerTest {
    private static final Object NO_RESET_PAYLOAD = null;
    private MultiEventHandlerInvoker testSubject;
    private final EventHandlerInvoker mockedEventHandlerInvokerOne = (EventHandlerInvoker)Mockito.mock(EventHandlerInvoker.class);
    private final EventHandlerInvoker mockedEventHandlerInvokerTwo = (EventHandlerInvoker)Mockito.mock(EventHandlerInvoker.class);
    private EventMessage<String> testEventMessage;
    private EventMessage<String> replayMessage;
    private Segment testSegment;

    MultiEventHandlerInvokerTest() {
    }

    @BeforeEach
    void setUp() {
        this.testEventMessage = GenericEventMessage.asEventMessage((Object)"some-event");
        this.replayMessage = new GenericTrackedEventMessage((TrackingToken)new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(10L), (TrackingToken)new GlobalSequenceTrackingToken(0L)), GenericEventMessage.asEventMessage((Object)"replay-event"));
        this.testSegment = new Segment(1, 1);
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.canHandle((EventMessage)Mockito.any(), (Segment)Mockito.eq((Object)this.testSegment))).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.canHandle((EventMessage)Mockito.any(), (Segment)Mockito.eq((Object)this.testSegment))).thenReturn((Object)true);
        this.testSubject = new MultiEventHandlerInvoker(new EventHandlerInvoker[]{this.mockedEventHandlerInvokerOne, this.mockedEventHandlerInvokerTwo});
    }

    @Test
    void delegatesReturnsSetDelegates() {
        List result = this.testSubject.delegates();
        Assertions.assertTrue((boolean)result.contains(this.mockedEventHandlerInvokerOne));
        Assertions.assertTrue((boolean)result.contains(this.mockedEventHandlerInvokerTwo));
    }

    @Test
    void canHandleCallsCanHandleOnTheFirstDelegateToReturn() {
        this.testSubject.canHandle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerOne)).canHandle(this.testEventMessage, this.testSegment);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockedEventHandlerInvokerTwo});
    }

    @Test
    void handleCallsCanHandleAndHandleOfAllDelegates() throws Exception {
        this.testSubject.handle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerOne)).canHandle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerOne)).handle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerTwo)).canHandle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerTwo)).handle(this.testEventMessage, this.testSegment);
    }

    @Test
    void handleThrowsExceptionIfDelegatesThrowAnException() throws Exception {
        ((EventHandlerInvoker)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.mockedEventHandlerInvokerTwo)).handle(this.testEventMessage, this.testSegment);
        Assertions.assertThrows(RuntimeException.class, () -> this.testSubject.handle(this.testEventMessage, this.testSegment));
    }

    @Test
    void supportResetWhenAllSupport() {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.testSubject.supportsReset());
    }

    @Test
    void supportResetWhenSomeSupport() {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.testSubject.supportsReset());
    }

    @Test
    void supportResetWhenNoneSupport() {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.testSubject.supportsReset());
    }

    @Test
    void performReset() {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        this.testSubject.performReset();
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerOne, (VerificationMode)Mockito.times((int)1))).performReset(Mockito.eq((Object)NO_RESET_PAYLOAD));
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerTwo, (VerificationMode)Mockito.never())).performReset(Mockito.eq((Object)NO_RESET_PAYLOAD));
    }

    @Test
    void performResetWithResetContext() {
        String resetContext = "reset-context";
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        this.testSubject.performReset((Object)resetContext);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerOne, (VerificationMode)Mockito.times((int)1))).performReset(Mockito.eq((Object)resetContext));
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerTwo, (VerificationMode)Mockito.never())).performReset(Mockito.eq((Object)resetContext));
    }

    @Test
    void invokersNotSupportingResetDoNotReceiveRedeliveries() throws Exception {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.testSubject.canHandle(this.testEventMessage, this.testSegment));
        this.testSubject.handle(this.testEventMessage, this.testSegment);
        this.testSubject.handle(this.replayMessage, this.testSegment);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedEventHandlerInvokerOne, this.mockedEventHandlerInvokerTwo});
        ((EventHandlerInvoker)inOrder.verify((Object)this.mockedEventHandlerInvokerOne)).handle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)inOrder.verify((Object)this.mockedEventHandlerInvokerTwo)).handle(this.testEventMessage, this.testSegment);
        ((EventHandlerInvoker)inOrder.verify((Object)this.mockedEventHandlerInvokerOne)).handle(this.replayMessage, this.testSegment);
        ((EventHandlerInvoker)Mockito.verify((Object)this.mockedEventHandlerInvokerTwo, (VerificationMode)Mockito.never())).handle((EventMessage)Mockito.eq(this.replayMessage), (Segment)Mockito.any());
    }

    @Test
    void performResetThrowsException() {
        Mockito.when((Object)this.mockedEventHandlerInvokerOne.supportsReset()).thenReturn((Object)true);
        Mockito.when((Object)this.mockedEventHandlerInvokerTwo.supportsReset()).thenReturn((Object)false);
        ((EventHandlerInvoker)Mockito.doThrow(RuntimeException.class).when((Object)this.mockedEventHandlerInvokerOne)).performReset(Mockito.any());
        Assertions.assertThrows(Exception.class, () -> ((MultiEventHandlerInvoker)this.testSubject).performReset());
    }
}

