/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import java.util.Map;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.async.PropertySequencingPolicy;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

@DisplayName(value="Unit-Test for the PropertySequencingPolicy")
final class PropertySequencingPolicyTest {
    PropertySequencingPolicyTest() {
    }

    @Test
    void propertyExtractorShouldReadCorrectValue() {
        PropertySequencingPolicy sequencingPolicy = PropertySequencingPolicy.builder(TestEvent.class, String.class).propertyExtractor(TestEvent::getId).build();
        Assertions.assertEquals((Object)"42", (Object)sequencingPolicy.getSequenceIdentifierFor(this.newStubDomainEvent(new TestEvent("42"))));
    }

    @Test
    void propertyShouldReadCorrectValue() {
        PropertySequencingPolicy sequencingPolicy = PropertySequencingPolicy.builder(TestEvent.class, String.class).propertyName("Id").build();
        Assertions.assertEquals((Object)"42", (Object)sequencingPolicy.getSequenceIdentifierFor(this.newStubDomainEvent(new TestEvent("42"))));
    }

    @Test
    void defaultFallbackShouldThrowException() {
        PropertySequencingPolicy sequencingPolicy = PropertySequencingPolicy.builder(TestEvent.class, String.class).propertyName("Id").build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> sequencingPolicy.getSequenceIdentifierFor(this.newStubDomainEvent("42")));
    }

    @Test
    void fallbackShouldBeApplied() {
        PropertySequencingPolicy sequencingPolicy = PropertySequencingPolicy.builder(TestEvent.class, String.class).propertyName("Id").fallbackSequencingPolicy((SequencingPolicy)SequentialPerAggregatePolicy.instance()).build();
        Assertions.assertEquals((Object)"A", (Object)sequencingPolicy.getSequenceIdentifierFor(this.newStubDomainEvent("42")));
    }

    private DomainEventMessage<?> newStubDomainEvent(Object payload) {
        return new GenericDomainEventMessage("type", "A", 0L, payload, (Map)MetaData.emptyInstance());
    }

    private static class TestEvent {
        private final String id;

        public TestEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

