/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.axonframework.common.AxonException;
import org.axonframework.common.transaction.NoOpTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventHandlerInvoker;
import org.axonframework.eventhandling.pooled.PooledStreamingEventProcessor;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.StreamableMessageSource;
import org.axonframework.messaging.annotation.MessageIdentifier;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.ThrowableCause;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.utils.AssertUtils;
import org.axonframework.utils.InMemoryStreamableEventSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class DeadLetteringEventIntegrationTest {
    protected static final String PROCESSING_GROUP = "problematicProcessingGroup";
    private static final boolean SUCCEED = true;
    private static final boolean SUCCEED_RETRY = true;
    private static final boolean FAIL = false;
    private static final boolean FAIL_RETRY = false;
    private static final int DEFAULT_RETRIES = 1;
    private static final String BLOB_OF_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Gravida quis blandit turpis cursus in. Nulla facilisi etiam dignissim diam quis enim lobortis scelerisque fermentum. Egestas maecenas pharetra convallis posuere morbi leo urna. Dictumst quisque sagittis purus sit amet volutpat consequat. At volutpat diam ut venenatis tellus in metus vulputate eu. Imperdiet dui accumsan sit amet nulla facilisi. Eget est lorem ipsum dolor sit amet. Vestibulum morbi blandit cursus risus at ultrices mi tempus imperdiet. Sed tempus urna et pharetra pharetra massa massa. Dolor magna eget est lorem. Purus semper eget duis at tellus. Tincidunt augue interdum velit euismod in pellentesque massa placerat duis.\n\nQuis ipsum suspendisse ultrices gravida dictum fusce ut. Nascetur ridiculus mus mauris vitae ultricies leo integer malesuada. Sit amet purus gravida quis blandit turpis cursus in. Gravida rutrum quisque non tellus. Eros donec ac odio tempor orci dapibus. Dictum varius duis at consectetur lorem donec massa sapien.Tincidunt arcu non sodales neque sodales ut etiam sit amet. Sagittis aliquam malesuada bibendum arcu vitae. Vel turpis nunc eget lorem dolor sed viverra. In egestas erat imperdiet sed euismod nisi. Lorem ipsum dolor sit amet consectetur.";
    private ProblematicEventHandlingComponent eventHandlingComponent;
    private SequencedDeadLetterQueue<EventMessage<?>> deadLetterQueue;
    private DeadLetteringEventHandlerInvoker deadLetteringInvoker;
    private InMemoryStreamableEventSource eventSource;
    private StreamingEventProcessor streamingProcessor;
    protected TransactionManager transactionManager;
    private final AtomicInteger maxRetries = new AtomicInteger(1);
    private ScheduledExecutorService executor;
    private final AtomicBoolean returnReferenceErrorFromPolicy = new AtomicBoolean(false);

    protected abstract SequencedDeadLetterQueue<EventMessage<?>> buildDeadLetterQueue();

    protected TransactionManager getTransactionManager() {
        return new NoOpTransactionManager();
    }

    @BeforeEach
    void setUp() {
        this.transactionManager = this.getTransactionManager();
        this.eventHandlingComponent = new ProblematicEventHandlingComponent();
        this.deadLetterQueue = this.buildDeadLetterQueue();
        EnqueuePolicy enqueuePolicy = (letter, cause) -> {
            int retries = (Integer)letter.diagnostics().getOrDefault((Object)"retries", (Object)0);
            if (retries < this.maxRetries.get()) {
                Object decisionThrowable = cause;
                if (this.returnReferenceErrorFromPolicy.get()) {
                    decisionThrowable = new ReferenceException(UUID.randomUUID());
                }
                return Decisions.enqueue((Throwable)ThrowableCause.truncated((Throwable)decisionThrowable), l -> MetaData.with((String)"retries", (Object)((Integer)l.diagnostics().getOrDefault((Object)"retries", (Object)0) + 1)));
            }
            return Decisions.evict();
        };
        this.deadLetteringInvoker = ((DeadLetteringEventHandlerInvoker.Builder)((DeadLetteringEventHandlerInvoker.Builder)DeadLetteringEventHandlerInvoker.builder().eventHandlers(new Object[]{this.eventHandlingComponent})).sequencingPolicy(event -> ((DeadLetterableEvent)event.getPayload()).getAggregateIdentifier())).enqueuePolicy(enqueuePolicy).queue(this.deadLetterQueue).transactionManager(this.transactionManager).build();
        this.eventSource = new InMemoryStreamableEventSource();
        this.streamingProcessor = PooledStreamingEventProcessor.builder().name(PROCESSING_GROUP).eventHandlerInvoker((EventHandlerInvoker)this.deadLetteringInvoker).rollbackConfiguration((RollbackConfiguration)RollbackConfigurationType.ANY_THROWABLE).messageSource((StreamableMessageSource)this.eventSource).tokenStore((TokenStore)new InMemoryTokenStore()).transactionManager(this.transactionManager).coordinatorExecutor(Executors.newSingleThreadScheduledExecutor()).workerExecutor(Executors.newSingleThreadScheduledExecutor()).initialSegmentCount(1).claimExtensionThreshold(1000L).build();
        this.executor = Executors.newScheduledThreadPool(2);
    }

    @AfterEach
    void tearDown() {
        boolean executorTerminated = false;
        CompletableFuture processorShutdown = this.streamingProcessor.shutdownAsync();
        try {
            processorShutdown.get(15L, TimeUnit.SECONDS);
            executorTerminated = this.executor.awaitTermination(50L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        if (!executorTerminated) {
            this.executor.shutdownNow();
        }
        this.maxRetries.set(1);
        this.returnReferenceErrorFromPolicy.set(false);
    }

    protected void startProcessingEvent() {
        this.streamingProcessor.start();
    }

    protected void processAnyDeadLetter() {
        this.deadLetteringInvoker.processAny();
    }

    protected void processAnyDeadLettersPeriodically() {
        this.executor.scheduleWithFixedDelay(this::processAnyDeadLetter, 5L, 5L, TimeUnit.MILLISECONDS);
    }

    @Test
    void failedEventHandlingEnqueuesTheEvent() {
        EventMessage failedEvent = GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent("failure", false));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent("success", true)));
        this.eventSource.publishMessage(failedEvent);
        this.startProcessingEvent();
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition().getAsLong() >= 2L ? 1 : 0) != 0));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful("success"));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful("failure"));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)"failure"));
        Assertions.assertFalse((boolean)this.deadLetterQueue.contains((Object)"success"));
        Iterator sequence = this.deadLetterQueue.deadLetterSequence((Object)"failure").iterator();
        Assertions.assertTrue((boolean)sequence.hasNext());
        Assertions.assertEquals((Object)failedEvent.getPayload(), (Object)((EventMessage)((DeadLetter)sequence.next()).message()).getPayload());
        Assertions.assertFalse((boolean)sequence.hasNext());
    }

    @Test
    void eventsInTheSameSequenceAreAllEnqueuedIfOneOfThemFails() {
        int expectedSuccessfulHandlingCount = 3;
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        DeadLetterableEvent firstDeadLetter = new DeadLetterableEvent(aggregateId, false);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)firstDeadLetter));
        DeadLetterableEvent secondDeadLetter = new DeadLetterableEvent(aggregateId, true);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)secondDeadLetter));
        DeadLetterableEvent thirdDeadLetter = new DeadLetterableEvent(aggregateId, true);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)thirdDeadLetter));
        this.startProcessingEvent();
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition().getAsLong() >= 6L ? 1 : 0) != 0));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId));
        Assertions.assertEquals((int)expectedSuccessfulHandlingCount, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId));
        Assertions.assertEquals((int)1, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
        AssertUtils.assertWithin(2, TimeUnit.SECONDS, () -> {
            Iterator sequence = this.deadLetterQueue.deadLetterSequence((Object)aggregateId).iterator();
            Assertions.assertTrue((boolean)sequence.hasNext());
            Assertions.assertEquals((Object)firstDeadLetter, (Object)((EventMessage)((DeadLetter)sequence.next()).message()).getPayload());
            Assertions.assertTrue((boolean)sequence.hasNext());
            Assertions.assertEquals((Object)secondDeadLetter, (Object)((EventMessage)((DeadLetter)sequence.next()).message()).getPayload());
            Assertions.assertTrue((boolean)sequence.hasNext());
            Assertions.assertEquals((Object)thirdDeadLetter, (Object)((EventMessage)((DeadLetter)sequence.next()).message()).getPayload());
            Assertions.assertFalse((boolean)sequence.hasNext());
        });
    }

    @Test
    void successfulRetryingLettersEvictsTheLettersFromTheQueue() {
        int expectedSuccessfulInitialHandlingCount = 3;
        int expectedUnsuccessfulInitialHandlingCount = 1;
        int expectedSuccessfulEvaluationCount = 3;
        int expectedUnsuccessfulEvaluationCount = 0;
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        this.startProcessingEvent();
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition().getAsLong() >= 6L ? 1 : 0) != 0));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId));
        Assertions.assertEquals((int)expectedSuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId));
        Assertions.assertEquals((int)expectedUnsuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
        this.deadLetteringInvoker.process(deadLetter -> true);
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasSuccessful(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)expectedSuccessfulEvaluationCount, (int)this.eventHandlingComponent.successfulEvaluationCount(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertFalse((boolean)this.eventHandlingComponent.evaluationWasUnsuccessful(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)expectedUnsuccessfulEvaluationCount, (int)this.eventHandlingComponent.unsuccessfulEvaluationCount(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertFalse((boolean)this.deadLetterQueue.contains((Object)aggregateId)));
    }

    @Test
    void unsuccessfulProcessingLettersRequeuesTheLettersInTheQueue() {
        int expectedSuccessfulInitialHandlingCount = 3;
        int expectedUnsuccessfulInitialHandlingCount = 1;
        int expectedSuccessfulEvaluationCount = 2;
        int expectedUnsuccessfulEvaluationCount = 1;
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, false)));
        this.startProcessingEvent();
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(2, TimeUnit.SECONDS, () -> {
            OptionalLong optionalPosition = ((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition();
            Assertions.assertTrue((boolean)optionalPosition.isPresent());
            Assertions.assertTrue((optionalPosition.getAsLong() >= 6L ? 1 : 0) != 0);
        });
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId));
        Assertions.assertEquals((int)expectedSuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId));
        Assertions.assertEquals((int)expectedUnsuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
        this.deadLetteringInvoker.process(deadLetter -> true);
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasSuccessful(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)expectedSuccessfulEvaluationCount, (int)this.eventHandlingComponent.successfulEvaluationCount(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasUnsuccessful(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)expectedUnsuccessfulEvaluationCount, (int)this.eventHandlingComponent.unsuccessfulEvaluationCount(aggregateId)));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
    }

    @Test
    void publishEventsAndProcessDeadLettersConcurrentlyShouldWorkFine() {
        int expectedSuccessfulInitialHandlingCount = 3;
        int expectedUnsuccessfulInitialHandlingCount = 1;
        int expectedSuccessfulEvaluationCount = 2;
        int expectedUnsuccessfulEvaluationCount = 1;
        String aggregateId = UUID.randomUUID().toString();
        this.startProcessingEvent();
        this.processAnyDeadLettersPeriodically();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        DeadLetterableEvent firstDeadLetter = new DeadLetterableEvent(aggregateId, false, true);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)firstDeadLetter));
        DeadLetterableEvent secondDeadLetter = new DeadLetterableEvent(aggregateId, true, true);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)secondDeadLetter));
        DeadLetterableEvent thirdDeadLetter = new DeadLetterableEvent(aggregateId, true, false);
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)thirdDeadLetter));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(2, TimeUnit.SECONDS, () -> {
            OptionalLong optionalPosition = ((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition();
            Assertions.assertTrue((boolean)optionalPosition.isPresent());
            Assertions.assertTrue((optionalPosition.getAsLong() >= 6L ? 1 : 0) != 0);
        });
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId));
        Assertions.assertEquals((int)expectedSuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId));
        Assertions.assertEquals((int)expectedUnsuccessfulInitialHandlingCount, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
        AssertUtils.assertWithin(2, TimeUnit.SECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasSuccessful(aggregateId)));
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)expectedSuccessfulEvaluationCount, (int)this.eventHandlingComponent.successfulEvaluationCount(aggregateId)));
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasUnsuccessful(aggregateId)));
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)expectedUnsuccessfulEvaluationCount, (int)this.eventHandlingComponent.unsuccessfulEvaluationCount(aggregateId)));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
    }

    @Test
    @Timeout(value=20L)
    void publishEventsAndProcessDeadLettersConcurrentlyInBulkShouldWorkFine() throws InterruptedException {
        int immediateSuccessesPerAggregate = 5;
        int failFirstAndThenSucceedPerAggregate = 4;
        int persistentFailingPerAggregate = 1;
        int expectedSuccessfulEvaluationCount = failFirstAndThenSucceedPerAggregate - persistentFailingPerAggregate;
        int expectedOverallSuccessfulHandlingCount = immediateSuccessesPerAggregate + expectedSuccessfulEvaluationCount;
        int publishingRuns = 40;
        int totalNumberOfEvents = (immediateSuccessesPerAggregate + failFirstAndThenSucceedPerAggregate) * publishingRuns;
        HashSet aggregateIds = new HashSet();
        HashSet<String> validatedAggregateIds = new HashSet<String>();
        Thread publishingThread = new Thread(() -> {
            for (int i = 0; i < publishingRuns; ++i) {
                String aggregateId = Integer.toString(i);
                this.publishEventsFor(aggregateId, immediateSuccessesPerAggregate, failFirstAndThenSucceedPerAggregate, persistentFailingPerAggregate);
                aggregateIds.add(aggregateId);
            }
        });
        this.startProcessingEvent();
        this.processAnyDeadLettersPeriodically();
        publishingThread.start();
        AssertUtils.assertWithin(1, TimeUnit.SECONDS, () -> Assertions.assertEquals((int)1, (int)this.streamingProcessor.processingStatus().size()));
        AssertUtils.assertWithin(15, TimeUnit.SECONDS, () -> {
            OptionalLong optionalPosition = ((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition();
            Assertions.assertTrue((boolean)optionalPosition.isPresent());
            Assertions.assertEquals((long)totalNumberOfEvents, (long)optionalPosition.getAsLong());
        });
        for (String aggregateId : aggregateIds) {
            if (validatedAggregateIds.contains(aggregateId)) continue;
            AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId)));
            AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)immediateSuccessesPerAggregate, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId)));
            AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId)));
            Assertions.assertEquals((int)1, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
            AssertUtils.assertWithin(15, TimeUnit.SECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasSuccessful(aggregateId)));
            AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)expectedSuccessfulEvaluationCount, (int)this.eventHandlingComponent.successfulEvaluationCount(aggregateId)));
            AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)this.eventHandlingComponent.evaluationWasUnsuccessful(aggregateId)));
            Assertions.assertTrue((this.eventHandlingComponent.unsuccessfulEvaluationCount(aggregateId) >= persistentFailingPerAggregate ? 1 : 0) != 0);
            Assertions.assertEquals((int)expectedOverallSuccessfulHandlingCount, (int)this.eventHandlingComponent.overallSuccessfulHandlingCount(aggregateId));
            validatedAggregateIds.add(aggregateId);
        }
        publishingThread.join();
    }

    @Test
    void processedDeadLetterIsResolvedAsParameterToEventHandlers() {
        int expectedSuccessfulHandlingCount = 3;
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        this.startProcessingEvent();
        Awaitility.await().pollDelay(Duration.ofMillis(25L)).atMost(Duration.ofSeconds(1L)).until(() -> this.streamingProcessor.processingStatus().size() == 1);
        Awaitility.await().pollDelay(Duration.ofMillis(25L)).atMost(Duration.ofSeconds(1L)).until(() -> ((EventTrackerStatus)this.streamingProcessor.processingStatus().get(0)).getCurrentPosition().getAsLong() >= 6L);
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasSuccessful(aggregateId));
        Assertions.assertEquals((int)expectedSuccessfulHandlingCount, (int)this.eventHandlingComponent.successfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.eventHandlingComponent.initialHandlingWasUnsuccessful(aggregateId));
        Assertions.assertEquals((int)1, (int)this.eventHandlingComponent.unsuccessfulInitialHandlingCount(aggregateId));
        Assertions.assertTrue((boolean)this.deadLetterQueue.contains((Object)aggregateId));
        this.deadLetteringInvoker.process(deadLetter -> true);
        Assertions.assertEquals((int)3, (int)this.eventHandlingComponent.resolvedDeadLetterParameterCount(aggregateId));
    }

    @Test
    void deadLetterEventProcessingTaskIsUsingInterceptor() {
        this.maxRetries.set(3);
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.deadLetteringInvoker.registerHandlerInterceptor(this.errorCatchingInterceptor(invoked));
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false)));
        this.startProcessingEvent();
        Awaitility.await().pollDelay(Duration.ofMillis(25L)).atMost(Duration.ofSeconds(10L)).until(() -> this.deadLetterQueue.size() == 1L);
        this.eventHandlingComponent.handledEvent.clear();
        this.eventHandlingComponent.firstTryFailures.clear();
        this.deadLetteringInvoker.process(deadLetter -> true);
        Assertions.assertTrue((boolean)invoked.get());
        Assertions.assertEquals((long)0L, (long)this.deadLetterQueue.size());
    }

    @Test
    void causeFromDecisionShouldBeStored() {
        this.returnReferenceErrorFromPolicy.set(true);
        String aggregateId = UUID.randomUUID().toString();
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false)));
        this.startProcessingEvent();
        Awaitility.await().pollDelay(Duration.ofMillis(25L)).atMost(Duration.ofSeconds(1L)).until(() -> this.deadLetterQueue.amountOfSequences() == 1L);
        DeadLetter deadLetter = (DeadLetter)((Iterable)this.deadLetterQueue.deadLetters().iterator().next()).iterator().next();
        Assertions.assertTrue((boolean)deadLetter.cause().isPresent());
        String causeType = ((Cause)deadLetter.cause().get()).type();
        Assertions.assertEquals((Object)ReferenceException.class.getName(), (Object)causeType);
    }

    @Test
    void largeThrowableMessageIsTruncatedUponCauseCreation() {
        String aggregateId = UUID.randomUUID().toString();
        String truncatedText = "truncated-text";
        String testCauseMessage = BLOB_OF_TEXT + truncatedText;
        this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false, false, testCauseMessage)));
        this.startProcessingEvent();
        Awaitility.await().pollDelay(Duration.ofMillis(25L)).atMost(Duration.ofSeconds(1L)).until(() -> this.deadLetterQueue.amountOfSequences() == 1L);
        DeadLetter deadLetter = (DeadLetter)((Iterable)this.deadLetterQueue.deadLetters().iterator().next()).iterator().next();
        Optional optionalCause = deadLetter.cause();
        Assertions.assertTrue((boolean)optionalCause.isPresent());
        String resultMessage = ((Cause)optionalCause.get()).message();
        Assertions.assertNotEquals((Object)testCauseMessage, (Object)resultMessage);
        Assertions.assertFalse((boolean)resultMessage.contains(truncatedText));
        Assertions.assertTrue((boolean)resultMessage.contains(BLOB_OF_TEXT.substring(0, 10)));
    }

    private void publishEventsFor(String aggregateId, int immediateSuccessesPerAggregate, int failFirstAndThenSucceedPerAggregate, int persistentFailingPerAggregate) {
        int i;
        for (i = 0; i < immediateSuccessesPerAggregate; ++i) {
            this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true)));
        }
        for (i = 0; i < failFirstAndThenSucceedPerAggregate; ++i) {
            if (i == 0) {
                this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, false, true)));
                continue;
            }
            if (failFirstAndThenSucceedPerAggregate - persistentFailingPerAggregate == i) {
                this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, false)));
                continue;
            }
            this.eventSource.publishMessage(GenericEventMessage.asEventMessage((Object)new DeadLetterableEvent(aggregateId, true, true)));
        }
    }

    private MessageHandlerInterceptor<? super EventMessage<?>> errorCatchingInterceptor(AtomicBoolean invoked) {
        return (unitOfWork, chain) -> {
            invoked.set(true);
            try {
                chain.proceed();
            }
            catch (RuntimeException e) {
                return unitOfWork;
            }
            return unitOfWork;
        };
    }

    private static class ReferenceException
    extends AxonException {
        private static final long serialVersionUID = 1380362964599517107L;

        ReferenceException(UUID reference) {
            super(reference.toString());
        }
    }

    private static class DeadLetterableEvent {
        private final String aggregateIdentifier;
        private final boolean shouldSucceed;
        private final boolean shouldSucceedOnEvaluation;
        private final String causeMessage;

        private DeadLetterableEvent(String aggregateIdentifier, boolean shouldSucceed) {
            this(aggregateIdentifier, shouldSucceed, true);
        }

        private DeadLetterableEvent(String aggregateIdentifier, boolean shouldSucceed, boolean shouldSucceedOnEvaluation) {
            this(aggregateIdentifier, shouldSucceed, shouldSucceedOnEvaluation, "");
        }

        @JsonCreator
        public DeadLetterableEvent(@JsonProperty(value="aggregateIdentifier") String aggregateIdentifier, @JsonProperty(value="shouldSucceed") boolean shouldSucceed, @JsonProperty(value="shouldSucceedOnEvaluation") boolean shouldSucceedOnEvaluation, @JsonProperty(value="causeMessage") String causeMessage) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.shouldSucceed = shouldSucceed;
            this.shouldSucceedOnEvaluation = shouldSucceedOnEvaluation;
            this.causeMessage = causeMessage;
        }

        public String getAggregateIdentifier() {
            return this.aggregateIdentifier;
        }

        public boolean isShouldSucceed() {
            return this.shouldSucceed;
        }

        public boolean isShouldSucceedOnEvaluation() {
            return this.shouldSucceedOnEvaluation;
        }

        public String getCauseMessage() {
            return this.causeMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeadLetterableEvent that = (DeadLetterableEvent)o;
            return this.shouldSucceed == that.shouldSucceed && this.shouldSucceedOnEvaluation == that.shouldSucceedOnEvaluation && Objects.equals(this.aggregateIdentifier, that.aggregateIdentifier) && Objects.equals(this.causeMessage, that.causeMessage);
        }

        public int hashCode() {
            return Objects.hash(this.aggregateIdentifier, this.shouldSucceed, this.shouldSucceedOnEvaluation, this.causeMessage);
        }

        public String toString() {
            return "DeadLetterableEvent{aggregateIdentifier='" + this.aggregateIdentifier + '\'' + ", shouldSucceed=" + this.shouldSucceed + ", shouldSucceedOnEvaluation=" + this.shouldSucceedOnEvaluation + ", causeMessage='" + this.causeMessage + '\'' + '}';
        }
    }

    private static class ProblematicEventHandlingComponent {
        private final Set<String> handledEvent = new ConcurrentSkipListSet<String>();
        private final Map<String, Integer> firstTrySuccesses = new ConcurrentSkipListMap<String, Integer>();
        private final Map<String, Integer> evaluationSuccesses = new ConcurrentSkipListMap<String, Integer>();
        private final Map<String, Integer> firstTryFailures = new ConcurrentSkipListMap<String, Integer>();
        private final Map<String, Integer> evaluationFailures = new ConcurrentSkipListMap<String, Integer>();
        private final Map<String, Integer> hasResolvedDeadLetterParameter = new ConcurrentSkipListMap<String, Integer>();

        private ProblematicEventHandlingComponent() {
        }

        @EventHandler
        public void on(DeadLetterableEvent event, @MessageIdentifier String eventIdentifier, DeadLetter<EventMessage<DeadLetterableEvent>> deadLetter) {
            String sequenceId = event.getAggregateIdentifier();
            if (!this.handledEvent.contains(eventIdentifier)) {
                this.handledEvent.add(eventIdentifier);
                if (!this.initialHandlingWasUnsuccessful(sequenceId)) {
                    this.processInitialHandlingOf(event, sequenceId);
                } else {
                    this.processEvaluationOf(event, sequenceId);
                }
            } else {
                this.processEvaluationOf(event, sequenceId);
            }
            if (deadLetter != null) {
                this.hasResolvedDeadLetterParameter.compute(sequenceId, (id, count) -> {
                    int n;
                    if (count == null) {
                        n = 1;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    return n;
                });
            }
        }

        private void processInitialHandlingOf(DeadLetterableEvent event, String sequenceId) {
            if (!event.isShouldSucceed()) {
                this.firstTryFailures.compute(sequenceId, (id, count) -> {
                    int n;
                    if (count == null) {
                        n = 1;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    return n;
                });
                throw new RuntimeException("Initial handling failed. Let's dead letter event [" + sequenceId + "].\n" + event.getCauseMessage());
            }
            this.firstTrySuccesses.compute(sequenceId, (id, count) -> {
                int n;
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                return n;
            });
        }

        private void processEvaluationOf(DeadLetterableEvent event, String sequenceId) {
            if (!event.isShouldSucceedOnEvaluation()) {
                this.evaluationFailures.compute(sequenceId, (id, count) -> {
                    int n;
                    if (count == null) {
                        n = 1;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    return n;
                });
                throw new RuntimeException("Evaluation failed. Let's dead letter event [" + sequenceId + "].\n" + event.getCauseMessage());
            }
            this.evaluationSuccesses.compute(sequenceId, (id, count) -> {
                int n;
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                return n;
            });
        }

        public boolean initialHandlingWasSuccessful(String sequenceId) {
            return this.firstTrySuccesses.containsKey(sequenceId);
        }

        public int successfulInitialHandlingCount(String sequenceId) {
            return this.initialHandlingWasSuccessful(sequenceId) ? this.firstTrySuccesses.get(sequenceId) : 0;
        }

        public boolean evaluationWasSuccessful(String sequenceId) {
            return this.evaluationSuccesses.containsKey(sequenceId);
        }

        public int successfulEvaluationCount(String sequenceId) {
            return this.evaluationWasSuccessful(sequenceId) ? this.evaluationSuccesses.get(sequenceId) : 0;
        }

        public boolean initialHandlingWasUnsuccessful(String sequenceId) {
            return this.firstTryFailures.containsKey(sequenceId);
        }

        public int unsuccessfulInitialHandlingCount(String sequenceId) {
            return this.initialHandlingWasUnsuccessful(sequenceId) ? this.firstTryFailures.get(sequenceId) : 0;
        }

        public boolean evaluationWasUnsuccessful(String sequenceId) {
            return this.evaluationFailures.containsKey(sequenceId);
        }

        public int unsuccessfulEvaluationCount(String sequenceId) {
            return this.evaluationWasUnsuccessful(sequenceId) ? this.evaluationFailures.get(sequenceId) : 0;
        }

        public int overallSuccessfulHandlingCount(String sequenceId) {
            return this.firstTrySuccesses.get(sequenceId) + this.evaluationSuccesses.get(sequenceId);
        }

        public int resolvedDeadLetterParameterCount(String sequenceId) {
            return this.hasResolvedDeadLetterParameter.get(sequenceId);
        }
    }
}

