/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventIntegrationTest;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.GenericDeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcSequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.serialization.TestSerializer;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

class JdbcDeadLetteringEventIntegrationTest
extends DeadLetteringEventIntegrationTest {
    private static final String TEST_PROCESSING_GROUP = "some-processing-group";
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private JdbcSequencedDeadLetterQueue<EventMessage<?>> jdbcDeadLetterQueue;
    private final DeadLetterSchema schema = DeadLetterSchema.defaultSchema();

    JdbcDeadLetteringEventIntegrationTest() {
    }

    @Override
    protected SequencedDeadLetterQueue<EventMessage<?>> buildDeadLetterQueue() {
        this.dataSource = this.dataSource();
        this.transactionManager = this.transactionManager(this.dataSource);
        this.jdbcDeadLetterQueue = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider(this.dataSource::getConnection).schema(this.schema).transactionManager(this.transactionManager).genericSerializer(TestSerializer.JACKSON.getSerializer()).eventSerializer(TestSerializer.JACKSON.getSerializer()).build();
        return this.jdbcDeadLetterQueue;
    }

    private DataSource dataSource() {
        JDBCDataSource dataSource = new JDBCDataSource();
        dataSource.setUrl("jdbc:hsqldb:mem:axontest");
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    private TransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
        return () -> this.lambda$transactionManager$0((PlatformTransactionManager)platformTransactionManager);
    }

    @BeforeEach
    void setUpJdbc() {
        this.transactionManager.executeInTransaction(() -> {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                connection.prepareStatement("DROP TABLE IF EXISTS " + this.schema.deadLetterTable()).executeUpdate();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Enable to retrieve a Connection to drop the dead-letter queue", e);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            this.jdbcDeadLetterQueue.createSchema((DeadLetterTableFactory)new GenericDeadLetterTableFactory());
        });
    }

    private /* synthetic */ Transaction lambda$transactionManager$0(final PlatformTransactionManager platformTransactionManager) {
        final TransactionStatus transaction = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        return new Transaction(){

            public void commit() {
                platformTransactionManager.commit(transaction);
            }

            public void rollback() {
                platformTransactionManager.rollback(transaction);
            }
        };
    }
}

