/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.MergedTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.MergeTask;
import org.axonframework.eventhandling.pooled.WorkPackage;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class MergeTaskTest {
    private static final String PROCESSOR_NAME = "test";
    private static final int SEGMENT_TO_MERGE = 0;
    private static final int SEGMENT_TO_BE_MERGED = 1;
    private static final int[] SEGMENT_IDS = new int[]{0, 1};
    private static final Segment SEGMENT_ZERO = Segment.computeSegment((int)0, (int[])SEGMENT_IDS);
    private static final Segment SEGMENT_ONE = Segment.computeSegment((int)1, (int[])SEGMENT_IDS);
    private CompletableFuture<Boolean> result;
    private final Map<Integer, WorkPackage> workPackages = new HashMap<Integer, WorkPackage>();
    private final TokenStore tokenStore = (TokenStore)Mockito.mock(TokenStore.class);
    private MergeTask testSubject;
    private final WorkPackage workPackageOne = (WorkPackage)Mockito.mock(WorkPackage.class);
    private final WorkPackage workPackageTwo = (WorkPackage)Mockito.mock(WorkPackage.class);

    MergeTaskTest() {
    }

    @BeforeEach
    void setUp() {
        this.result = new CompletableFuture();
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenReturn((Object)SEGMENT_IDS);
        this.testSubject = new MergeTask(this.result, PROCESSOR_NAME, 0, this.workPackages, this.tokenStore, NoTransactionManager.instance());
    }

    @Test
    void runReturnsFalseThroughSegmentIdsWhichCannotMerge() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenReturn((Object)new int[]{0});
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).fetchSegments(PROCESSOR_NAME);
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertFalse((boolean)this.result.get());
    }

    @Test
    void runMergeSegmentsFromWorkPackages() throws ExecutionException, InterruptedException {
        GlobalSequenceTrackingToken testTokenToMerge = new GlobalSequenceTrackingToken(0L);
        GlobalSequenceTrackingToken testTokenToBeMerged = new GlobalSequenceTrackingToken(1L);
        Mockito.when((Object)this.workPackageOne.segment()).thenReturn((Object)SEGMENT_ZERO);
        Mockito.when((Object)this.workPackageOne.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenReturn((Object)testTokenToMerge);
        this.workPackages.put(0, this.workPackageOne);
        Mockito.when((Object)this.workPackageTwo.segment()).thenReturn((Object)SEGMENT_ONE);
        Mockito.when((Object)this.workPackageTwo.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 1)).thenReturn((Object)testTokenToBeMerged);
        this.workPackages.put(1, this.workPackageTwo);
        ArgumentCaptor mergedTokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).fetchSegments(PROCESSOR_NAME);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).deleteToken(PROCESSOR_NAME, 1);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)mergedTokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)0));
        TrackingToken resultToken = (TrackingToken)mergedTokenCaptor.getValue();
        Assertions.assertTrue((boolean)resultToken.getClass().isAssignableFrom(MergedTrackingToken.class));
        Assertions.assertEquals((Object)testTokenToMerge, (Object)((MergedTrackingToken)resultToken).lowerSegmentToken());
        Assertions.assertEquals((Object)testTokenToBeMerged, (Object)((MergedTrackingToken)resultToken).upperSegmentToken());
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).releaseClaim(PROCESSOR_NAME, 0);
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.get());
    }

    @Test
    void runMergeSegmentsAfterClaimingBoth() throws ExecutionException, InterruptedException {
        GlobalSequenceTrackingToken testTokenToMerge = new GlobalSequenceTrackingToken(0L);
        GlobalSequenceTrackingToken testTokenToBeMerged = new GlobalSequenceTrackingToken(1L);
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenReturn((Object)testTokenToMerge);
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 1)).thenReturn((Object)testTokenToBeMerged);
        ArgumentCaptor mergedTokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).fetchSegments(PROCESSOR_NAME);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).deleteToken(PROCESSOR_NAME, 1);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)mergedTokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)0));
        TrackingToken resultToken = (TrackingToken)mergedTokenCaptor.getValue();
        Assertions.assertTrue((boolean)resultToken.getClass().isAssignableFrom(MergedTrackingToken.class));
        Assertions.assertEquals((Object)testTokenToMerge, (Object)((MergedTrackingToken)resultToken).lowerSegmentToken());
        Assertions.assertEquals((Object)testTokenToBeMerged, (Object)((MergedTrackingToken)resultToken).upperSegmentToken());
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).releaseClaim(PROCESSOR_NAME, 0);
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.get());
    }

    @Test
    void runMergeSegmentsFromWorkPackageAndClaimedSegment() throws ExecutionException, InterruptedException {
        GlobalSequenceTrackingToken testTokenToMerge = new GlobalSequenceTrackingToken(0L);
        GlobalSequenceTrackingToken testTokenToBeMerged = new GlobalSequenceTrackingToken(1L);
        Mockito.when((Object)this.workPackageOne.segment()).thenReturn((Object)SEGMENT_ZERO);
        Mockito.when((Object)this.workPackageOne.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenReturn((Object)testTokenToMerge);
        this.workPackages.put(0, this.workPackageOne);
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 1)).thenReturn((Object)testTokenToBeMerged);
        ArgumentCaptor mergedTokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        this.testSubject.run();
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).fetchSegments(PROCESSOR_NAME);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).deleteToken(PROCESSOR_NAME, 1);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)mergedTokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)0));
        TrackingToken resultToken = (TrackingToken)mergedTokenCaptor.getValue();
        Assertions.assertTrue((boolean)resultToken.getClass().isAssignableFrom(MergedTrackingToken.class));
        Assertions.assertEquals((Object)testTokenToMerge, (Object)((MergedTrackingToken)resultToken).lowerSegmentToken());
        Assertions.assertEquals((Object)testTokenToBeMerged, (Object)((MergedTrackingToken)resultToken).upperSegmentToken());
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).releaseClaim(PROCESSOR_NAME, 0);
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.get());
    }

    @Test
    void runCompletesExceptionallyThroughUnableToClaimTokenExceptionOnFetch() {
        Mockito.when((Object)this.tokenStore.fetchSegments(PROCESSOR_NAME)).thenReturn((Object)SEGMENT_IDS);
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenThrow(new Throwable[]{new UnableToClaimTokenException("some exception")});
        this.testSubject.run();
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.isCompletedExceptionally());
        Assertions.assertThrows(ExecutionException.class, () -> this.result.get());
    }

    @Test
    void runCompletesExceptionallyThroughUnableToClaimTokenExceptionOnDelete() {
        Mockito.when((Object)this.workPackageOne.segment()).thenReturn((Object)SEGMENT_ZERO);
        Mockito.when((Object)this.workPackageOne.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenReturn((Object)new GlobalSequenceTrackingToken(0L));
        this.workPackages.put(0, this.workPackageOne);
        Mockito.when((Object)this.workPackageTwo.segment()).thenReturn((Object)SEGMENT_ONE);
        Mockito.when((Object)this.workPackageTwo.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 1)).thenReturn((Object)new GlobalSequenceTrackingToken(1L));
        this.workPackages.put(1, this.workPackageTwo);
        ((TokenStore)Mockito.doThrow((Throwable[])new Throwable[]{new UnableToClaimTokenException("some exception")}).when((Object)this.tokenStore)).deleteToken(PROCESSOR_NAME, 1);
        this.testSubject.run();
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.isCompletedExceptionally());
        Assertions.assertThrows(ExecutionException.class, () -> this.result.get());
    }

    @Test
    void runCompletesExceptionallyThroughOtherException() {
        Mockito.when((Object)this.workPackageOne.segment()).thenReturn((Object)SEGMENT_ZERO);
        Mockito.when((Object)this.workPackageOne.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 0)).thenReturn((Object)new GlobalSequenceTrackingToken(0L));
        this.workPackages.put(0, this.workPackageOne);
        Mockito.when((Object)this.workPackageTwo.segment()).thenReturn((Object)SEGMENT_ONE);
        Mockito.when((Object)this.workPackageTwo.abort(null)).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.tokenStore.fetchToken(PROCESSOR_NAME, 1)).thenReturn((Object)new GlobalSequenceTrackingToken(1L));
        this.workPackages.put(1, this.workPackageTwo);
        ((TokenStore)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("some exception")}).when((Object)this.tokenStore)).deleteToken(PROCESSOR_NAME, 1);
        this.testSubject.run();
        Assertions.assertTrue((boolean)this.result.isDone());
        Assertions.assertTrue((boolean)this.result.isCompletedExceptionally());
        Assertions.assertThrows(ExecutionException.class, () -> this.result.get());
    }

    @Test
    void description() {
        String result = this.testSubject.getDescription();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.contains("Merge"));
    }
}

