/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.awaitility.Awaitility;
import org.axonframework.eventhandling.scheduling.dbscheduler.AbstractDbSchedulerEventSchedulerTest;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerBinaryEventData;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventScheduler;
import org.axonframework.utils.DbSchedulerTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BinaryDbSchedulerEventSchedulerTest
extends AbstractDbSchedulerEventSchedulerTest {
    BinaryDbSchedulerEventSchedulerTest() {
    }

    @Override
    Task<?> getTask() {
        return DbSchedulerEventScheduler.binaryTask();
    }

    @Override
    boolean useBinaryPojo() {
        return true;
    }

    @Test
    void whenNotInitializedThrow() {
        this.eventScheduler.shutdown();
        this.scheduler = DbSchedulerTestUtil.getScheduler(this.dataSource, this.getTask());
        this.scheduler.start();
        try {
            TaskInstance instance = DbSchedulerEventScheduler.binaryTask().instance("id", (Object)new DbSchedulerBinaryEventData());
            this.scheduler.schedule(instance, Instant.now());
            Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> {
                List failures = this.scheduler.getFailingExecutions(Duration.ofHours(1L));
                Assertions.assertEquals((int)1, (int)failures.size());
                Assertions.assertNotNull((Object)((Execution)failures.get((int)0)).lastFailure);
            });
        }
        finally {
            this.scheduler.stop();
        }
    }
}

