/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageIdentifier;
import org.axonframework.messaging.annotation.MessageIdentifierParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MessageIdentifierParameterResolverFactoryTest {
    private MessageIdentifierParameterResolverFactory testSubject;
    private Method messageIdentifierMethod;
    private Method nonAnnotatedMethod;
    private Method integerMethod;

    MessageIdentifierParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new MessageIdentifierParameterResolverFactory();
        this.messageIdentifierMethod = this.getClass().getMethod("someMessageIdentifierMethod", String.class);
        this.nonAnnotatedMethod = this.getClass().getMethod("someNonAnnotatedMethod", String.class);
        this.integerMethod = this.getClass().getMethod("someIntegerMethod", Integer.class);
    }

    public void someMessageIdentifierMethod(@MessageIdentifier String messageIdentifier) {
    }

    public void someNonAnnotatedMethod(String messageIdentifier) {
    }

    public void someIntegerMethod(@MessageIdentifier Integer messageIdentifier) {
    }

    @Test
    void resolvesToMessageIdentifierWhenAnnotatedForEventMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageIdentifierMethod, this.messageIdentifierMethod.getParameters(), 0);
        EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)eventMessage));
        Assertions.assertEquals((Object)eventMessage.getIdentifier(), (Object)resolver.resolveParameterValue((Message)eventMessage));
    }

    @Test
    void resolvesToMessageIdentifierWhenAnnotatedForCommandMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.messageIdentifierMethod, this.messageIdentifierMethod.getParameters(), 0);
        CommandMessage commandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)commandMessage));
        Assertions.assertEquals((Object)commandMessage.getIdentifier(), (Object)resolver.resolveParameterValue((Message)commandMessage));
    }

    @Test
    void ignoredWhenNotAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.nonAnnotatedMethod, this.nonAnnotatedMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void ignoredWhenWrongType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.integerMethod, this.integerMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }
}

