/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.UUID;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.SourceId;
import org.axonframework.messaging.annotation.SourceIdParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SourceIdParameterResolverFactoryTest {
    private SourceIdParameterResolverFactory testSubject;
    private Method sourceIdMethod;
    private Method nonAnnotatedMethod;
    private Method integerMethod;

    SourceIdParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new SourceIdParameterResolverFactory();
        this.sourceIdMethod = this.getClass().getMethod("someSourceIdMethod", String.class);
        this.nonAnnotatedMethod = this.getClass().getMethod("someNonAnnotatedMethod", String.class);
        this.integerMethod = this.getClass().getMethod("someIntegerMethod", Integer.class);
    }

    public void someSourceIdMethod(@SourceId String id) {
    }

    public void someNonAnnotatedMethod(String id) {
    }

    public void someIntegerMethod(@SourceId Integer id) {
    }

    @Test
    void resolvesToAggregateIdentifierWhenAnnotatedForDomainEventMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.sourceIdMethod, this.sourceIdMethod.getParameters(), 0);
        GenericDomainEventMessage eventMessage = new GenericDomainEventMessage("test", UUID.randomUUID().toString(), 0L, null);
        Assertions.assertTrue((boolean)resolver.matches((Message)eventMessage));
        Assertions.assertEquals((Object)eventMessage.getAggregateIdentifier(), (Object)resolver.resolveParameterValue((Message)eventMessage));
    }

    @Test
    void doesNotMatchWhenAnnotatedForCommandMessage() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.sourceIdMethod, this.sourceIdMethod.getParameters(), 0);
        CommandMessage commandMessage = GenericCommandMessage.asCommandMessage((Object)"test");
        Assertions.assertFalse((boolean)resolver.matches((Message)commandMessage));
    }

    @Test
    void ignoredWhenNotAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.nonAnnotatedMethod, this.nonAnnotatedMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void ignoredWhenWrongType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.integerMethod, this.integerMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }
}

