/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.ThrowableCause;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericDeadLetterTest {
    private static final String SEQUENCE_IDENTIFIER = "sesequenceIdentifier";
    private static final EventMessage<String> MESSAGE = GenericEventMessage.asEventMessage((Object)"payload");

    GenericDeadLetterTest() {
    }

    @Test
    void constructorForIdentifierAndMessageSetsGivenIdentifierAndMessage() {
        Instant expectedTime = Instant.now();
        GenericDeadLetter.clock = Clock.fixed(expectedTime, ZoneId.systemDefault());
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE);
        Assertions.assertEquals(MESSAGE, (Object)testSubject.message());
        Assertions.assertFalse((boolean)testSubject.cause().isPresent());
        Assertions.assertEquals((Object)expectedTime, (Object)testSubject.enqueuedAt());
        Assertions.assertEquals((Object)expectedTime, (Object)testSubject.lastTouched());
        Assertions.assertTrue((boolean)testSubject.diagnostics().isEmpty());
    }

    @Test
    void constructorForIdentifierMessageAndThrowableSetsGivenIdentifierMessageAndIdentifier() {
        RuntimeException testThrowable = new RuntimeException("just because");
        ThrowableCause expectedCause = new ThrowableCause((Throwable)testThrowable);
        Instant expectedTime = Instant.now();
        GenericDeadLetter.clock = Clock.fixed(expectedTime, ZoneId.systemDefault());
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, (Throwable)testThrowable);
        Assertions.assertEquals(MESSAGE, (Object)testSubject.message());
        Optional resultCause = testSubject.cause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)expectedCause, resultCause.get());
        Assertions.assertEquals((Object)expectedTime, (Object)testSubject.enqueuedAt());
        Assertions.assertEquals((Object)expectedTime, (Object)testSubject.lastTouched());
        Assertions.assertTrue((boolean)testSubject.diagnostics().isEmpty());
    }

    @Test
    void constructorCompletelyManualSetsGivenFields() {
        ThrowableCause expectedCause = new ThrowableCause((Throwable)new RuntimeException("just because"));
        Instant expectedEnqueuedAt = Instant.now();
        Instant expectedLastTouched = Instant.now();
        MetaData expectedDiagnostics = MetaData.with((String)"key", (Object)"value");
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, (Cause)expectedCause, expectedEnqueuedAt, expectedLastTouched, expectedDiagnostics);
        Assertions.assertEquals(MESSAGE, (Object)testSubject.message());
        Optional resultCause = testSubject.cause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)expectedCause, resultCause.get());
        Assertions.assertEquals((Object)expectedEnqueuedAt, (Object)testSubject.enqueuedAt());
        Assertions.assertEquals((Object)expectedLastTouched, (Object)testSubject.lastTouched());
        Assertions.assertEquals((Object)expectedDiagnostics, (Object)testSubject.diagnostics());
    }

    @Test
    void invokingMarkTouchedAdjustsLastTouched() {
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE);
        Instant expectedLastTouched = Instant.now();
        GenericDeadLetter.clock = Clock.fixed(expectedLastTouched, ZoneId.systemDefault());
        DeadLetter result = testSubject.markTouched();
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertFalse((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)expectedLastTouched, (Object)result.lastTouched());
        Assertions.assertEquals((Object)testSubject.diagnostics(), (Object)result.diagnostics());
    }

    @Test
    void invokingWithCauseAndWithoutOriginalCauseSetsGivenCause() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        RuntimeException testThrowable = new RuntimeException("just because");
        ThrowableCause expectedCause = new ThrowableCause((Throwable)testThrowable);
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE);
        DeadLetter result = testSubject.withCause((Throwable)testThrowable);
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)expectedCause, resultCause.get());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testSubject.diagnostics(), (Object)result.diagnostics());
    }

    @Test
    void invokingWithCauseAndOriginalCauseReplacesTheOriginalCause() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        RuntimeException originalThrowable = new RuntimeException("some other issue");
        RuntimeException testThrowable = new RuntimeException("just because");
        ThrowableCause expectedCause = new ThrowableCause((Throwable)testThrowable);
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, (Throwable)originalThrowable);
        DeadLetter result = testSubject.withCause((Throwable)testThrowable);
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)expectedCause, resultCause.get());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testSubject.diagnostics(), (Object)result.diagnostics());
    }

    @Test
    void invokingWithNullCauseAndNoOriginalCauseLeavesTheCauseEmpty() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE);
        DeadLetter result = testSubject.withCause(null);
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Assertions.assertFalse((boolean)result.cause().isPresent());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testSubject.diagnostics(), (Object)result.diagnostics());
    }

    @Test
    void invokingWithNullCauseAndOriginalCauseKeepsTheOriginalCause() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        RuntimeException testThrowable = new RuntimeException("just because");
        ThrowableCause expectedCause = new ThrowableCause((Throwable)testThrowable);
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, (Throwable)testThrowable);
        DeadLetter result = testSubject.withCause(null);
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals(resultCause.get(), (Object)expectedCause);
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testSubject.diagnostics(), (Object)result.diagnostics());
    }

    @Test
    void invokingWithDiagnosticsReplacesTheOriginalDiagnostics() {
        Instant expectedTime = Instant.now();
        GenericDeadLetter.clock = Clock.fixed(expectedTime, ZoneId.systemDefault());
        MetaData originalDiagnostics = MetaData.with((String)"old-key", (Object)"old-value");
        MetaData expectedDiagnostics = MetaData.with((String)"new-key", (Object)"new-value");
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, null, expectedTime, expectedTime, originalDiagnostics);
        DeadLetter result = testSubject.withDiagnostics(expectedDiagnostics);
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertFalse((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)expectedDiagnostics, (Object)result.diagnostics());
    }

    @Test
    void invokingWithDiagnosticsBuilderAppendsTheOriginalDiagnostics() {
        Instant expectedTime = Instant.now();
        GenericDeadLetter.clock = Clock.fixed(expectedTime, ZoneId.systemDefault());
        MetaData originalDiagnostics = MetaData.with((String)"old-key", (Object)"old-value");
        MetaData expectedDiagnostics = MetaData.with((String)"old-key", (Object)"old-value").and("new-key", (Object)"new-value");
        GenericDeadLetter testSubject = new GenericDeadLetter((Object)SEQUENCE_IDENTIFIER, MESSAGE, null, expectedTime, expectedTime, originalDiagnostics);
        DeadLetter result = testSubject.withDiagnostics(original -> original.and("new-key", (Object)"new-value"));
        Assertions.assertEquals((Object)testSubject.message(), (Object)result.message());
        Optional resultCause = result.cause();
        Assertions.assertFalse((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testSubject.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)testSubject.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)expectedDiagnostics, (Object)result.diagnostics());
    }
}

