/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.util.function.Consumer;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.interceptors.TransactionManagingInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TransactionManagingInterceptorTest {
    private Message<?> message;
    private InterceptorChain interceptorChain;
    private UnitOfWork<Message<?>> unitOfWork;
    private TransactionManager transactionManager;
    private Transaction transaction;
    private TransactionManagingInterceptor<Message<?>> subject;

    TransactionManagingInterceptorTest() {
    }

    @BeforeEach
    void setUp() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
        this.interceptorChain = (InterceptorChain)Mockito.mock(InterceptorChain.class);
        this.message = new GenericMessage(new Object());
        this.unitOfWork = DefaultUnitOfWork.startAndGet(this.message);
        this.transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        this.transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.transactionManager.startTransaction()).thenReturn((Object)this.transaction);
        this.subject = new TransactionManagingInterceptor(this.transactionManager);
    }

    @Test
    void startTransaction() throws Exception {
        UnitOfWork unitOfWork = (UnitOfWork)Mockito.spy(this.unitOfWork);
        this.subject.handle(unitOfWork, this.interceptorChain);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ((InterceptorChain)Mockito.verify((Object)this.interceptorChain)).proceed();
        ((UnitOfWork)Mockito.verify((Object)unitOfWork)).onCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify((Object)unitOfWork)).onRollback((Consumer)Mockito.any());
    }

    @Test
    void unitOfWorkCommit() throws Exception {
        this.subject.handle(this.unitOfWork, this.interceptorChain);
        this.unitOfWork.commit();
        ((Transaction)Mockito.verify((Object)this.transaction)).commit();
    }
}

