/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.util.ArrayList;
import org.axonframework.messaging.responsetypes.AbstractResponseTypeTest;
import org.axonframework.messaging.responsetypes.InstanceResponseType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InstanceResponseTypeTest
extends AbstractResponseTypeTest<AbstractResponseTypeTest.QueryResponse> {
    InstanceResponseTypeTest() {
        super(new InstanceResponseType(AbstractResponseTypeTest.QueryResponse.class));
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsTheSame() throws NoSuchMethodException {
        this.testMatchRanked("someQuery", MATCHES);
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsSubTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubTypedQuery", MATCHES);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSuperTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperTypedQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGeneric() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsBoundedGenericOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericQuery", MATCHES);
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsMultiBoundedGenericOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericQuery", MATCHES);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsArrayWithSubTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubTypedArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsArrayWithSuperTypeOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperTypedArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericArray() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsBoundedGenericArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiBoundedGenericArrayOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericArrayOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericArrayQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSubListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSubListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSuperListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSuperListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsBoundedGenericListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiBoundedGenericListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericListOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingBoundedGenericListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsLowerBoundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someLowerBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someUpperBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsWildcardListOfOtherType() throws NoSuchMethodException {
        this.testMatchRanked("someNonMatchingUpperBoundedWildcardQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedGenericUpperBoundedWildcardList() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedGenericUpperBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsGenericUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someGenericUpperBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiGenericUpperBoundedWildcardListOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiGenericUpperBoundedWildcardListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsUnboundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someUnboundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsBoundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someBoundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiUnboundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiUnboundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMultiBoundedListImplementationOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMultiBoundedListImplementationQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsSetOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someSetQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsStreamOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someStreamQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsMapOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someMapQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsFutureOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someFutureQuery", MATCHES);
    }

    @Test
    void matchesReturnsNoMatchIfResponseTypeIsListOfFutureOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someFutureListQuery", DOES_NOT_MATCH);
    }

    @Test
    void matchesReturnsMatchIfResponseTypeIsOptionalOfProvidedType() throws NoSuchMethodException {
        this.testMatchRanked("someOptionalQueryResponse", MATCHES);
    }

    @Test
    void convertReturnsSingleResponseAsIs() {
        AbstractResponseTypeTest.QueryResponse testResponse = new AbstractResponseTypeTest.QueryResponse();
        AbstractResponseTypeTest.QueryResponse result = (AbstractResponseTypeTest.QueryResponse)this.testSubject.convert((Object)testResponse);
        Assertions.assertEquals((Object)testResponse, (Object)result);
    }

    @Test
    void convertReturnsSingleResponseAsIsForSubTypedResponse() {
        AbstractResponseTypeTest.SubTypedQueryResponse testResponse = new AbstractResponseTypeTest.SubTypedQueryResponse();
        AbstractResponseTypeTest.QueryResponse result = (AbstractResponseTypeTest.QueryResponse)this.testSubject.convert((Object)testResponse);
        Assertions.assertEquals((Object)testResponse, (Object)result);
    }

    @Test
    void convertThrowsClassCastExceptionForDifferentSingleInstanceResponse() {
        Assertions.assertThrows(Exception.class, () -> {
            AbstractResponseTypeTest.QueryResponse convert = (AbstractResponseTypeTest.QueryResponse)this.testSubject.convert((Object)new AbstractResponseTypeTest.QueryResponseInterface(){});
        });
    }

    @Test
    void convertThrowsClassCastExceptionForMultipleInstanceResponse() {
        Assertions.assertThrows(Exception.class, () -> {
            AbstractResponseTypeTest.QueryResponse convert = (AbstractResponseTypeTest.QueryResponse)this.testSubject.convert(new ArrayList());
        });
    }
}

