/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.ThrowingCorrelationDataProvider;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractUnitOfWorkTest {
    private List<PhaseTransition> phaseTransitions;
    private UnitOfWork<?> subject;

    AbstractUnitOfWorkTest() {
    }

    @BeforeEach
    void setUp() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
        this.subject = (UnitOfWork)Mockito.spy((Object)new DefaultUnitOfWork((Message)new GenericEventMessage((Object)"Input 1")){

            public String toString() {
                return "unitOfWork";
            }
        });
        this.phaseTransitions = new ArrayList<PhaseTransition>();
        this.registerListeners(this.subject);
    }

    private void registerListeners(UnitOfWork<?> unitOfWork) {
        unitOfWork.onPrepareCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.PREPARE_COMMIT)));
        unitOfWork.onCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.COMMIT)));
        unitOfWork.afterCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.AFTER_COMMIT)));
        unitOfWork.onRollback(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.ROLLBACK)));
        unitOfWork.onCleanup(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.CLEANUP)));
    }

    @AfterEach
    void tearDown() {
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"A UnitOfWork was not properly cleared");
    }

    @Test
    void handlersForCurrentPhaseAreExecuted() {
        AtomicBoolean prepareCommit = new AtomicBoolean();
        AtomicBoolean commit = new AtomicBoolean();
        AtomicBoolean afterCommit = new AtomicBoolean();
        AtomicBoolean cleanup = new AtomicBoolean();
        this.subject.onPrepareCommit(u -> this.subject.onPrepareCommit(i -> prepareCommit.set(true)));
        this.subject.onCommit(u -> this.subject.onCommit(i -> commit.set(true)));
        this.subject.afterCommit(u -> this.subject.afterCommit(i -> afterCommit.set(true)));
        this.subject.onCleanup(u -> this.subject.onCleanup(i -> cleanup.set(true)));
        this.subject.start();
        this.subject.commit();
        Assertions.assertTrue((boolean)prepareCommit.get());
        Assertions.assertTrue((boolean)commit.get());
        Assertions.assertTrue((boolean)afterCommit.get());
        Assertions.assertTrue((boolean)cleanup.get());
    }

    @Test
    void executeTask() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doNothing().when((Object)task)).run();
        this.subject.execute(task);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{task, this.subject});
        ((UnitOfWork)inOrder.verify(this.subject)).start();
        ((Runnable)inOrder.verify((Object)task)).run();
        ((UnitOfWork)inOrder.verify(this.subject)).commit();
        Assertions.assertFalse((boolean)this.subject.isActive());
    }

    @Test
    void executeFailingTask() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        MockException mockException = new MockException();
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{mockException}).when((Object)task)).run();
        try {
            this.subject.execute(task);
        }
        catch (MockException e) {
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{task, this.subject});
            ((UnitOfWork)inOrder.verify(this.subject)).start();
            ((Runnable)inOrder.verify((Object)task)).run();
            ((UnitOfWork)inOrder.verify(this.subject)).rollback((Throwable)e);
            Assertions.assertNotNull((Object)this.subject.getExecutionResult());
            Assertions.assertSame((Object)mockException, (Object)this.subject.getExecutionResult().getExceptionResult());
            return;
        }
        throw new AssertionError();
    }

    @Test
    void executeTaskWithResult() throws Exception {
        Object taskResult = new Object();
        Callable task = (Callable)Mockito.mock(Callable.class);
        Mockito.when(task.call()).thenReturn(taskResult);
        ResultMessage result = this.subject.executeWithResult(task);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{task, this.subject});
        ((UnitOfWork)inOrder.verify(this.subject)).start();
        ((Callable)inOrder.verify((Object)task)).call();
        ((UnitOfWork)inOrder.verify(this.subject)).commit();
        Assertions.assertFalse((boolean)this.subject.isActive());
        Assertions.assertSame((Object)taskResult, (Object)result.getPayload());
        Assertions.assertNotNull((Object)this.subject.getExecutionResult());
        Assertions.assertSame((Object)taskResult, (Object)this.subject.getExecutionResult().getResult().getPayload());
    }

    @Test
    void executeTaskReturnsResultMessage() throws Exception {
        ResultMessage resultMessage = GenericResultMessage.asResultMessage((Object)new Object());
        Callable task = (Callable)Mockito.mock(Callable.class);
        Mockito.when(task.call()).thenReturn((Object)resultMessage);
        ResultMessage actualResultMessage = this.subject.executeWithResult(task);
        Assertions.assertSame((Object)resultMessage, (Object)actualResultMessage);
    }

    @Test
    void attachedTransactionCommittedOnUnitOfWorkCommit() {
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transactionManager.startTransaction()).thenReturn((Object)transaction);
        this.subject.attachTransaction(transactionManager);
        this.subject.start();
        ((TransactionManager)Mockito.verify((Object)transactionManager)).startTransaction();
        ((Transaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).commit();
        this.subject.commit();
        ((Transaction)Mockito.verify((Object)transaction)).commit();
    }

    @Test
    void attachedTransactionRolledBackOnUnitOfWorkRollBack() {
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transactionManager.startTransaction()).thenReturn((Object)transaction);
        this.subject.attachTransaction(transactionManager);
        this.subject.start();
        ((TransactionManager)Mockito.verify((Object)transactionManager)).startTransaction();
        ((Transaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).commit();
        ((Transaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).rollback();
        this.subject.rollback();
        ((Transaction)Mockito.verify((Object)transaction)).rollback();
        ((Transaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).commit();
    }

    @Test
    void unitOfWorkIsRolledBackWhenTransactionFailsToStart() {
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Mockito.when((Object)transactionManager.startTransaction()).thenThrow(new Throwable[]{new MockException()});
        try {
            this.subject.attachTransaction(transactionManager);
            Assertions.fail((String)"Expected MockException to be propagated");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((UnitOfWork)Mockito.verify(this.subject)).rollback((Throwable)Mockito.isA(MockException.class));
    }

    @Test
    void whenGettingCorrelationMetaThrows_thenCatchExceptions() {
        this.subject.registerCorrelationDataProvider((CorrelationDataProvider)new ThrowingCorrelationDataProvider());
        MetaData correlationData = this.subject.getCorrelationData();
        Assertions.assertNotNull((Object)correlationData);
    }

    private static class PhaseTransition {
        private final UnitOfWork.Phase phase;
        private final UnitOfWork<?> unitOfWork;

        public PhaseTransition(UnitOfWork<?> unitOfWork, UnitOfWork.Phase phase) {
            this.unitOfWork = unitOfWork;
            this.phase = phase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhaseTransition that = (PhaseTransition)o;
            return Objects.equals(this.phase, that.phase) && Objects.equals(this.unitOfWork, that.unitOfWork);
        }

        public int hashCode() {
            return Objects.hash(this.phase, this.unitOfWork);
        }

        public String toString() {
            return this.unitOfWork + " " + this.phase;
        }
    }
}

