/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.util.stream.Stream;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.SingleEventUpcaster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EventUpcasterChainTest {
    EventUpcasterChainTest() {
    }

    @Test
    void createChainAndUpcast() {
        EventUpcasterChain eventUpcasterChain = new EventUpcasterChain(new EventUpcaster[]{new SomeEventUpcaster(), new SomeOtherEventUpcaster()});
        IntermediateEventRepresentation mockRepresentation = (IntermediateEventRepresentation)Mockito.mock(IntermediateEventRepresentation.class);
        Assertions.assertSame((Object)mockRepresentation, eventUpcasterChain.upcast(Stream.of(mockRepresentation)).findFirst().get());
    }

    private static class SomeOtherEventUpcaster
    extends SingleEventUpcaster {
        private SomeOtherEventUpcaster() {
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return true;
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return intermediateRepresentation;
        }
    }

    private static class SomeEventUpcaster
    extends SingleEventUpcaster {
        private SomeEventUpcaster() {
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return true;
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return intermediateRepresentation;
        }
    }
}

