/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.NestingSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class NestingSpanFactoryTest {
    private final Clock clock = (Clock)Mockito.spy(Clock.class);
    private final SpanFactory delegate = (SpanFactory)Mockito.mock(SpanFactory.class);
    private final Span mockSpan = (Span)Mockito.mock(Span.class);
    private final NestingSpanFactory spanFactory = NestingSpanFactory.builder().clock(this.clock).delegate(this.delegate).build();
    private final Supplier<String> nameSupplier = () -> "spanName";
    private final EventMessage<Object> message = GenericEventMessage.asEventMessage((Object)"payload");

    NestingSpanFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.clock.instant()).thenReturn((Object)Instant.now());
    }

    @Test
    void createsNestedSpanIfRecentMessage() {
        this.spanFactory.createLinkedHandlerSpan(this.nameSupplier, this.message, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createHandlerSpan(this.nameSupplier, this.message, true, new Message[0]);
    }

    @Test
    void createsLinkedSpanIfOldMessage() {
        EventMessage payload = GenericEventMessage.asEventMessage((Object)"payload");
        Mockito.when((Object)this.clock.instant()).thenReturn((Object)Instant.now().plusSeconds(121L));
        Supplier<String> nameSupplier = () -> "spanName";
        this.spanFactory.createLinkedHandlerSpan(nameSupplier, (Message)payload, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createHandlerSpan(nameSupplier, (Message)payload, false, new Message[0]);
    }

    @Test
    void rootTracesCreatedWillDelegate() {
        Mockito.when((Object)this.delegate.createRootTrace((Supplier)Mockito.any())).thenReturn((Object)this.mockSpan);
        this.spanFactory.createRootTrace(this.nameSupplier);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createRootTrace(this.nameSupplier);
    }

    @Test
    void dispatchSpansCreatedWillDelegate() {
        this.spanFactory.createDispatchSpan(this.nameSupplier, this.message, new Message[0]);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createDispatchSpan(this.nameSupplier, this.message, new Message[0]);
    }

    @Test
    void internalSpansCreatedWillDelegate() {
        this.spanFactory.createInternalSpan(this.nameSupplier);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createInternalSpan(this.nameSupplier);
    }

    @Test
    void internalSpansWithMessageCreatedWillDelegate() {
        this.spanFactory.createInternalSpan(this.nameSupplier, this.message);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).createInternalSpan(this.nameSupplier, this.message);
    }

    @Test
    void registerSpanAttributeProviderWillDelegate() {
        SpanAttributesProvider provider = (SpanAttributesProvider)Mockito.mock(SpanAttributesProvider.class);
        this.spanFactory.registerSpanAttributeProvider(provider);
        ((SpanFactory)Mockito.verify((Object)this.delegate)).registerSpanAttributeProvider(provider);
    }

    @Test
    void propagateContextDelegate() {
        Message original = (Message)Mockito.mock(Message.class);
        Message modified = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)this.delegate.propagateContext(original)).thenReturn((Object)modified);
        Message result = this.spanFactory.propagateContext(original);
        Assertions.assertSame((Object)result, (Object)modified);
    }

    @Test
    void builderThrowsExceptionWhenNoDelegateIsDefined() {
        NestingSpanFactory.Builder builder = NestingSpanFactory.builder().clock(this.clock).timeLimit(Duration.ZERO);
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.build());
    }

    @Test
    void builderThrowsExceptionWhenNullDelegateIsSet() {
        NestingSpanFactory.Builder builder = NestingSpanFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.delegate(null));
    }

    @Test
    void builderThrowsExceptionWhenNullTimeLimitIsSet() {
        NestingSpanFactory.Builder builder = NestingSpanFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.timeLimit(null));
    }

    @Test
    void builderThrowsExceptionWhenNullClockIsSet() {
        NestingSpanFactory.Builder builder = NestingSpanFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builder.clock(null));
    }
}

