/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpanFactory
implements SpanFactory {
    private final Logger logger = LoggerFactory.getLogger(TestSpanFactory.class);
    private final Deque<TestSpan> activeSpan = new ArrayDeque<TestSpan>();
    private final List<TestSpan> createdSpans = new CopyOnWriteArrayList<TestSpan>();
    private final Map<Message<?>, TestSpan> propagatedContexts = new HashMap();

    public void reset() {
        this.activeSpan.clear();
        this.createdSpans.clear();
        this.propagatedContexts.clear();
        this.logger.debug("SpanFactory cleared");
    }

    public void verifyNotStarted(String name) {
        Assertions.assertFalse((boolean)this.findSpan(name, span -> ((TestSpan)span).started).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    public void verifySpanActive(String name) {
        Assertions.assertTrue((boolean)this.findSpan(name, span -> ((TestSpan)span).started && !((TestSpan)span).ended).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    public void verifySpanActive(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.findSpan(name, message, span -> ((TestSpan)span).started && !((TestSpan)span).ended).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    public void verifySpanCompleted(String name) {
        Assertions.assertTrue((boolean)this.findSpan(name, span -> ((TestSpan)span).started && ((TestSpan)span).ended).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    public void verifySpanCompleted(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.findSpan(name, message, span -> ((TestSpan)span).started && ((TestSpan)span).ended).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    public void verifySpanHasException(String name, Class<?> exceptionClass) {
        Assertions.assertInstanceOf(exceptionClass, this.findSpan(name).map(s -> ((TestSpan)s).exception).orElse(null));
    }

    public void verifyNoSpan(String name) {
        Assertions.assertFalse((boolean)this.findSpan(name).isPresent());
    }

    public void verifySpanPropagated(String name, Message<?> message) {
        Assertions.assertTrue((boolean)this.createdSpans.stream().anyMatch(s -> ((TestSpan)s).name.equals(name) && this.propagatedContexts.containsKey(message) && this.propagatedContexts.get(message) == s), (String)this.createErrorMessageForSpan(name));
    }

    public void verifySpanHasType(String name, TestSpanType type) {
        Assertions.assertEquals((Object)((Object)type), this.findSpan(name).map(s -> ((TestSpan)s).type).orElse(null));
    }

    private void verifySpanExists(String name) {
        Assertions.assertTrue((boolean)this.findSpan(name).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    private Optional<TestSpan> findSpan(String name) {
        return this.findSpan(name, testSpan -> true);
    }

    private void verifySpanExists(String name, Predicate<TestSpan> filter) {
        Assertions.assertTrue((boolean)this.findSpan(name, filter).isPresent(), () -> this.createErrorMessageForSpan(name));
    }

    private Optional<TestSpan> findSpan(String name, Predicate<TestSpan> filter) {
        return this.createdSpans.stream().filter(s -> ((TestSpan)s).name.equals(name)).filter(filter).findFirst();
    }

    private String createErrorMessageForSpan(String name) {
        return String.format("No span matching name %s, but got the following recorded spans: %s", name, this.createdSpans.stream().map(TestSpan::toString).collect(Collectors.joining("\n")));
    }

    private Optional<TestSpan> findSpan(String name, Message<?> message, Predicate<TestSpan> filter) {
        return this.findSpan(name, filter.and(s -> ((TestSpan)s).message != null && ((TestSpan)s).message.equals(message)));
    }

    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        TestSpan span = new TestSpan(TestSpanType.ROOT, operationNameSupplier.get(), null);
        this.createdSpans.add(span);
        return span;
    }

    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        TestSpan span = new TestSpan(isChildTrace ? TestSpanType.HANDLER_CHILD : TestSpanType.HANDLER_LINK, operationNameSupplier.get(), parentMessage);
        this.createdSpans.add(span);
        return span;
    }

    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        TestSpan span = new TestSpan(TestSpanType.DISPATCH, operationNameSupplier.get(), parentMessage);
        this.createdSpans.add(span);
        return span;
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        TestSpan span = new TestSpan(TestSpanType.INTERNAL, operationNameSupplier.get(), null);
        this.createdSpans.add(span);
        return span;
    }

    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        TestSpan span = new TestSpan(TestSpanType.INTERNAL, operationNameSupplier.get(), message);
        this.createdSpans.add(span);
        return span;
    }

    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Message<?>> M propagateContext(M message) {
        Deque<TestSpan> deque = this.activeSpan;
        synchronized (deque) {
            if (this.activeSpan.isEmpty()) {
                return message;
            }
            this.propagatedContexts.put(message, this.activeSpan.getFirst());
        }
        return message;
    }

    public class TestSpan
    implements Span {
        private final List<SpanScope> scopes = new CopyOnWriteArrayList<SpanScope>();
        private final TestSpanType type;
        private final String name;
        private final Message<?> message;
        private boolean started;
        private boolean ended;
        private Throwable exception;
        private AtomicInteger scopeCount = new AtomicInteger(-1);

        public TestSpan(TestSpanType type, String name, Message<?> message) {
            this.type = type;
            this.name = name;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Span start() {
            this.started = true;
            Deque deque = TestSpanFactory.this.activeSpan;
            synchronized (deque) {
                TestSpanFactory.this.activeSpan.addFirst(this);
            }
            TestSpanFactory.this.logger.debug("+ {}", (Object)this.name);
            return this;
        }

        public SpanScope makeCurrent() {
            return new TestSpanScope(this.scopeCount.incrementAndGet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            this.ended = true;
            if (this.scopes.size() > 0) {
                throw new IllegalStateException("All scopes should be closed! Still have " + this.scopes.size() + " open!");
            }
            Deque deque = TestSpanFactory.this.activeSpan;
            synchronized (deque) {
                TestSpanFactory.this.activeSpan.remove(this);
            }
            TestSpanFactory.this.logger.debug("- {}", (Object)this.name);
        }

        public Span recordException(Throwable t) {
            TestSpanFactory.this.logger.debug("Recorded exception for span with name {}", (Object)this.name, (Object)t);
            this.exception = t;
            return this;
        }

        public String toString() {
            return "TestSpan{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", message=" + this.message + ", started=" + this.started + ", ended=" + this.ended + ", exception=" + this.exception + '}';
        }

        private class TestSpanScope
        implements SpanScope {
            private final int scopeNum;

            private TestSpanScope(int scopeNum) {
                this.scopeNum = scopeNum;
                TestSpanFactory.this.logger.debug("++ {}:{}", (Object)TestSpan.this.name, (Object)scopeNum);
            }

            public void close() {
                TestSpanFactory.this.logger.debug("-- {}:{}", (Object)TestSpan.this.name, (Object)this.scopeNum);
                TestSpan.this.scopes.remove(this);
            }
        }
    }

    public static enum TestSpanType {
        ROOT,
        HANDLER_CHILD,
        HANDLER_LINK,
        DISPATCH,
        INTERNAL;

    }
}

