/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.transaction;

import java.util.function.Supplier;
import org.axonframework.common.transaction.Transaction;

public interface TransactionManager {
    public Transaction startTransaction();

    default public void executeInTransaction(Runnable task) {
        Transaction transaction = this.startTransaction();
        try {
            task.run();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }

    default public <T> T fetchInTransaction(Supplier<T> supplier) {
        Transaction transaction = this.startTransaction();
        try {
            T result = supplier.get();
            transaction.commit();
            return result;
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }
}

