/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.axonframework.commandhandling.AsynchronousCommandBus;
import org.axonframework.commandhandling.CommandBusSpanFactory;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.DefaultCommandBusSpanFactory;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AsynchronousCommandBusTest {
    private MessageHandlerInterceptor<CommandMessage<?>> handlerInterceptor;
    private MessageDispatchInterceptor<CommandMessage<?>> dispatchInterceptor;
    private MessageHandler<CommandMessage<?>> commandHandler;
    private ExecutorService executorService;
    private AsynchronousCommandBus testSubject;
    private TestSpanFactory spanFactory;
    private CommandBusSpanFactory commandBusSpanFactory;

    AsynchronousCommandBusTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.commandHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        this.executorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        this.dispatchInterceptor = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        this.handlerInterceptor = (MessageHandlerInterceptor)Mockito.mock(MessageHandlerInterceptor.class);
        this.spanFactory = new TestSpanFactory();
        this.commandBusSpanFactory = DefaultCommandBusSpanFactory.builder().spanFactory((SpanFactory)this.spanFactory).build();
        ((ExecutorService)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArguments()[0]).run();
            return null;
        }).when((Object)this.executorService)).execute((Runnable)Mockito.isA(Runnable.class));
        this.testSubject = AsynchronousCommandBus.builder().executor((Executor)this.executorService).spanFactory(this.commandBusSpanFactory).build();
        this.testSubject.registerDispatchInterceptor(this.dispatchInterceptor);
        this.testSubject.registerHandlerInterceptor(this.handlerInterceptor);
        Mockito.when((Object)this.dispatchInterceptor.handle((Message)Mockito.isA(CommandMessage.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        Mockito.when((Object)this.handlerInterceptor.handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class))).thenAnswer(invocation -> ((InterceptorChain)invocation.getArguments()[1]).proceed());
    }

    @Test
    void dispatchWithCallback() throws Exception {
        this.testSubject.subscribe(Object.class.getName(), this.commandHandler);
        CommandCallback mockCallback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)mockCallback.wrap((CommandCallback)Mockito.any())).thenCallRealMethod();
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)new Object());
        this.testSubject.dispatch(command, mockCallback);
        this.spanFactory.verifySpanCompleted("CommandBus.dispatchCommand");
        this.spanFactory.verifySpanPropagated("CommandBus.dispatchCommand", (Message<?>)command);
        this.spanFactory.verifySpanCompleted("CommandBus.handleCommand");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockCallback, this.executorService, this.commandHandler, this.dispatchInterceptor, this.handlerInterceptor});
        ((MessageDispatchInterceptor)inOrder.verify(this.dispatchInterceptor)).handle((Message)Mockito.isA(CommandMessage.class));
        ((ExecutorService)inOrder.verify((Object)this.executorService)).execute((Runnable)Mockito.isA(Runnable.class));
        ((MessageHandlerInterceptor)inOrder.verify(this.handlerInterceptor)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandler)inOrder.verify(this.commandHandler)).handle((Message)Mockito.isA(CommandMessage.class));
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(CommandMessage.class);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)inOrder.verify((Object)mockCallback)).onResult((CommandMessage)commandCaptor.capture(), (CommandResultMessage)responseCaptor.capture());
        Assertions.assertEquals((Object)command, (Object)commandCaptor.getValue());
        Assertions.assertNull((Object)((CommandResultMessage)responseCaptor.getValue()).getPayload());
    }

    @Test
    void dispatchWithoutCallback() throws Exception {
        MessageHandler commandHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        this.testSubject.subscribe(Object.class.getName(), commandHandler);
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)new Object());
        this.testSubject.dispatch(command, (CommandCallback)NoOpCallback.INSTANCE);
        this.spanFactory.verifySpanCompleted("CommandBus.dispatchCommand");
        this.spanFactory.verifySpanPropagated("CommandBus.dispatchCommand", (Message<?>)command);
        this.spanFactory.verifySpanCompleted("CommandBus.handleCommand");
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.executorService, commandHandler, this.dispatchInterceptor, this.handlerInterceptor});
        ((MessageDispatchInterceptor)inOrder.verify(this.dispatchInterceptor)).handle((Message)Mockito.isA(CommandMessage.class));
        ((ExecutorService)inOrder.verify((Object)this.executorService)).execute((Runnable)Mockito.isA(Runnable.class));
        ((MessageHandlerInterceptor)inOrder.verify(this.handlerInterceptor)).handle((UnitOfWork)Mockito.isA(UnitOfWork.class), (InterceptorChain)Mockito.isA(InterceptorChain.class));
        ((MessageHandler)inOrder.verify((Object)commandHandler)).handle((Message)Mockito.isA(CommandMessage.class));
    }

    @Test
    void shutdown_ExecutorServiceUsed() {
        this.testSubject.shutdown();
        ((ExecutorService)Mockito.verify((Object)this.executorService)).shutdown();
    }

    @Test
    void exceptionIsThrownWhenNoHandlerIsRegistered() {
        CommandCallback callback = (CommandCallback)Mockito.mock(CommandCallback.class);
        Mockito.when((Object)callback.wrap((CommandCallback)Mockito.any())).thenCallRealMethod();
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"test");
        this.testSubject.dispatch(command, callback);
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)callback)).onResult((CommandMessage)Mockito.eq((Object)command), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(NoHandlerForCommandException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
        this.spanFactory.verifySpanHasException("CommandBus.dispatchCommand", NoHandlerForCommandException.class);
    }

    @Test
    void shutdown_ExecutorUsed() {
        Executor executor = (Executor)Mockito.mock(Executor.class);
        AsynchronousCommandBus.builder().executor(executor).build().shutdown();
        ((Executor)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.any(Runnable.class));
    }
}

