/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.axonframework.commandhandling.RoutingKey;
import org.axonframework.common.annotation.AnnotationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AnnotationUtilsTest {
    AnnotationUtilsTest() {
    }

    @Test
    void findAttributesOnDirectAnnotation() throws NoSuchMethodException {
        Optional optionalResult = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.getClass().getDeclaredMethod("directAnnotated", new Class[0]), TheTarget.class);
        Assertions.assertTrue((boolean)optionalResult.isPresent());
        Map results = (Map)optionalResult.get();
        Assertions.assertEquals((Object)"value", results.get("property"));
        Assertions.assertFalse((boolean)results.containsKey("value"), (String)"value property should use annotation Simple class name as key");
        Assertions.assertEquals((Object)"value()", results.get("theTarget"));
    }

    @Test
    void findAttributesOnStaticMetaAnnotation() throws NoSuchMethodException {
        Optional optionalResult = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.getClass().getDeclaredMethod("staticallyOverridden", new Class[0]), TheTarget.class);
        Assertions.assertTrue((boolean)optionalResult.isPresent());
        Map results = (Map)optionalResult.get();
        Assertions.assertEquals((Object)"overridden_statically", results.get("property"));
    }

    @Test
    void findAttributesOnDynamicMetaAnnotation() throws NoSuchMethodException {
        Optional optionalResult = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.getClass().getDeclaredMethod("dynamicallyOverridden", new Class[0]), TheTarget.class);
        Assertions.assertTrue((boolean)optionalResult.isPresent());
        Map results = (Map)optionalResult.get();
        Assertions.assertEquals((Object)"dynamic-override", results.get("property"));
        Assertions.assertEquals((Object)"extra", results.get("extraValue"));
    }

    @Test
    void findAttributesOnDynamicMetaAnnotationUsingAnnotationName() throws NoSuchMethodException {
        Optional optionalResult = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.getClass().getDeclaredMethod("dynamicallyOverridden", new Class[0]), (String)TheTarget.class.getName());
        Assertions.assertTrue((boolean)optionalResult.isPresent());
        Map results = (Map)optionalResult.get();
        Assertions.assertEquals((Object)"dynamic-override", results.get("property"));
        Assertions.assertEquals((Object)"extra", results.get("extraValue"));
        Assertions.assertEquals((Object)"otherValue", results.get("theTarget"));
    }

    @Test
    void findAttributesOnNonExistentAnnotation() throws NoSuchMethodException {
        Optional result = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.getClass().getDeclaredMethod("dynamicallyOverridden", new Class[0]), RoutingKey.class);
        Assertions.assertFalse((boolean)result.isPresent(), (String)"Didn't expect attributes to be found for non-existent annotation");
    }

    @Test
    void findAnnotationAttributesOnlyReturnsTargetAttributesAndOverridesForClassAnnotation() throws NoSuchMethodException {
        Method annotatedElement = this.getClass().getDeclaredMethod("dynamicallyOverridden", new Class[0]);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("property", "dynamic-override");
        expected.put("theTarget", "otherValue");
        Optional result = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)annotatedElement, TheTarget.class, (boolean)true);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals(expected, result.get());
    }

    @Test
    void findAnnotationAttributesOnlyReturnsTargetAttributesAndOverridesForStringAnnotation() throws NoSuchMethodException {
        Method annotatedElement = this.getClass().getDeclaredMethod("someAnnotatedMethod", new Class[0]);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("property", "some-property");
        expected.put("theTarget", "otherValue");
        Optional result = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)annotatedElement, (String)TheTarget.class.getName(), (boolean)true);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals(expected, result.get());
    }

    @Test
    void isAnnotatedWithReturnsTrue() {
        HashSet<Class> expectedAnnotatedWithSubject = new HashSet<Class>();
        expectedAnnotatedWithSubject.add(DynamicOverrideAnnotated.class);
        expectedAnnotatedWithSubject.add(AnotherMetaAnnotation.class);
        HashSet<Class> expectedVisited = new HashSet<Class>();
        expectedVisited.add(DynamicOverrideAnnotated.class);
        expectedVisited.add(AnotherMetaAnnotation.class);
        expectedVisited.add(TheTarget.class);
        expectedVisited.add(Retention.class);
        expectedVisited.add(Target.class);
        expectedVisited.add(Documented.class);
        HashSet resultAnnotatedWithSubject = new HashSet();
        HashSet resultVisited = new HashSet();
        boolean result = AnnotationUtils.isAnnotatedWith(AnotherMetaAnnotation.class, TheTarget.class, resultAnnotatedWithSubject, resultVisited);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals(expectedAnnotatedWithSubject, resultAnnotatedWithSubject);
        Assertions.assertEquals(expectedVisited, resultVisited);
    }

    @Test
    void isAnnotatedWithReturnsFalse() {
        Set expectedAnnotatedWithSubject = Collections.emptySet();
        HashSet<Class> expectedVisited = new HashSet<Class>();
        expectedVisited.add(NotMetaAnnotated.class);
        expectedVisited.add(Documented.class);
        expectedVisited.add(Retention.class);
        expectedVisited.add(Target.class);
        HashSet resultAnnotatedWithSubject = new HashSet();
        HashSet resultVisited = new HashSet();
        boolean result = AnnotationUtils.isAnnotatedWith(NotMetaAnnotated.class, TheTarget.class, resultAnnotatedWithSubject, resultVisited);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals(expectedAnnotatedWithSubject, resultAnnotatedWithSubject);
        Assertions.assertEquals(expectedVisited, resultVisited);
    }

    @TheTarget
    public void directAnnotated() {
    }

    @StaticOverrideAnnotated
    public void staticallyOverridden() {
    }

    @DynamicOverrideAnnotated(property="dynamic-override")
    public void dynamicallyOverridden() {
    }

    @AnotherMetaAnnotation
    public void someAnnotatedMethod() {
    }

    @Documented
    public static @interface NotMetaAnnotated {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @DynamicOverrideAnnotated(property="some-property")
    public static @interface AnotherMetaAnnotation {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    @TheTarget
    public static @interface DynamicOverrideAnnotated {
        public String property();

        public String extraValue() default "extra";

        public String theTarget() default "otherValue";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    @TheTarget(property="overridden_statically")
    public static @interface StaticOverrideAnnotated {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
    public static @interface TheTarget {
        public String property() default "value";

        public String value() default "value()";
    }
}

