/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockAcquisitionFailedException;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PessimisticLockFactoryTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String identifier = "mockId";
    private PessimisticLockFactory testSubject;

    PessimisticLockFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = PessimisticLockFactory.builder().build();
    }

    @Test
    void lockReferenceCleanedUpAtUnlock() throws NoSuchFieldException, IllegalAccessException {
        Lock lock = this.testSubject.obtainLock(this.identifier);
        lock.release();
        Field locksField = this.testSubject.getClass().getDeclaredField("locks");
        locksField.setAccessible(true);
        Map locks = (Map)locksField.get(this.testSubject);
        Assertions.assertEquals((int)0, (int)locks.size(), (String)"Expected lock to be cleaned up");
    }

    @Test
    void lockOnlyCleanedUpIfNoLocksAreHeld() throws NoSuchFieldException, IllegalAccessException {
        Lock lockOne = this.testSubject.obtainLock(this.identifier);
        Lock lockTwo = this.testSubject.obtainLock(this.identifier);
        lockOne.release();
        Field locksField = this.testSubject.getClass().getDeclaredField("locks");
        locksField.setAccessible(true);
        Map locks = (Map)locksField.get(this.testSubject);
        Assertions.assertEquals((int)1, (int)locks.size(), (String)"Expected lock not to be cleaned up");
        lockTwo.release();
        locks = (Map)locksField.get(this.testSubject);
        Assertions.assertTrue((boolean)locks.isEmpty(), (String)"Expected locks to be cleaned up");
    }

    @Test
    @Timeout(value=10L)
    void deadlockDetectedWithTwoThreadsInVector() throws InterruptedException {
        CountDownLatch starter = new CountDownLatch(1);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        String idOne = "id1-TwoThreadsVector";
        String idTwo = "id2-TwoThreadsVector";
        Thread lockingThread = this.createLockingThread("TwoThreadsVector", starter, cdl, deadlockInThread, this.testSubject, idOne, this.testSubject, idTwo);
        lockingThread.start();
        Lock lockTwo = this.testSubject.obtainLock(idTwo);
        starter.await();
        cdl.countDown();
        try {
            Lock lockOne = this.testSubject.obtainLock(idOne);
            Assertions.assertTrue((boolean)deadlockInThread.get());
            lockOne.release();
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
        lockTwo.release();
    }

    @Test
    @Timeout(value=12L)
    void deadlockDetectedWithTwoDifferentLockInstances() throws InterruptedException {
        PessimisticLockFactory otherTestSubject = PessimisticLockFactory.builder().build();
        CountDownLatch starter = new CountDownLatch(1);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        String idOne = "id1-TwoDifferentLockInstances";
        Thread lockingThread = this.createLockingThread("TwoDifferentLockInstances", starter, cdl, deadlockInThread, this.testSubject, idOne, otherTestSubject, idOne);
        lockingThread.start();
        Lock otherLock = otherTestSubject.obtainLock(idOne);
        starter.await();
        cdl.countDown();
        try {
            Lock thisLock = this.testSubject.obtainLock(idOne);
            Assertions.assertTrue((boolean)deadlockInThread.get());
            thisLock.release();
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
        otherLock.release();
    }

    @Test
    @Timeout(value=10L)
    void deadlockDetectedWithThreeThreadsInVector() throws InterruptedException {
        CountDownLatch starter = new CountDownLatch(3);
        CountDownLatch cdl = new CountDownLatch(1);
        AtomicBoolean deadlockInThread = new AtomicBoolean(false);
        String idOne = "id1-ThreeThreadsInVector";
        String idTwo = "id2-ThreeThreadsInVector";
        String idThree = "id3-ThreeThreadsInVector";
        String idFour = "id4-ThreeThreadsInVector";
        Thread firstLockingThread = this.createLockingThread("ThreeThreadsInVector", starter, cdl, deadlockInThread, this.testSubject, idOne, this.testSubject, idTwo);
        Thread secondLockingThread = this.createLockingThread("ThreeThreadsInVector", starter, cdl, deadlockInThread, this.testSubject, idTwo, this.testSubject, idThree);
        Thread thirdLockingThread = this.createLockingThread("ThreeThreadsInVector", starter, cdl, deadlockInThread, this.testSubject, idThree, this.testSubject, idFour);
        firstLockingThread.start();
        secondLockingThread.start();
        thirdLockingThread.start();
        Lock lockFour = this.testSubject.obtainLock(idFour);
        starter.await();
        cdl.countDown();
        try {
            Lock lockOne = this.testSubject.obtainLock(idOne);
            Assertions.assertTrue((boolean)deadlockInThread.get());
            lockOne.release();
        }
        catch (DeadlockException deadlockException) {
            // empty catch block
        }
        lockFour.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L)
    void reachingConfigureAcquireAttemptsCausesLockAcquisitionFailedException() {
        PessimisticLockFactory lockFactory = PessimisticLockFactory.builder().acquireAttempts(10).queueLengthThreshold(Integer.MAX_VALUE).lockAttemptTimeout(0).build();
        CountDownLatch rendezvous = new CountDownLatch(1);
        try {
            AtomicReference<Exception> exceptionInThread = new AtomicReference<Exception>();
            String id = "aggregateId";
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.WAITING, rendezvous, exceptionInThread, "aggregateId");
            Assertions.assertThrows(LockAcquisitionFailedException.class, () -> {
                Lock lock = lockFactory.obtainLock("aggregateId");
                lock.release();
            });
        }
        finally {
            rendezvous.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5L)
    void reachingConfiguredQueueBackoffCausesLockAcquisitionFailedException() {
        PessimisticLockFactory lockFactory = PessimisticLockFactory.builder().acquireAttempts(Integer.MAX_VALUE).queueLengthThreshold(2).lockAttemptTimeout(10000).build();
        CountDownLatch rendezvous = new CountDownLatch(1);
        try {
            AtomicReference<Exception> exceptionInThread = new AtomicReference<Exception>();
            String id = "aggregateId";
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.WAITING, rendezvous, exceptionInThread, "aggregateId");
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.TIMED_WAITING, rendezvous, exceptionInThread, "aggregateId");
            this.createThreadObtainLockAndWaitForState(lockFactory, Thread.State.TIMED_WAITING, rendezvous, exceptionInThread, "aggregateId");
            Assertions.assertThrows(LockAcquisitionFailedException.class, () -> {
                Lock lock = lockFactory.obtainLock("aggregateId");
                lock.release();
            });
        }
        finally {
            rendezvous.countDown();
        }
    }

    private Thread createLockingThread(String threadName, CountDownLatch starter, CountDownLatch cdl, AtomicBoolean deadlockInThread, PessimisticLockFactory factoryOne, String idOne, PessimisticLockFactory factoryTwo, String idTwo) {
        return new Thread(() -> {
            Lock lock1 = factoryOne.obtainLock(idOne);
            starter.countDown();
            try {
                cdl.await();
                Lock lock2 = factoryTwo.obtainLock(idTwo);
                lock2.release();
            }
            catch (InterruptedException e) {
                logger.info("Thread 1 interrupted", (Throwable)e);
            }
            catch (DeadlockException e) {
                deadlockInThread.set(true);
            }
            finally {
                lock1.release();
            }
        }, threadName);
    }

    private void createThreadObtainLockAndWaitForState(PessimisticLockFactory lockFactory, Thread.State state, CountDownLatch rendezvous, AtomicReference<Exception> exceptionInThread, String id) {
        Thread thread = new Thread(() -> {
            try (Lock ignored = lockFactory.obtainLock(id);){
                rendezvous.await();
            }
            catch (Exception e) {
                exceptionInThread.set(e);
            }
        }, "");
        thread.start();
        while (thread.isAlive() && rendezvous.getCount() > 0L && thread.getState() != state) {
            Thread.yield();
        }
    }

    @Test
    void backoffParametersConstructorAcquireAttempts() {
        PessimisticLockFactory.Builder builderTestSubject = PessimisticLockFactory.builder();
        int illegalValue = 0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderTestSubject.acquireAttempts(illegalValue));
    }

    @Test
    void backoffParametersConstructorMaximumQueued() {
        PessimisticLockFactory.Builder builderTestSubject = PessimisticLockFactory.builder();
        int illegalValue = 0;
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderTestSubject.queueLengthThreshold(illegalValue));
    }

    @Test
    void backoffParametersConstructorSpinTime() {
        PessimisticLockFactory.Builder builderTestSubject = PessimisticLockFactory.builder();
        int illegalValue = -1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> builderTestSubject.lockAttemptTimeout(illegalValue));
    }

    @Test
    void shouldThrowIllegalArgumentExceptionWhenIdentifierIsNull() {
        this.identifier = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.obtainLock(this.identifier));
    }
}

