/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.eventhandling.DefaultEventBusSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultEventBusSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultEventBusSpanFactory.Builder, DefaultEventBusSpanFactory> {
    DefaultEventBusSpanFactoryTest() {
    }

    @Test
    void createCommitEventsSpan() {
        this.test(DefaultEventBusSpanFactory::createCommitEventsSpan, this.expectedSpan("EventBus.commitEvents", TestSpanFactory.TestSpanType.INTERNAL));
    }

    @Test
    void createsQuerySpanNonDistributed() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.test(factory -> factory.createPublishEventSpan(eventMessage), this.expectedSpan("EventBus.publishEvent", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)eventMessage));
    }

    @Test
    void propagateContext() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.testContextPropagation(eventMessage, DefaultEventBusSpanFactory::propagateContext);
    }

    @Override
    protected DefaultEventBusSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultEventBusSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DefaultEventBusSpanFactory createFactoryBasedOnBuilder(DefaultEventBusSpanFactory.Builder builder) {
        return builder.build();
    }
}

