/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import org.axonframework.eventhandling.DefaultEventProcessorSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultEventProcessorSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultEventProcessorSpanFactory.Builder, DefaultEventProcessorSpanFactory> {
    DefaultEventProcessorSpanFactoryTest() {
    }

    @Test
    void createBatchSpanWithDefaultsForNonStreaming() {
        this.test(factory -> factory.createBatchSpan(false, Collections.emptyList()), this.noOpSpan());
    }

    @Test
    void createBatchSpanWithDefaultsForStreaming() {
        this.test(factory -> factory.createBatchSpan(true, Collections.emptyList()), this.expectedSpan("StreamingEventProcessor.batch", TestSpanFactory.TestSpanType.ROOT));
    }

    @Test
    void createBatchSpanWithDisabledBatchSpanForNonStreaming() {
        this.test(builder -> builder.disableBatchTrace(true), factory -> factory.createBatchSpan(false, Collections.emptyList()), this.noOpSpan());
    }

    @Test
    void createBatchSpanWithDisabledBatchSpanForStreaming() {
        this.test(builder -> builder.disableBatchTrace(true), factory -> factory.createBatchSpan(true, Collections.emptyList()), this.noOpSpan());
    }

    @Test
    void createHandleEventSpanWithDefaultsForNonStreaming() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.test(factory -> factory.createProcessEventSpan(false, eventMessage), this.expectedSpan("EventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)eventMessage));
    }

    @Test
    void createHandleEventSpanWithDefaultsForStreaming() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.test(factory -> factory.createProcessEventSpan(true, eventMessage), this.expectedSpan("StreamingEventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)eventMessage));
    }

    @Test
    void createHandleEventSpanWithDisabledBatchSpanForNonStreaming() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.test(builder -> builder.disableBatchTrace(true), factory -> factory.createProcessEventSpan(false, eventMessage), this.expectedSpan("EventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)eventMessage));
    }

    @Test
    void createHandleEventSpanWithDisabledBatchSpanForStreaming() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        this.test(builder -> builder.disableBatchTrace(true), factory -> factory.createProcessEventSpan(true, eventMessage), this.expectedSpan("StreamingEventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_LINK).withMessage((Message<?>)eventMessage));
    }

    @Test
    void createHandleEventSpanWithDistributedInSameTraceWithRecentMessage() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        Mockito.when((Object)eventMessage.getTimestamp()).thenReturn((Object)Instant.now());
        this.test(builder -> builder.distributedInSameTrace(true), factory -> factory.createProcessEventSpan(true, eventMessage), this.expectedSpan("StreamingEventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)eventMessage));
    }

    @Test
    void createHandleEventSpanWithDistributedInSameTraceWithOldMessage() {
        EventMessage eventMessage = (EventMessage)Mockito.mock(EventMessage.class);
        Mockito.when((Object)eventMessage.getTimestamp()).thenReturn((Object)Instant.now().minus(Duration.ofSeconds(600L)));
        this.test(builder -> builder.distributedInSameTrace(true).distributedInSameTraceTimeLimit(Duration.ofSeconds(500L)), factory -> factory.createProcessEventSpan(true, eventMessage), this.expectedSpan("StreamingEventProcessor.process", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)eventMessage));
    }

    @Override
    protected DefaultEventProcessorSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultEventProcessorSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DefaultEventProcessorSpanFactory createFactoryBasedOnBuilder(DefaultEventProcessorSpanFactory.Builder builder) {
        return builder.build();
    }
}

