/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackerStatus;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.WorkPackage;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.utils.AssertUtils;
import org.axonframework.utils.DelegateScheduledExecutorService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class WorkPackageTest {
    private static final String PROCESSOR_NAME = "test";
    private TokenStore tokenStore;
    private ScheduledExecutorService executorService;
    private TestEventFilter eventFilter;
    private TestBatchProcessor batchProcessor;
    private Segment segment;
    private TrackingToken initialTrackingToken;
    private WorkPackage.Builder testSubjectBuilder;
    private WorkPackage testSubject;
    private TrackerStatus trackerStatus;
    private List<TrackerStatus> trackerStatusUpdates;
    private Predicate<TrackedEventMessage<?>> eventFilterPredicate;
    private Predicate<List<? extends EventMessage<?>>> batchProcessorPredicate;

    WorkPackageTest() {
    }

    @BeforeEach
    void setUp() {
        this.tokenStore = (TokenStore)Mockito.spy((Object)new InMemoryTokenStore());
        this.executorService = (ScheduledExecutorService)Mockito.spy((Object)new DelegateScheduledExecutorService(Executors.newScheduledThreadPool(1)));
        this.eventFilter = new TestEventFilter();
        this.batchProcessor = new TestBatchProcessor();
        this.segment = Segment.ROOT_SEGMENT;
        this.initialTrackingToken = new GlobalSequenceTrackingToken(0L);
        this.trackerStatus = new TrackerStatus(this.segment, this.initialTrackingToken);
        this.trackerStatusUpdates = new ArrayList<TrackerStatus>();
        this.eventFilterPredicate = event -> true;
        this.batchProcessorPredicate = event -> true;
        this.testSubjectBuilder = WorkPackage.builder().name(PROCESSOR_NAME).tokenStore(this.tokenStore).transactionManager(NoTransactionManager.instance()).executorService((ExecutorService)this.executorService).eventFilter((WorkPackage.EventFilter)this.eventFilter).batchProcessor((WorkPackage.BatchProcessor)this.batchProcessor).segment(this.segment).initialToken(this.initialTrackingToken).batchSize(1).claimExtensionThreshold(5000L).segmentStatusUpdater(op -> {
            TrackerStatus update = (TrackerStatus)op.apply(this.trackerStatus);
            this.trackerStatusUpdates.add(update);
            this.trackerStatus = update;
        });
        this.testSubject = this.testSubjectBuilder.build();
    }

    @AfterEach
    void tearDown() {
        this.executorService.shutdown();
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void scheduleEventDoesNotScheduleIfTheLastDeliveredTokenCoversTheEventsToken() {
        GenericTrackedEventMessage testEvent = new GenericTrackedEventMessage((TrackingToken)new GlobalSequenceTrackingToken(1L), GenericEventMessage.asEventMessage((Object)"some-event"));
        WorkPackage testSubjectWithCustomInitialToken = this.testSubjectBuilder.initialToken((TrackingToken)new GlobalSequenceTrackingToken(2L)).build();
        testSubjectWithCustomInitialToken.scheduleEvent((TrackedEventMessage)testEvent);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.executorService});
    }

    @Test
    void scheduleEventUpdatesLastDeliveredToken() {
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage testEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.testSubject.scheduleEvent((TrackedEventMessage)testEvent);
        Assertions.assertEquals((Object)expectedToken, (Object)this.testSubject.lastDeliveredToken());
    }

    @Test
    void scheduleEventFailsOnEventValidator() throws ExecutionException, InterruptedException {
        GlobalSequenceTrackingToken testToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage testEvent = new GenericTrackedEventMessage((TrackingToken)testToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.eventFilterPredicate = arg_0 -> WorkPackageTest.lambda$scheduleEventFailsOnEventValidator$3((TrackedEventMessage)testEvent, arg_0);
        this.testSubject.scheduleEvent((TrackedEventMessage)testEvent);
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertNull((Object)this.trackerStatus));
        Assertions.assertEquals((int)2, (int)this.trackerStatusUpdates.size());
        Assertions.assertTrue((boolean)this.trackerStatusUpdates.get(0).isErrorState());
        Assertions.assertNull((Object)this.trackerStatusUpdates.get(1));
        CompletableFuture abortResult = this.testSubject.abort(null);
        Assertions.assertTrue((boolean)abortResult.isDone());
        Assertions.assertTrue((boolean)((Exception)abortResult.get()).getClass().isAssignableFrom(IllegalStateException.class));
    }

    @Test
    void scheduleEventFailsOnBatchProcessor() throws ExecutionException, InterruptedException {
        GlobalSequenceTrackingToken testToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage testEvent = new GenericTrackedEventMessage((TrackingToken)testToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.batchProcessorPredicate = arg_0 -> WorkPackageTest.lambda$scheduleEventFailsOnBatchProcessor$6((TrackingToken)testToken, arg_0);
        this.testSubject.scheduleEvent((TrackedEventMessage)testEvent);
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertNull((Object)this.trackerStatus));
        Assertions.assertEquals((int)2, (int)this.trackerStatusUpdates.size());
        Assertions.assertTrue((boolean)this.trackerStatusUpdates.get(0).isErrorState());
        Assertions.assertNull((Object)this.trackerStatusUpdates.get(1));
        CompletableFuture abortResult = this.testSubject.abort(null);
        Assertions.assertTrue((boolean)abortResult.isDone());
        Assertions.assertTrue((boolean)((Exception)abortResult.get()).getClass().isAssignableFrom(IllegalStateException.class));
    }

    @Test
    void scheduleEventRunsSuccessfully() {
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.testSubject.scheduleEvent((TrackedEventMessage)expectedEvent);
        List<EventMessage<?>> validatedEvents = this.eventFilter.getValidatedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)validatedEvents.size()));
        Assertions.assertEquals((Object)expectedEvent, validatedEvents.get(0));
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)processedEvents.size()));
        Assertions.assertEquals((Object)expectedEvent.trackingToken(), (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
        ArgumentCaptor tokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)tokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)this.segment.getSegmentId()));
        Assertions.assertEquals((Object)expectedToken, (Object)tokenCaptor.getValue());
        Assertions.assertEquals((int)1, (int)this.trackerStatusUpdates.size());
        OptionalLong resultPosition = this.trackerStatusUpdates.get(0).getCurrentPosition();
        Assertions.assertTrue((boolean)resultPosition.isPresent());
        Assertions.assertEquals((long)1L, (long)resultPosition.getAsLong());
    }

    @Test
    void replayTokenIsPropagatedAndAdvancedWithoutCurrent() {
        this.testSubjectBuilder.initialToken((TrackingToken)new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L)));
        this.testSubject = this.testSubjectBuilder.build();
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.testSubject.scheduleEvent((TrackedEventMessage)expectedEvent);
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)processedEvents.size()));
        ReplayToken expectedAdvancedToken = new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L), (TrackingToken)new GlobalSequenceTrackingToken(1L));
        Assertions.assertEquals((Object)expectedAdvancedToken, (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
    }

    @Test
    void replayTokenIsPropagatedAndAdvancedWithCurrent() {
        this.testSubjectBuilder.initialToken((TrackingToken)new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L), (TrackingToken)new GlobalSequenceTrackingToken(0L)));
        this.testSubject = this.testSubjectBuilder.build();
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        this.testSubject.scheduleEvent((TrackedEventMessage)expectedEvent);
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)processedEvents.size()));
        ReplayToken expectedAdvancedToken = new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L), (TrackingToken)new GlobalSequenceTrackingToken(1L));
        Assertions.assertEquals((Object)expectedAdvancedToken, (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
    }

    @Test
    void scheduleEventExtendsTokenClaimAfterClaimThresholdExtension() {
        int extremelyShortClaimExtensionThreshold = 1;
        WorkPackage testSubjectWithShortThreshold = this.testSubjectBuilder.claimExtensionThreshold((long)extremelyShortClaimExtensionThreshold).build();
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        testSubjectWithShortThreshold.scheduleEvent((TrackedEventMessage)expectedEvent);
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)processedEvents.size()));
        Assertions.assertEquals((Object)expectedEvent.trackingToken(), (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
        ArgumentCaptor tokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)tokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)this.segment.getSegmentId()));
        Assertions.assertEquals((Object)expectedToken, (Object)tokenCaptor.getValue());
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> {
            testSubjectWithShortThreshold.scheduleWorker();
            ((TokenStore)Mockito.verify((Object)this.tokenStore, (VerificationMode)Mockito.atLeastOnce())).extendClaim(PROCESSOR_NAME, this.segment.getSegmentId());
        });
    }

    @Test
    void scheduleEventUpdatesTokenAfterClaimThresholdExtension() {
        int extremelyShortClaimExtensionThreshold = 1;
        WorkPackage testSubjectWithShortThreshold = this.testSubjectBuilder.claimExtensionThreshold((long)extremelyShortClaimExtensionThreshold).build();
        this.eventFilterPredicate = event -> false;
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"some-event"));
        testSubjectWithShortThreshold.scheduleEvent((TrackedEventMessage)expectedEvent);
        List<EventMessage<?>> validatedEvents = this.eventFilter.getValidatedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)validatedEvents.size()));
        Assertions.assertEquals((Object)expectedEvent, validatedEvents.get(0));
        ArgumentCaptor tokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> {
            testSubjectWithShortThreshold.scheduleWorker();
            ((TokenStore)Mockito.verify((Object)this.tokenStore, (VerificationMode)Mockito.atLeastOnce())).storeToken((TrackingToken)tokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)this.segment.getSegmentId()));
        });
        Assertions.assertEquals((Object)expectedToken, (Object)tokenCaptor.getValue());
    }

    @Test
    void scheduleWorkerForAbortedPackage() throws ExecutionException, InterruptedException {
        CompletableFuture result = this.testSubject.abort(null);
        this.testSubject.scheduleWorker();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertNull((Object)this.trackerStatus));
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)result.isDone()));
        Assertions.assertNull(result.get());
    }

    @Test
    void hasRemainingCapacityReturnsTrueForWorkPackageWithoutScheduledEvents() {
        Assertions.assertTrue((boolean)this.testSubject.hasRemainingCapacity());
    }

    @Test
    void segment() {
        Assertions.assertEquals((Object)this.segment, (Object)this.testSubject.segment());
    }

    @Test
    void lastDeliveredTokenEqualsInitialTokenWhenNoEventsHaveBeenScheduled() {
        Assertions.assertEquals((Object)this.initialTrackingToken, (Object)this.testSubject.lastDeliveredToken());
    }

    @Test
    void isAbortTriggeredReturnsFalseInAbsenceOfAbort() {
        Assertions.assertFalse((boolean)this.testSubject.isAbortTriggered());
    }

    @Test
    void isAbortTriggeredReturnsTrueAfterAbortInvocation() {
        this.testSubject.abort(null);
        Assertions.assertTrue((boolean)this.testSubject.isAbortTriggered());
    }

    @Test
    void abortReturnsAbortReason() throws ExecutionException, InterruptedException {
        IllegalStateException expectedResult = new IllegalStateException();
        CompletableFuture result = this.testSubject.abort((Exception)expectedResult);
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)result.isDone()));
        Assertions.assertEquals((Object)expectedResult, result.get());
    }

    @Test
    void abortReturnsOriginalAbortReason() throws ExecutionException, InterruptedException {
        IllegalStateException originalAbortReason = new IllegalStateException();
        IllegalArgumentException otherAbortReason = new IllegalArgumentException();
        this.testSubject.abort((Exception)originalAbortReason);
        CompletableFuture result = this.testSubject.abort((Exception)otherAbortReason);
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertTrue((boolean)result.isDone()));
        Assertions.assertEquals((Object)originalAbortReason, result.get());
    }

    @Test
    void scheduleEventsReturnsFalseForEmptyList() {
        Assertions.assertFalse((boolean)this.testSubject.scheduleEvents(Collections.emptyList()));
    }

    @Test
    void scheduleEventsThrowsIllegalArgumentExceptionForNoneMatchingTokens() {
        GlobalSequenceTrackingToken testTokenOne = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage testEventOne = new GenericTrackedEventMessage((TrackingToken)testTokenOne, GenericEventMessage.asEventMessage((Object)"this-event"));
        GlobalSequenceTrackingToken testTokenTwo = new GlobalSequenceTrackingToken(2L);
        GenericTrackedEventMessage testEventTwo = new GenericTrackedEventMessage((TrackingToken)testTokenTwo, GenericEventMessage.asEventMessage((Object)"that-event"));
        ArrayList<GenericTrackedEventMessage> testEvents = new ArrayList<GenericTrackedEventMessage>();
        testEvents.add(testEventOne);
        testEvents.add(testEventTwo);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testSubject.scheduleEvents(testEvents));
    }

    @Test
    void scheduleEventsDoesNotScheduleIfTheLastDeliveredTokensCoversTheEventsToken() {
        GlobalSequenceTrackingToken testToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage testEventOne = new GenericTrackedEventMessage((TrackingToken)testToken, GenericEventMessage.asEventMessage((Object)"this-event"));
        GenericTrackedEventMessage testEventTwo = new GenericTrackedEventMessage((TrackingToken)testToken, GenericEventMessage.asEventMessage((Object)"that-event"));
        ArrayList<GenericTrackedEventMessage> testEvents = new ArrayList<GenericTrackedEventMessage>();
        testEvents.add(testEventOne);
        testEvents.add(testEventTwo);
        WorkPackage testSubjectWithCustomInitialToken = this.testSubjectBuilder.initialToken((TrackingToken)new GlobalSequenceTrackingToken(2L)).build();
        boolean result = testSubjectWithCustomInitialToken.scheduleEvents(testEvents);
        Assertions.assertFalse((boolean)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.executorService});
    }

    @Test
    void scheduleEventsReturnsTrueIfOnlyOneEventIsAcceptedByTheEventValidator() {
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage filteredEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"this-event"));
        GenericTrackedEventMessage expectedEvent = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"that-event"));
        ArrayList<GenericTrackedEventMessage> testEvents = new ArrayList<GenericTrackedEventMessage>();
        testEvents.add(filteredEvent);
        testEvents.add(expectedEvent);
        this.eventFilterPredicate = arg_0 -> WorkPackageTest.lambda$scheduleEventsReturnsTrueIfOnlyOneEventIsAcceptedByTheEventValidator$22((TrackedEventMessage)filteredEvent, arg_0);
        boolean result = this.testSubject.scheduleEvents(testEvents);
        Assertions.assertTrue((boolean)result);
        List validatedEvents = this.eventFilter.getValidatedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)2, (int)validatedEvents.size()));
        Assertions.assertTrue((boolean)validatedEvents.containsAll(testEvents));
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)1, (int)processedEvents.size()));
        Assertions.assertEquals((Object)expectedEvent.trackingToken(), (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
        ArgumentCaptor tokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)tokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)this.segment.getSegmentId()));
        Assertions.assertEquals((Object)expectedToken, (Object)tokenCaptor.getValue());
        Assertions.assertEquals((int)1, (int)this.trackerStatusUpdates.size());
        OptionalLong resultPosition = this.trackerStatusUpdates.get(0).getCurrentPosition();
        Assertions.assertTrue((boolean)resultPosition.isPresent());
        Assertions.assertEquals((long)1L, (long)resultPosition.getAsLong());
    }

    @Test
    void scheduleEventsHandlesAllEventsInOneTransactionWhenAllEventsCanBeHandled() {
        GlobalSequenceTrackingToken expectedToken = new GlobalSequenceTrackingToken(1L);
        GenericTrackedEventMessage expectedEventOne = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"this-event"));
        GenericTrackedEventMessage expectedEventTwo = new GenericTrackedEventMessage((TrackingToken)expectedToken, GenericEventMessage.asEventMessage((Object)"that-event"));
        ArrayList<GenericTrackedEventMessage> expectedEvents = new ArrayList<GenericTrackedEventMessage>();
        expectedEvents.add(expectedEventOne);
        expectedEvents.add(expectedEventTwo);
        boolean result = this.testSubject.scheduleEvents(expectedEvents);
        Assertions.assertTrue((boolean)result);
        List validatedEvents = this.eventFilter.getValidatedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)2, (int)validatedEvents.size()));
        Assertions.assertTrue((boolean)validatedEvents.containsAll(expectedEvents));
        List<EventMessage<?>> processedEvents = this.batchProcessor.getProcessedEvents();
        AssertUtils.assertWithin(500, TimeUnit.MILLISECONDS, () -> Assertions.assertEquals((int)2, (int)processedEvents.size()));
        Assertions.assertEquals((Object)expectedEventOne.trackingToken(), (Object)((TrackedEventMessage)processedEvents.get(0)).trackingToken());
        Assertions.assertEquals((Object)expectedEventTwo.trackingToken(), (Object)((TrackedEventMessage)processedEvents.get(1)).trackingToken());
        ArgumentCaptor tokenCaptor = ArgumentCaptor.forClass(TrackingToken.class);
        ((TokenStore)Mockito.verify((Object)this.tokenStore)).storeToken((TrackingToken)tokenCaptor.capture(), (String)Mockito.eq((Object)PROCESSOR_NAME), Mockito.eq((int)this.segment.getSegmentId()));
        Assertions.assertEquals((Object)expectedToken, (Object)tokenCaptor.getValue());
        Assertions.assertTrue((this.trackerStatusUpdates.size() >= 1 ? 1 : 0) != 0);
        OptionalLong resultPosition = this.trackerStatusUpdates.get(0).getCurrentPosition();
        Assertions.assertTrue((boolean)resultPosition.isPresent());
        Assertions.assertEquals((long)1L, (long)resultPosition.getAsLong());
    }

    private static /* synthetic */ boolean lambda$scheduleEventsReturnsTrueIfOnlyOneEventIsAcceptedByTheEventValidator$22(TrackedEventMessage filteredEvent, TrackedEventMessage event) {
        return !event.equals(filteredEvent);
    }

    private static /* synthetic */ boolean lambda$scheduleEventFailsOnBatchProcessor$6(TrackingToken testToken, List event) {
        if (event.stream().anyMatch(e -> ((TrackedEventMessage)e).trackingToken().equals(testToken))) {
            throw new IllegalStateException("Some exception");
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$scheduleEventFailsOnEventValidator$3(TrackedEventMessage testEvent, TrackedEventMessage event) {
        if (event.equals(testEvent)) {
            throw new IllegalStateException("Some exception");
        }
        return true;
    }

    private class TestBatchProcessor
    implements WorkPackage.BatchProcessor {
        private final List<EventMessage<?>> processedEvents = new ArrayList();

        private TestBatchProcessor() {
        }

        public void processBatch(List<? extends EventMessage<?>> eventMessages, UnitOfWork<? extends EventMessage<?>> unitOfWork, Collection<Segment> processingSegments) {
            if (WorkPackageTest.this.batchProcessorPredicate.test(eventMessages)) {
                unitOfWork.executeWithResult(() -> {
                    unitOfWork.commit();
                    this.processedEvents.addAll(eventMessages);
                    return null;
                });
            }
        }

        public List<EventMessage<?>> getProcessedEvents() {
            return this.processedEvents;
        }
    }

    private class TestEventFilter
    implements WorkPackage.EventFilter {
        private final List<EventMessage<?>> validatedEvents = new ArrayList();

        private TestEventFilter() {
        }

        public boolean canHandle(TrackedEventMessage<?> eventMessage, Segment segment) {
            this.validatedEvents.add((EventMessage<?>)eventMessage);
            return WorkPackageTest.this.eventFilterPredicate.test(eventMessage);
        }

        public List<EventMessage<?>> getValidatedEvents() {
            return this.validatedEvents;
        }
    }
}

