/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.eventhandling.AllowReplay;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReplayAwareMessageHandlerWrapperTest {
    private SomeHandler handler;
    private AnnotationEventHandlerAdapter testSubject;
    private ReplayToken replayToken;
    private GlobalSequenceTrackingToken regularToken;
    private ReplayPreventingHandler disallowingHandler;
    private AnnotationEventHandlerAdapter testDisallowingSubject;
    private SomeMethodHandler methodHandler;
    private AnnotationEventHandlerAdapter testMethodSubject;

    ReplayAwareMessageHandlerWrapperTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler = new SomeHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)this.handler);
        this.methodHandler = new SomeMethodHandler();
        this.testMethodSubject = new AnnotationEventHandlerAdapter((Object)this.methodHandler);
        this.disallowingHandler = new ReplayPreventingHandler();
        this.testDisallowingSubject = new AnnotationEventHandlerAdapter((Object)this.disallowingHandler);
        this.regularToken = new GlobalSequenceTrackingToken(1L);
        this.replayToken = new ReplayToken((TrackingToken)this.regularToken);
    }

    @Test
    void invokeWithReplayTokens() throws Exception {
        GenericTrackedEventMessage stringEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)"1"));
        GenericTrackedEventMessage longEvent = new GenericTrackedEventMessage((TrackingToken)this.replayToken, GenericEventMessage.asEventMessage((Object)1L));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)stringEvent));
        Assertions.assertTrue((boolean)this.testMethodSubject.canHandle((EventMessage)stringEvent));
        Assertions.assertTrue((boolean)this.testSubject.canHandle((EventMessage)longEvent));
        Assertions.assertTrue((boolean)this.testMethodSubject.canHandle((EventMessage)longEvent));
        this.testSubject.handle((EventMessage)stringEvent);
        this.testMethodSubject.handle((EventMessage)stringEvent);
        this.testSubject.handle((EventMessage)longEvent);
        this.testMethodSubject.handle((EventMessage)longEvent);
        Assertions.assertTrue((boolean)this.handler.receivedLongs.isEmpty());
        Assertions.assertTrue((boolean)this.methodHandler.receivedLongs.isEmpty());
        Assertions.assertFalse((boolean)this.handler.receivedStrings.isEmpty());
        Assertions.assertFalse((boolean)this.methodHandler.receivedStrings.isEmpty());
        Assertions.assertTrue((boolean)this.testSubject.supportsReset());
        Assertions.assertTrue((boolean)this.testMethodSubject.supportsReset());
        Assertions.assertFalse((boolean)this.testDisallowingSubject.supportsReset());
    }

    @AllowReplay(value=false)
    private static class ReplayPreventingHandler {
        private List<String> receivedStrings = new ArrayList<String>();
        private List<Long> receivedLongs = new ArrayList<Long>();

        private ReplayPreventingHandler() {
        }

        @EventHandler
        public void handle(String event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedStrings.add(event);
        }

        @EventHandler
        public void handle(Long event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
        }
    }

    private static class SomeMethodHandler {
        private List<String> receivedStrings = new ArrayList<String>();
        private List<Long> receivedLongs = new ArrayList<Long>();

        private SomeMethodHandler() {
        }

        @AllowReplay
        @EventHandler
        public void handle(String event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedStrings.add(event);
        }

        @EventHandler
        @AllowReplay(value=false)
        public void handle(Long event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
        }
    }

    @AllowReplay(value=false)
    private static class SomeHandler {
        private List<String> receivedStrings = new ArrayList<String>();
        private List<Long> receivedLongs = new ArrayList<Long>();

        private SomeHandler() {
        }

        @AllowReplay
        @EventHandler
        public void handle(String event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedStrings.add(event);
        }

        @EventHandler
        public void handle(Long event, TrackingToken token) {
            Assertions.assertFalse((boolean)(token instanceof ReplayToken));
            this.receivedLongs.add(event);
        }
    }
}

