/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.awaitility.Awaitility;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventScheduler;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventSchedulerSupplier;
import org.axonframework.eventhandling.scheduling.java.SimpleScheduleToken;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.utils.DbSchedulerTestUtil;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration
@ExtendWith(value={SpringExtension.class})
abstract class AbstractDbSchedulerEventSchedulerTest {
    @Autowired
    protected DataSource dataSource;
    private List<EventMessage<?>> publishedMessages;
    protected DbSchedulerEventScheduler eventScheduler;
    protected Scheduler scheduler;

    AbstractDbSchedulerEventSchedulerTest() {
    }

    abstract Task<?> getTask(Supplier<DbSchedulerEventScheduler> var1);

    abstract boolean useBinaryPojo();

    @AfterEach
    void cleanUp() {
        if (!Objects.isNull(this.eventScheduler)) {
            this.eventScheduler.shutdown();
            this.eventScheduler = null;
        }
    }

    @BeforeEach
    void prepare() {
        DbSchedulerTestUtil.reCreateTable(this.dataSource);
        this.publishedMessages = new ArrayList();
        InMemoryEventBus eventBus = new InMemoryEventBus(this.publishedMessages);
        DbSchedulerEventSchedulerSupplier supplier = new DbSchedulerEventSchedulerSupplier();
        this.scheduler = (Scheduler)Mockito.spy((Object)DbSchedulerTestUtil.getScheduler(this.dataSource, this.getTask((Supplier<DbSchedulerEventScheduler>)supplier)));
        this.eventScheduler = DbSchedulerEventScheduler.builder().scheduler(this.scheduler).serializer(TestSerializer.JACKSON.getSerializer()).eventBus((EventBus)eventBus).useBinaryPojo(this.useBinaryPojo()).build();
        supplier.set(this.eventScheduler);
        this.scheduler.start();
    }

    @Test
    void whenScheduleIsCalledThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ZERO, (Object)1);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)1, (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertTrue((boolean)publishedMessage.getMetaData().isEmpty());
    }

    @Test
    void whenScheduledInPastIsCalledThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ofSeconds(-10L), (Object)1);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)1, (Object)publishedMessage.getPayload());
    }

    @Test
    void whenScheduleIsCalledWithEventMessageMetadataShouldBePreserved() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("foo", "bar");
        GenericEventMessage originalMessage = new GenericEventMessage((Object)2, metadata);
        this.eventScheduler.schedule(Instant.now(), (Object)originalMessage);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)2, (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertEquals(metadata, (Object)publishedMessage.getMetaData());
    }

    @Test
    void whenScheduleIsCalledAndThereIsARevisionThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ZERO, (Object)new PayloadWithRevision());
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)new PayloadWithRevision(), (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertTrue((boolean)publishedMessage.getMetaData().isEmpty());
    }

    @Test
    void whenScheduleIsCalledWithEventThatHasARevisionPayloadMessageMetadataShouldBePreserved() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("foo", "bar");
        GenericEventMessage originalMessage = new GenericEventMessage((Object)new PayloadWithRevision(), metadata);
        this.eventScheduler.schedule(Instant.now(), (Object)originalMessage);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)new PayloadWithRevision(), (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertEquals(metadata, (Object)publishedMessage.getMetaData());
    }

    @Test
    void rescheduleWithDurationShouldWork() {
        ScheduleToken token = this.eventScheduler.schedule(Duration.ofMillis(100L), (Object)3);
        this.eventScheduler.reschedule(token, Duration.ofMillis(100L), (Object)4);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)4, (Object)publishedMessage.getPayload());
    }

    @Test
    void rescheduleWithInstantShouldWork() {
        ScheduleToken token = this.eventScheduler.schedule(Instant.now().plusMillis(100L), (Object)5);
        this.eventScheduler.reschedule(token, Instant.now().plusMillis(100L), (Object)6);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)6, (Object)publishedMessage.getPayload());
    }

    @Test
    void shutdownCalledOnScheduler() {
        this.eventScheduler.shutdown();
        ((Scheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    void incorrectTokenClassShouldThrow() {
        SimpleScheduleToken token = new SimpleScheduleToken("ff");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$incorrectTokenClassShouldThrow$7((ScheduleToken)token));
    }

    private /* synthetic */ void lambda$incorrectTokenClassShouldThrow$7(ScheduleToken token) throws Throwable {
        this.eventScheduler.cancelSchedule(token);
    }

    @Configuration
    public static class Context {
        @Bean
        public DataSource dataSource() {
            JDBCDataSource dataSource = new JDBCDataSource();
            dataSource.setUrl("jdbc:hsqldb:mem:testdb");
            dataSource.setUser("sa");
            dataSource.setPassword("");
            return dataSource;
        }
    }

    @Revision(value="Foo")
    private static class PayloadWithRevision {
        PayloadWithRevision() {
        }

        public boolean equals(Object obj) {
            return obj instanceof PayloadWithRevision;
        }
    }

    private static class InMemoryEventBus
    implements EventBus {
        private final List<EventMessage<?>> publishedMessages;

        private InMemoryEventBus(List<EventMessage<?>> publishedMessages) {
            this.publishedMessages = publishedMessages;
        }

        public void publish(@Nonnull List<? extends EventMessage<?>> events) {
            this.publishedMessages.addAll(events);
        }

        public Registration subscribe(@Nonnull Consumer<List<? extends EventMessage<?>>> eventProcessor) {
            throw new UnsupportedOperationException();
        }

        public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super EventMessage<?>> dispatchInterceptor) {
            throw new UnsupportedOperationException();
        }
    }
}

