/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.jobrunr;

import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.jobrunr.JobRunrEventScheduler;
import org.axonframework.serialization.TestSerializer;
import org.jobrunr.scheduling.JobScheduler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class JobRunrEventSchedulerBuilderTest {
    private JobRunrEventScheduler.Builder builder;
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final EventBus eventBus = (EventBus)Mockito.mock(EventBus.class);

    JobRunrEventSchedulerBuilderTest() {
    }

    @BeforeEach
    void newBuilder() {
        this.builder = JobRunrEventScheduler.builder();
    }

    @Test
    void whenAllPropertiesAreSetCreatesManager() {
        JobRunrEventScheduler scheduler = this.builder.transactionManager(this.transactionManager).jobScheduler(this.jobScheduler).serializer(TestSerializer.JACKSON.getSerializer()).eventBus(this.eventBus).build();
        Assertions.assertNotNull((Object)scheduler);
    }

    @Test
    void validateNeedsAllPropertiesSet() {
        this.builder.jobScheduler(this.jobScheduler).transactionManager(this.transactionManager);
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.build());
    }

    @Test
    void whenSettingSchedulerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.jobScheduler(null));
    }

    @Test
    void whenSettingNameWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.jobName(null));
    }

    @Test
    void whenSettingTransactionManagerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.transactionManager(null));
    }

    @Test
    void whenSettingSerializerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.serializer(null));
    }

    @Test
    void whenSettingEventBusWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.eventBus(null));
    }
}

