/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.jobrunr;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.awaitility.Awaitility;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.java.SimpleScheduleToken;
import org.axonframework.eventhandling.scheduling.jobrunr.JobRunrEventScheduler;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.TestSerializer;
import org.jobrunr.configuration.JobRunr;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.StorageProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JobRunrEventSchedulerTest {
    private List<EventMessage<?>> publishedMessages;
    private JobRunrEventScheduler eventScheduler;
    private BackgroundJobServer backgroundJobServer;
    private JobScheduler jobScheduler;

    JobRunrEventSchedulerTest() {
    }

    @AfterEach
    void cleanUp() {
        if (this.eventScheduler != null) {
            this.eventScheduler.shutdown();
        }
        if (!Objects.isNull(this.backgroundJobServer)) {
            this.backgroundJobServer.stop();
            this.backgroundJobServer = null;
        }
    }

    @BeforeEach
    void prepare() {
        this.publishedMessages = new ArrayList();
        InMemoryEventBus eventBus = new InMemoryEventBus(this.publishedMessages);
        InMemoryStorageProvider storageProvider = new InMemoryStorageProvider();
        this.jobScheduler = (JobScheduler)Mockito.spy((Object)new JobScheduler((StorageProvider)storageProvider));
        this.eventScheduler = JobRunrEventScheduler.builder().jobScheduler(this.jobScheduler).serializer(TestSerializer.JACKSON.getSerializer()).eventBus((EventBus)eventBus).build();
        JobRunr.configure().useJobActivator((JobActivator)new SimpleActivator(this.eventScheduler)).useStorageProvider((StorageProvider)storageProvider).useBackgroundJobServer(BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration().andPollIntervalInSeconds(5)).initialize();
        this.backgroundJobServer = JobRunr.getBackgroundJobServer();
    }

    @Test
    void whenScheduleIsCalledThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ZERO, (Object)1);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)1, (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertTrue((boolean)publishedMessage.getMetaData().isEmpty());
    }

    @Test
    void whenScheduledInPastIsCalledThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ofSeconds(-10L), (Object)1);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)1, (Object)publishedMessage.getPayload());
    }

    @Test
    void whenScheduleIsCalledWithEventMessageMetadataShouldBePreserved() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("foo", "bar");
        GenericEventMessage originalMessage = new GenericEventMessage((Object)2, metadata);
        this.eventScheduler.schedule(Instant.now(), (Object)originalMessage);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)2, (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertEquals(metadata, (Object)publishedMessage.getMetaData());
    }

    @Test
    void whenScheduleIsCalledAndThereIsARevisionThanShouldPublishEvent() {
        this.eventScheduler.schedule(Duration.ZERO, (Object)new PayloadWithRevision());
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)new PayloadWithRevision(), (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertTrue((boolean)publishedMessage.getMetaData().isEmpty());
    }

    @Test
    void whenScheduleIsCalledWithEventThatHasARevisionPayloadMessageMetadataShouldBePreserved() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("foo", "bar");
        GenericEventMessage originalMessage = new GenericEventMessage((Object)new PayloadWithRevision(), metadata);
        this.eventScheduler.schedule(Instant.now(), (Object)originalMessage);
        Instant rightAfterSchedule = Instant.now();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)new PayloadWithRevision(), (Object)publishedMessage.getPayload());
        Assertions.assertTrue((boolean)rightAfterSchedule.isBefore(publishedMessage.getTimestamp()));
        Assertions.assertEquals(metadata, (Object)publishedMessage.getMetaData());
    }

    @Test
    void rescheduleWithDurationShouldWork() {
        ScheduleToken token = this.eventScheduler.schedule(Duration.ofMillis(100L), (Object)3);
        this.eventScheduler.reschedule(token, Duration.ofMillis(100L), (Object)4);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)4, (Object)publishedMessage.getPayload());
    }

    @Test
    void rescheduleWithInstantShouldWork() {
        ScheduleToken token = this.eventScheduler.schedule(Instant.now().plusMillis(100L), (Object)5);
        this.eventScheduler.reschedule(token, Instant.now().plusMillis(100L), (Object)6);
        Awaitility.await().atMost(Duration.ofSeconds(2L)).until(() -> !this.publishedMessages.isEmpty());
        Assertions.assertEquals((int)1, (int)this.publishedMessages.size());
        EventMessage<?> publishedMessage = this.publishedMessages.get(0);
        Assertions.assertEquals((Object)6, (Object)publishedMessage.getPayload());
    }

    @Test
    void shutdownCalledOnScheduler() {
        this.eventScheduler.shutdown();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    void incorrectTokenClassShouldThrow() {
        SimpleScheduleToken token = new SimpleScheduleToken("ff");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.lambda$incorrectTokenClassShouldThrow$7((ScheduleToken)token));
    }

    private /* synthetic */ void lambda$incorrectTokenClassShouldThrow$7(ScheduleToken token) throws Throwable {
        this.eventScheduler.cancelSchedule(token);
    }

    @Revision(value="Foo")
    private static class PayloadWithRevision {
        PayloadWithRevision() {
        }

        public boolean equals(Object obj) {
            return obj instanceof PayloadWithRevision;
        }
    }

    public static class SimpleActivator
    implements JobActivator {
        private final JobRunrEventScheduler eventScheduler;

        SimpleActivator(JobRunrEventScheduler eventScheduler) {
            this.eventScheduler = eventScheduler;
        }

        public <T> T activateJob(Class<T> type) {
            if (type.isAssignableFrom(JobRunrEventScheduler.class)) {
                return type.cast(this.eventScheduler);
            }
            return null;
        }
    }

    private static class InMemoryEventBus
    implements EventBus {
        private final List<EventMessage<?>> publishedMessages;

        private InMemoryEventBus(List<EventMessage<?>> publishedMessages) {
            this.publishedMessages = publishedMessages;
        }

        public void publish(@Nonnull List<? extends EventMessage<?>> events) {
            this.publishedMessages.addAll(events);
        }

        public Registration subscribe(@Nonnull Consumer<List<? extends EventMessage<?>>> eventProcessor) {
            throw new UnsupportedOperationException();
        }

        public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super EventMessage<?>> dispatchInterceptor) {
            throw new UnsupportedOperationException();
        }
    }
}

