/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.sql.DataSource;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.ConfigToken;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.jdbc.GenericTokenTableFactory;
import org.axonframework.eventhandling.tokenstore.jdbc.JdbcTokenStore;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenTableFactory;
import org.axonframework.serialization.TestSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@ContextConfiguration
@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
class JdbcTokenStoreTest {
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Named(value="tokenStore")
    private JdbcTokenStore tokenStore;
    @Autowired
    @Named(value="concurrentTokenStore")
    private JdbcTokenStore concurrentTokenStore;
    @Autowired
    @Named(value="stealingTokenStore")
    private JdbcTokenStore stealingTokenStore;
    @Autowired
    private TransactionManager transactionManager;

    JdbcTokenStoreTest() {
    }

    @BeforeEach
    void setUp() {
        this.transactionManager.executeInTransaction(() -> {
            try {
                this.dataSource.getConnection().prepareStatement("DROP TABLE IF EXISTS TokenEntry").executeUpdate();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Failed to drop or create token table", e);
            }
            this.tokenStore.createSchema((TokenTableFactory)GenericTokenTableFactory.INSTANCE);
        });
    }

    @AfterEach
    void tearDown() {
        AbstractTokenEntry.clock = Clock.systemUTC();
    }

    @Test
    void claimAndUpdateToken() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 1));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("test", 0)));
        GlobalSequenceTrackingToken token = new GlobalSequenceTrackingToken(1L);
        this.transactionManager.executeInTransaction(() -> this.lambda$claimAndUpdateToken$3((TrackingToken)token));
        this.transactionManager.executeInTransaction(() -> this.lambda$claimAndUpdateToken$4((TrackingToken)token));
    }

    @Transactional
    @Test
    void updateAndLoadNullToken() {
        this.tokenStore.initializeTokenSegments("test", 1);
        this.tokenStore.fetchToken("test", 0);
        this.tokenStore.storeToken(null, "test", 0);
        TrackingToken token = this.tokenStore.fetchToken("test", 0);
        Assertions.assertNull((Object)token);
    }

    @Transactional
    @Test
    void fetchTokenBySegment() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 2));
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void fetchTokenBySegmentSegment0() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 1));
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0});
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void fetchTokenBySegmentFailsDuringMerge() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 1));
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void fetchTokenBySegmentFailsDuringMergeSegment0() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 1));
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void fetchTokenBySegmentFailsDuringSplit() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 4));
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void fetchTokenBySegmentFailsDuringSplitSegment0() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 2));
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("test", segmentToFetch)));
    }

    @Transactional
    @Test
    void initializeTokens() {
        this.tokenStore.initializeTokenSegments("test1", 7);
        int[] actual = this.tokenStore.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
    }

    @Transactional
    @Test
    void initializeTokensAtGivenPosition() {
        this.tokenStore.initializeTokenSegments("test1", 7, (TrackingToken)new GlobalSequenceTrackingToken(10L));
        int[] actual = this.tokenStore.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
        for (int segment : actual) {
            Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(10L), (Object)this.tokenStore.fetchToken("test1", segment));
        }
    }

    @Transactional
    @Test
    void initializeTokensWhileAlreadyPresent() {
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.tokenStore.fetchToken("test1", 1));
    }

    @Transactional
    @Test
    void querySegments() {
        this.prepareTokenStore();
        this.transactionManager.executeInTransaction(() -> {
            int[] segments = this.tokenStore.fetchSegments("proc1");
            MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)2));
        });
        this.transactionManager.executeInTransaction(() -> {
            int[] segments = this.tokenStore.fetchSegments("proc2");
            MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)2));
        });
        this.transactionManager.executeInTransaction(() -> {
            int[] segments = this.tokenStore.fetchSegments("proc3");
            MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)0));
        });
    }

    @Transactional
    @Test
    void queryAvailableSegments() {
        this.prepareTokenStore();
        this.transactionManager.executeInTransaction(() -> {
            List segments = this.concurrentTokenStore.fetchAvailableSegments("proc1");
            MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
            this.tokenStore.releaseClaim("proc1", 0);
            List segmentsAfterRelease = this.concurrentTokenStore.fetchAvailableSegments("proc1");
            MatcherAssert.assertThat((Object)segmentsAfterRelease.size(), (Matcher)CoreMatchers.is((Object)1));
        });
        this.transactionManager.executeInTransaction(() -> {
            List segments = this.concurrentTokenStore.fetchAvailableSegments("proc2");
            MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)1));
            this.tokenStore.releaseClaim("proc2", 1);
            List segmentsAfterRelease = this.concurrentTokenStore.fetchAvailableSegments("proc2");
            MatcherAssert.assertThat((Object)segmentsAfterRelease.size(), (Matcher)CoreMatchers.is((Object)2));
        });
        this.transactionManager.executeInTransaction(() -> {
            List segments = this.tokenStore.fetchAvailableSegments("proc3");
            MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
        });
    }

    private void prepareTokenStore() {
        this.transactionManager.executeInTransaction(() -> {
            this.tokenStore.initializeTokenSegments("test", 1);
            this.tokenStore.initializeTokenSegments("proc1", 2);
            this.tokenStore.initializeTokenSegments("proc2", 2);
        });
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("test", 0)));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "proc1", 0));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc1", 1));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc2", 1));
    }

    @Test
    void claimAndUpdateTokenWithoutTransaction() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test", 1));
        Assertions.assertNull((Object)this.tokenStore.fetchToken("test", 0));
        GlobalSequenceTrackingToken token = new GlobalSequenceTrackingToken(1L);
        this.tokenStore.storeToken((TrackingToken)token, "test", 0);
        Assertions.assertEquals((Object)token, (Object)this.tokenStore.fetchToken("test", 0));
    }

    @Test
    void claimTokenConcurrently() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("concurrent", 1));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("concurrent", 0)));
        try {
            this.transactionManager.executeInTransaction(() -> this.concurrentTokenStore.fetchToken("concurrent", 0));
            Assertions.fail((String)"Expected UnableToClaimTokenException");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
    }

    @Test
    void claimTokenConcurrentlyAfterRelease() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("concurrent", 1));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("concurrent", 0));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.releaseClaim("concurrent", 0));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.concurrentTokenStore.fetchToken("concurrent", 0)));
    }

    @Test
    void claimTokenConcurrentlyAfterTimeLimit() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("concurrent", 1));
        this.transactionManager.executeInTransaction(() -> this.tokenStore.fetchToken("concurrent", 0));
        AbstractTokenEntry.clock = Clock.offset(Clock.systemUTC(), Duration.ofHours(1L));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.concurrentTokenStore.fetchToken("concurrent", 0)));
    }

    @Test
    void stealToken() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("stealing", 1));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.tokenStore.fetchToken("stealing", 0)));
        this.transactionManager.executeInTransaction(() -> Assertions.assertNull((Object)this.stealingTokenStore.fetchToken("stealing", 0)));
        try {
            this.transactionManager.executeInTransaction(() -> this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(0L), "stealing", 0));
            Assertions.fail((String)"Expected UnableToClaimTokenException");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
        this.transactionManager.executeInTransaction(() -> this.tokenStore.releaseClaim("stealing", 0));
        this.transactionManager.executeInTransaction(() -> this.stealingTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "stealing", 0));
    }

    @Test
    void storeAndLoadAcrossTransactions() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("multi", 1));
        this.transactionManager.executeInTransaction(() -> {
            this.tokenStore.fetchToken("multi", 0);
            this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "multi", 0);
        });
        this.transactionManager.executeInTransaction(() -> {
            TrackingToken actual = this.tokenStore.fetchToken("multi", 0);
            Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)actual);
            this.tokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "multi", 0);
        });
        this.transactionManager.executeInTransaction(() -> {
            TrackingToken actual = this.tokenStore.fetchToken("multi", 0);
            Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(2L), (Object)actual);
        });
    }

    @Test
    void claimAndDeleteToken() {
        this.transactionManager.executeInTransaction(() -> this.tokenStore.initializeTokenSegments("test1", 2));
        this.tokenStore.fetchToken("test1", 0);
        this.tokenStore.fetchToken("test1", 1);
        this.tokenStore.deleteToken("test1", 1);
        Assertions.assertArrayEquals((int[])new int[]{0}, (int[])this.tokenStore.fetchSegments("test1"));
    }

    @Test
    void deleteUnclaimedTokenFails() {
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.tokenStore.fetchToken("test1", 1));
    }

    @Transactional
    @Test
    void deleteTokenFailsWhenClaimedByOtherNode() {
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.concurrentTokenStore.fetchToken("test1", 1));
    }

    @Transactional
    @Test
    void identifierInitializedOnDemand() {
        Optional id1 = this.tokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id1.isPresent());
        Optional id2 = this.tokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id2.isPresent());
        Assertions.assertEquals(id1.get(), id2.get());
    }

    @Transactional
    @Test
    void identifierReadIfAvailable() throws SQLException {
        ConfigToken token = new ConfigToken(Collections.singletonMap("id", "test123"));
        PreparedStatement ps = this.dataSource.getConnection().prepareStatement("INSERT INTO TokenEntry(processorName, segment, tokenType, token) VALUES(?, ?, ?, ?)");
        ps.setString(1, "__config");
        ps.setInt(2, 0);
        ps.setString(3, ConfigToken.class.getName());
        ps.setBytes(4, (byte[])this.tokenStore.serializer().serialize((Object)token, byte[].class).getData());
        ps.executeUpdate();
        Optional id1 = this.tokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id1.isPresent());
        Optional id2 = this.tokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id2.isPresent());
        Assertions.assertEquals(id1.get(), id2.get());
        Assertions.assertEquals((Object)"test123", id1.get());
    }

    private /* synthetic */ void lambda$claimAndUpdateToken$4(TrackingToken token) {
        Assertions.assertEquals((Object)token, (Object)this.tokenStore.fetchToken("test", 0));
    }

    private /* synthetic */ void lambda$claimAndUpdateToken$3(TrackingToken token) {
        this.tokenStore.storeToken(token, "test", 0);
    }

    @Configuration
    public static class Context {
        @Bean
        public DataSource dataSource() {
            JDBCDataSource dataSource = new JDBCDataSource();
            dataSource.setUrl("jdbc:hsqldb:mem:testdb");
            dataSource.setUser("sa");
            dataSource.setPassword("");
            return dataSource;
        }

        @Bean
        public PlatformTransactionManager txManager(DataSource dataSource) {
            return new DataSourceTransactionManager(dataSource);
        }

        @Bean
        public JdbcTokenStore tokenStore(DataSource dataSource) {
            return JdbcTokenStore.builder().connectionProvider(dataSource::getConnection).serializer(TestSerializer.XSTREAM.getSerializer()).build();
        }

        @Bean
        public JdbcTokenStore concurrentTokenStore(DataSource dataSource) {
            return JdbcTokenStore.builder().connectionProvider(dataSource::getConnection).serializer(TestSerializer.XSTREAM.getSerializer()).claimTimeout((TemporalAmount)Duration.ofSeconds(2L)).nodeId("concurrent").build();
        }

        @Bean
        public JdbcTokenStore stealingTokenStore(DataSource dataSource) {
            return JdbcTokenStore.builder().connectionProvider(dataSource::getConnection).serializer(TestSerializer.XSTREAM.getSerializer()).claimTimeout((TemporalAmount)Duration.ofSeconds(-1L)).nodeId("stealing").build();
        }

        @Bean
        public TransactionManager transactionManager(final PlatformTransactionManager txManager) {
            return () -> {
                final TransactionStatus transaction = txManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                return new Transaction(){

                    public void commit() {
                        txManager.commit(transaction);
                    }

                    public void rollback() {
                        txManager.rollback(transaction);
                    }
                };
            };
        }
    }
}

