/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.ThrowingCorrelationDataProvider;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class GenericMessageTest {
    private final Map<String, ?> correlationData = MetaData.from(Collections.singletonMap("foo", "bar"));
    private UnitOfWork<?> unitOfWork;

    GenericMessageTest() {
    }

    @BeforeEach
    void setUp() {
        this.unitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)this.unitOfWork.getCorrelationData()).thenAnswer(invocation -> this.correlationData);
        CurrentUnitOfWork.set(this.unitOfWork);
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.clear((UnitOfWork)CurrentUnitOfWork.get());
        }
    }

    @Test
    void correlationDataAddedToNewMessage() {
        Assertions.assertEquals(this.correlationData, new HashMap(new GenericMessage(new Object()).getMetaData()));
        MetaData newMetaData = MetaData.from(Collections.singletonMap("whatever", new Object()));
        Assertions.assertEquals((Object)newMetaData.mergedWith(this.correlationData), (Object)new GenericMessage(new Object(), (Map)newMetaData).getMetaData());
    }

    @Test
    void messageSerialization() {
        GenericMessage message = new GenericMessage((Object)"payload", Collections.singletonMap("key", "value"));
        JacksonSerializer jacksonSerializer = JacksonSerializer.builder().build();
        SerializedObject serializedPayload = message.serializePayload((Serializer)jacksonSerializer, String.class);
        SerializedObject serializedMetaData = message.serializeMetaData((Serializer)jacksonSerializer, String.class);
        Assertions.assertEquals((Object)"\"payload\"", (Object)serializedPayload.getData());
        Assertions.assertEquals((Object)"{\"key\":\"value\",\"foo\":\"bar\"}", (Object)serializedMetaData.getData());
    }

    @Test
    void asMessageReturnsProvidedMessageAsIs() {
        GenericMessage testMessage = new GenericMessage((Object)"payload");
        Message result = GenericMessage.asMessage((Object)testMessage);
        Assertions.assertEquals((Object)testMessage, (Object)result);
    }

    @Test
    void asMessageWrapsProvidedObjectsInMessage() {
        String testPayload = "payload";
        Message result = GenericMessage.asMessage((Object)testPayload);
        Assertions.assertNotEquals((Object)testPayload, (Object)result);
        Assertions.assertEquals((Object)testPayload, (Object)result.getPayload());
    }

    @Test
    void whenCorrelationDataProviderThrowsException_thenCatchException() {
        this.unitOfWork = new DefaultUnitOfWork((Message)new GenericEventMessage((Object)"Input 1"));
        CurrentUnitOfWork.set(this.unitOfWork);
        this.unitOfWork.registerCorrelationDataProvider((CorrelationDataProvider)new ThrowingCorrelationDataProvider());
        CannotConvertBetweenTypesException exception = new CannotConvertBetweenTypesException("foo");
        Message result = GenericMessage.asMessage((Object)exception);
        Assertions.assertNotNull((Object)result);
    }
}

