/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.correlation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MetaDataValueTest {
    MetaDataValueTest() {
    }

    @Test
    void createMetaData() {
        HashMap<String, String> metaDataValues = new HashMap<String, String>();
        metaDataValues.put("first", "value");
        MetaData metaData = new MetaData(metaDataValues);
        metaDataValues.put("second", "value");
        Assertions.assertEquals((Object)"value", (Object)metaData.get((Object)"first"));
        Assertions.assertFalse((boolean)metaData.containsKey((Object)"second"));
    }

    @Test
    void mergedMetaData() {
        HashMap<String, String> metaDataValues = new HashMap<String, String>();
        metaDataValues.put("first", "value");
        MetaData metaData = new MetaData(metaDataValues);
        metaDataValues.put("second", "value");
        metaDataValues.put("first", "other");
        MetaData newMetaData = metaData.mergedWith(metaDataValues);
        Assertions.assertEquals((Object)"other", (Object)newMetaData.get((Object)"first"));
        Assertions.assertEquals((Object)"value", (Object)newMetaData.get((Object)"second"));
    }

    @Test
    void removedMetaData() {
        HashMap<String, String> metaDataValues = new HashMap<String, String>();
        metaDataValues.put("first", "value");
        metaDataValues.put("second", "value");
        MetaData metaData = new MetaData(metaDataValues);
        MetaData newMetaData = metaData.withoutKeys(metaDataValues.keySet());
        Assertions.assertTrue((boolean)newMetaData.isEmpty());
    }

    @Test
    void equals() {
        HashMap<String, String> metaDataValues = new HashMap<String, String>();
        metaDataValues.put("first", "value");
        MetaData metaData1 = new MetaData(metaDataValues);
        metaDataValues.put("second", "value");
        MetaData metaData2 = new MetaData(metaDataValues);
        MetaData metaData3 = new MetaData(metaDataValues);
        Assertions.assertEquals((Object)metaData1, (Object)metaData1);
        Assertions.assertEquals((Object)metaData2, (Object)metaData3);
        Assertions.assertNotEquals((Object)metaData1, (Object)metaData2);
        Assertions.assertNotEquals((Object)metaData1, (Object)metaData3);
        Assertions.assertNotEquals((Object)metaData3, (Object)metaData1);
        Assertions.assertNotEquals((Object)metaData1, (Object)new Object());
        Assertions.assertNotEquals((Object)metaData1, null);
        Assertions.assertEquals((Object)metaData2, metaDataValues);
        Assertions.assertEquals(metaDataValues, (Object)metaData2);
    }

    @Test
    void serialization() throws IOException, ClassNotFoundException {
        MetaData metaData1 = MetaData.from(Collections.singletonMap("Key1", "Value"));
        MetaData metaData2 = MetaData.from(Collections.singletonMap("Key2", "Value"));
        MetaData emptyMetaData = MetaData.emptyInstance();
        Assertions.assertEquals((Object)metaData1, (Object)this.serialize(metaData1));
        Assertions.assertEquals((Object)metaData2, (Object)this.serialize(metaData2));
        Assertions.assertSame((Object)emptyMetaData, (Object)this.serialize(emptyMetaData));
    }

    private MetaData serialize(MetaData metaData1) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(metaData1);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (MetaData)ois.readObject();
    }

    @Test
    void buildMetaDataThroughFrom() {
        HashMap<String, String> testMetaDataMap = new HashMap<String, String>();
        testMetaDataMap.put("firstKey", "firstVal");
        testMetaDataMap.put("secondKey", "secondVal");
        MetaData result = MetaData.from(testMetaDataMap);
        Assertions.assertEquals((Object)"firstVal", (Object)result.get((Object)"firstKey"));
        Assertions.assertEquals((Object)"secondVal", (Object)result.get((Object)"secondKey"));
    }

    @Test
    void buildMetaDataThroughWith() {
        MetaData result = MetaData.with((String)"key", (Object)"val");
        Assertions.assertEquals((Object)"val", (Object)result.get((Object)"key"));
    }

    @Test
    void buildMetaDataThroughWithAnd() {
        MetaData result = MetaData.with((String)"firstKey", (Object)"firstVal").and("secondKey", (Object)"secondVal");
        Assertions.assertEquals((Object)"firstVal", (Object)result.get((Object)"firstKey"));
        Assertions.assertEquals((Object)"secondVal", (Object)result.get((Object)"secondKey"));
    }

    @Test
    void buildMetaDataThroughAndIfNotPresentAddsNewValue() {
        MetaData result = MetaData.with((String)"firstKey", (Object)"firstVal").andIfNotPresent("secondKey", () -> "secondVal");
        Assertions.assertEquals((Object)"firstVal", (Object)result.get((Object)"firstKey"));
        Assertions.assertEquals((Object)"secondVal", (Object)result.get((Object)"secondKey"));
    }

    @Test
    void buildMetaDataThroughAndIfNotPresentDoesntAddNewValue() {
        MetaData result = MetaData.with((String)"firstKey", (Object)"firstVal").andIfNotPresent("firstKey", () -> "firstVal");
        Assertions.assertEquals((Object)"firstVal", (Object)result.get((Object)"firstKey"));
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @Test
    void metaDataModification_Clear() {
        MetaData metaData = new MetaData(Collections.emptyMap());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MetaData)metaData).clear());
    }

    @Test
    void metaDataModification_Put() {
        MetaData metaData = new MetaData(Collections.emptyMap());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> metaData.put("", (Object)""));
    }

    @Test
    void metaDataModification_Remove() {
        MetaData metaData = new MetaData(Collections.emptyMap());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> metaData.remove((Object)""));
    }

    @Test
    void metaDataModification_PutAll() {
        MetaData metaData = new MetaData(Collections.emptyMap());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> metaData.putAll(Collections.emptyMap()));
    }

    @Test
    void metaDataModification_KeySet_Remove() {
        Set keySet = new MetaData(Collections.emptyMap()).keySet();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> keySet.remove("Hello"));
    }

    @Test
    void metaDataModification_Values_Remove() {
        Collection values = new MetaData(Collections.emptyMap()).values();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> values.remove("Hello"));
    }

    @Test
    void metaDataModification_EntrySet_Remove() {
        Set entrySet = new MetaData(Collections.emptyMap()).entrySet();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> entrySet.remove("Hello"));
    }

    @Test
    void metaDataSubsetReturnsSubsetOfMetaDataInstance() {
        MetaData testMetaData = MetaData.with((String)"firstKey", (Object)"firstValue").and("secondKey", (Object)"secondValue").and("thirdKey", (Object)"thirdValue").and("fourthKey", (Object)"fourthValue");
        MetaData result = testMetaData.subset(new String[]{"secondKey", "fourthKey", "fifthKey"});
        Assertions.assertEquals((Object)"secondValue", (Object)result.get((Object)"secondKey"));
        Assertions.assertEquals((Object)"fourthValue", (Object)result.get((Object)"fourthKey"));
        Assertions.assertNull((Object)result.get((Object)"fifthKey"));
    }
}

