/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.InMemorySequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueueTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InMemorySequencedDeadLetterQueueTest
extends SequencedDeadLetterQueueTest<EventMessage<?>> {
    private static final int MAX_SEQUENCES_AND_SEQUENCE_SIZE = 128;

    InMemorySequencedDeadLetterQueueTest() {
    }

    @Override
    protected SequencedDeadLetterQueue<EventMessage<?>> buildTestSubject() {
        return InMemorySequencedDeadLetterQueue.builder().maxSequences(128).maxSequenceSize(128).build();
    }

    @Override
    protected long maxSequences() {
        return 128L;
    }

    @Override
    protected long maxSequenceSize() {
        return 128L;
    }

    @Override
    public DeadLetter<EventMessage<?>> generateInitialLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", InMemorySequencedDeadLetterQueueTest.generateEvent(), InMemorySequencedDeadLetterQueueTest.generateThrowable());
    }

    @Override
    protected DeadLetter<EventMessage<?>> generateFollowUpLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", InMemorySequencedDeadLetterQueueTest.generateEvent());
    }

    @Override
    protected DeadLetter<EventMessage<?>> generateRequeuedLetter(DeadLetter<EventMessage<?>> original, Instant lastTouched, Throwable requeueCause, MetaData diagnostics) {
        this.setAndGetTime(lastTouched);
        return original.withCause(requeueCause).withDiagnostics(diagnostics).markTouched();
    }

    @Override
    protected void setClock(Clock clock) {
        GenericDeadLetter.clock = clock;
    }

    @Test
    void buildDefaultQueue() {
        Assertions.assertDoesNotThrow(() -> InMemorySequencedDeadLetterQueue.defaultQueue());
    }

    @Test
    void buildWithNegativeMaxSequencesThrowsAxonConfigurationException() {
        InMemorySequencedDeadLetterQueue.Builder builderTestSubject = InMemorySequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequences(-1));
    }

    @Test
    void buildWithZeroMaxSequencesThrowsAxonConfigurationException() {
        InMemorySequencedDeadLetterQueue.Builder builderTestSubject = InMemorySequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequences(0));
    }

    @Test
    void buildWithNegativeMaxSequenceSizeThrowsAxonConfigurationException() {
        InMemorySequencedDeadLetterQueue.Builder builderTestSubject = InMemorySequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequenceSize(-1));
    }

    @Test
    void buildWithZeroMaxSequenceSizeThrowsAxonConfigurationException() {
        InMemorySequencedDeadLetterQueue.Builder builderTestSubject = InMemorySequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.maxSequenceSize(0));
    }
}

